/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.IsolateListenerSupportFeature;
import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.SubstrateSegfaultHandlerStartupHook;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class SubstrateSegfaultHandlerFeature
implements InternalFeature {
    SubstrateSegfaultHandlerFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(IsolateListenerSupportFeature.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (!ImageSingletons.contains(SubstrateSegfaultHandler.class)) {
            return;
        }
        access.registerAsUnsafeAccessed(SubstrateSegfaultHandlerFeature.getStaticFieldWithWellKnownValue());
        SubstrateSegfaultHandler.SingleIsolateSegfaultSetup singleIsolateSegfaultSetup = new SubstrateSegfaultHandler.SingleIsolateSegfaultSetup();
        ImageSingletons.add(SubstrateSegfaultHandler.SingleIsolateSegfaultSetup.class, (Object)singleIsolateSegfaultSetup);
        IsolateListenerSupport.singleton().register(singleIsolateSegfaultSetup);
        RuntimeSupport.getRuntimeSupport().addStartupHook(new SubstrateSegfaultHandlerStartupHook());
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(SubstrateSegfaultHandler.class)) {
            return;
        }
        SubstrateSegfaultHandler.offsetOfStaticFieldWithWellKnownValue = access.objectFieldOffset(SubstrateSegfaultHandlerFeature.getStaticFieldWithWellKnownValue());
    }

    private static Field getStaticFieldWithWellKnownValue() {
        return ReflectionUtil.lookupField(SubstrateSegfaultHandler.class, (String)"staticFieldWithWellKnownValue");
    }
}

