/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaType;

class NativeImageBFDNameProvider
implements UniqueShortNameProvider {
    private final List<ClassLoader> ignoredLoaders;
    private static final String BUILTIN_CLASSLOADER_NAME = "jdk.internal.loader.BuiltinClassLoader";

    NativeImageBFDNameProvider(List<ClassLoader> ignore) {
        this.ignoredLoaders = ignore;
    }

    @Override
    public String uniqueShortName(ClassLoader loader, ResolvedJavaType declaringClass, String methodName, Signature methodSignature, boolean isConstructor) {
        String loaderName = this.uniqueShortLoaderName(loader);
        return this.bfdMangle(loaderName, declaringClass, methodName, methodSignature, isConstructor);
    }

    @Override
    public String uniqueShortName(Member m) {
        return this.bfdMangle(m);
    }

    @Override
    public String uniqueShortLoaderName(ClassLoader loader) {
        if (NativeImageBFDNameProvider.isBuiltinLoader(loader)) {
            return "";
        }
        if (this.isGraalImageLoader(loader)) {
            return "";
        }
        String name = SubstrateUtil.classLoaderNameAndId(loader);
        name = SubstrateUtil.stripPackage(name);
        name = NativeImageBFDNameProvider.stripOuterClass(name);
        name = name.replace(" @", "_");
        return name;
    }

    private String classLoaderNameAndId(ResolvedJavaType type) {
        return this.uniqueShortLoaderName(NativeImageBFDNameProvider.getClassLoader(type));
    }

    private static String stripOuterClass(String name) {
        return name.substring(name.lastIndexOf(36) + 1);
    }

    private static ClassLoader getClassLoader(ResolvedJavaType type) {
        if (type.isPrimitive()) {
            return null;
        }
        if (type.isArray()) {
            return NativeImageBFDNameProvider.getClassLoader(type.getElementalType());
        }
        if (type instanceof HostedType) {
            HostedType hostedType = (HostedType)type;
            return hostedType.getJavaClass().getClassLoader();
        }
        return null;
    }

    private static boolean isBuiltinLoader(ClassLoader loader) {
        if (loader == null) {
            return true;
        }
        Class<?> loaderClazz = loader.getClass();
        do {
            if (!loaderClazz.getName().equals(BUILTIN_CLASSLOADER_NAME)) continue;
            return true;
        } while ((loaderClazz = loaderClazz.getSuperclass()) != Object.class);
        return false;
    }

    private boolean isGraalImageLoader(ClassLoader loader) {
        return this.ignoredLoaders.contains(loader);
    }

    public String bfdMangle(String loaderName, ResolvedJavaType declaringClass, String memberName, Signature methodSignature, boolean isConstructor) {
        return new BFDMangler(this).mangle(loaderName, declaringClass, memberName, methodSignature, isConstructor);
    }

    public String bfdMangle(Member m) {
        return new BFDMangler(this).mangle(m);
    }

    private static class BFDMangler {
        final NativeImageBFDNameProvider nameProvider;
        final StringBuilder sb;
        final List<String> prefixes;

        BFDMangler(NativeImageBFDNameProvider provider) {
            this.nameProvider = provider;
            this.sb = new StringBuilder("_Z");
            this.prefixes = new ArrayList<String>();
        }

        public String mangle(String loaderName, ResolvedJavaType declaringClass, String memberName, Signature methodSignature, boolean isConstructor) {
            String fqn = declaringClass.toJavaName();
            String selector = memberName;
            if (isConstructor) {
                assert (methodSignature != null);
                assert (selector.startsWith("<init>"));
                String replacement = fqn;
                int index = replacement.lastIndexOf(46);
                if (index >= 0) {
                    replacement = fqn.substring(index + 1);
                }
                selector = selector.replace("<init>", replacement);
            }
            this.mangleClassAndMemberName(loaderName, fqn, selector);
            if (methodSignature != null) {
                if (!isConstructor) {
                    this.mangleReturnType(methodSignature, declaringClass);
                }
                this.mangleParams(methodSignature, declaringClass);
            }
            return this.sb.toString();
        }

        public String mangle(Member member) {
            Class<?> declaringClass = member.getDeclaringClass();
            String loaderName = this.nameProvider.uniqueShortLoaderName(declaringClass.getClassLoader());
            String className = declaringClass.getName();
            String selector = member.getName();
            boolean isConstructor = member instanceof Constructor;
            boolean isMethod = member instanceof Method;
            if (isConstructor) {
                assert (selector.equals("<init>"));
                selector = SubstrateUtil.stripPackage(className);
            }
            this.mangleClassAndMemberName(loaderName, className, selector);
            if (isMethod) {
                Method method = (Method)member;
                this.mangleReturnType(method.getReturnType());
            }
            if (isConstructor || isMethod) {
                Executable executable = (Executable)member;
                this.mangleParams(executable.getParameters());
            }
            return this.sb.toString();
        }

        private void mangleSimpleName(String s) {
            assert (!s.startsWith("[0-9]"));
            this.sb.append(s.length());
            this.sb.append(s);
        }

        private void mangleRecordPrefix(String prefix) {
            if (!this.substitutePrefix(prefix)) {
                this.mangleSimpleName(prefix);
                this.recordPrefix(prefix);
            }
        }

        private void manglePrefix(String prefix) {
            if (!this.substitutePrefix(prefix)) {
                this.mangleSimpleName(prefix);
            }
        }

        private boolean substitutePrefix(String prefix) {
            int index = this.prefixIdx(prefix);
            if (index >= 0) {
                this.writePrefix(index);
                return true;
            }
            return false;
        }

        private static boolean encodeLoaderName(String loaderName) {
            return loaderName != null && !loaderName.isEmpty();
        }

        private void mangleClassAndMemberName(String loaderName, String className, String methodName) {
            this.sb.append('N');
            if (BFDMangler.encodeLoaderName(loaderName)) {
                this.mangleRecordPrefix(loaderName);
            }
            this.mangleRecordPrefix(className);
            this.mangleSimpleName(methodName);
            this.sb.append('E');
        }

        private void mangleClassName(String loaderName, String className) {
            boolean encodeLoaderName = BFDMangler.encodeLoaderName(loaderName);
            if (encodeLoaderName) {
                this.sb.append('N');
                this.mangleRecordPrefix(loaderName);
            }
            this.manglePrefix(className);
            if (encodeLoaderName) {
                this.sb.append('E');
            }
        }

        private void mangleReturnType(Signature methodSignature, ResolvedJavaType owner) {
            this.sb.append('J');
            this.mangleType(methodSignature.getReturnType(owner));
        }

        private void mangleReturnType(Class<?> type) {
            this.sb.append('J');
            this.mangleType(type);
        }

        private void mangleParams(Signature methodSignature, ResolvedJavaType owner) {
            int count = methodSignature.getParameterCount(false);
            if (count == 0) {
                this.mangleTypeChar('V');
            } else {
                for (int i = 0; i < count; ++i) {
                    this.mangleType(methodSignature.getParameterType(i, owner));
                }
            }
        }

        private void mangleParams(Parameter[] params) {
            if (params.length == 0) {
                this.mangleTypeChar('V');
            } else {
                for (int i = 0; i < params.length; ++i) {
                    this.mangleType(params[i].getType());
                }
            }
        }

        private void mangleType(JavaType type) {
            if (type instanceof ResolvedJavaType) {
                this.mangleType((ResolvedJavaType)type);
            } else if (type instanceof UnresolvedJavaType) {
                this.mangleType((UnresolvedJavaType)type);
            } else {
                throw VMError.shouldNotReachHere("Unexpected JavaType for " + type);
            }
        }

        private void mangleType(ResolvedJavaType type) {
            if (type.isPrimitive()) {
                this.manglePrimitiveType(type);
            } else if (type.isArray()) {
                this.sb.append('P');
                this.mangleArrayType(type);
            } else {
                this.sb.append('P');
                this.mangleClassName(this.nameProvider.classLoaderNameAndId(type), type.toJavaName());
            }
        }

        private void mangleType(UnresolvedJavaType type) {
            if (type.isArray()) {
                this.sb.append('P');
                this.mangleArrayType(type);
            } else {
                this.sb.append('P');
                this.mangleClassName("", type.toJavaName());
            }
        }

        private void mangleType(Class<?> type) {
            if (type.isPrimitive()) {
                this.manglePrimitiveType(type);
            } else if (type.isArray()) {
                this.sb.append('P');
                this.mangleArrayType(type);
            } else {
                this.sb.append('P');
                this.mangleClassName(this.nameProvider.uniqueShortLoaderName(type.getClassLoader()), type.getName());
            }
        }

        private void mangleArrayType(ResolvedJavaType arrayType) {
            int count = 1;
            ResolvedJavaType baseType = arrayType.getComponentType();
            while (baseType.isArray()) {
                ++count;
                baseType = baseType.getComponentType();
            }
            String loaderName = this.nameProvider.classLoaderNameAndId(baseType);
            this.mangleArrayName(loaderName, baseType.toJavaName(), count);
        }

        private void mangleArrayType(UnresolvedJavaType arrayType) {
            int count = 1;
            JavaType baseType = arrayType.getComponentType();
            while (baseType.isArray()) {
                ++count;
                baseType = baseType.getComponentType();
            }
            this.mangleArrayName("", baseType.toJavaName(), count);
        }

        private void mangleArrayType(Class<?> arrayType) {
            int count = 1;
            Class<?> baseType = arrayType.getComponentType();
            while (baseType.isArray()) {
                baseType = baseType.getComponentType();
            }
            String loaderName = this.nameProvider.uniqueShortLoaderName(baseType.getClassLoader());
            this.mangleArrayName(loaderName, baseType.getName(), count);
        }

        private void mangleArrayName(String loaderName, String baseName, int dims) {
            int len = baseName.length() + dims * 2;
            boolean encodeLoaderName = BFDMangler.encodeLoaderName(loaderName);
            if (encodeLoaderName) {
                this.sb.append("N");
                this.mangleRecordPrefix(loaderName);
            }
            this.sb.append(len);
            this.sb.append(baseName);
            for (int i = 0; i < dims; ++i) {
                this.sb.append("[]");
            }
            if (encodeLoaderName) {
                this.sb.append("E");
            }
        }

        private void manglePrimitiveType(ResolvedJavaType type) {
            char c = type.getJavaKind().getTypeChar();
            this.mangleTypeChar(c);
        }

        private void manglePrimitiveType(Class<?> type) {
            char c = JavaKind.fromJavaClass(type).getTypeChar();
            this.mangleTypeChar(c);
        }

        private void mangleTypeChar(char c) {
            switch (c) {
                case 'Z': {
                    this.sb.append('b');
                    return;
                }
                case 'B': {
                    this.sb.append('a');
                    return;
                }
                case 'S': {
                    this.sb.append('s');
                    return;
                }
                case 'C': {
                    this.sb.append('t');
                    return;
                }
                case 'I': {
                    this.sb.append('i');
                    return;
                }
                case 'J': {
                    this.sb.append('l');
                    return;
                }
                case 'F': {
                    this.sb.append('f');
                    return;
                }
                case 'D': {
                    this.sb.append('d');
                    return;
                }
                case 'V': {
                    this.sb.append('v');
                    return;
                }
            }
            assert (false) : "invalid kind for primitive type " + c;
        }

        private void writePrefix(int i) {
            this.sb.append('S');
            if (i > 36) {
                this.sb.append(BFDMangler.b36((i - 1) / 36));
                this.sb.append(BFDMangler.b36((i - 1) % 36));
            } else if (i > 0) {
                this.sb.append(BFDMangler.b36(i - 1));
            }
            this.sb.append('_');
        }

        private static char b36(int i) {
            if (i < 10) {
                return (char)(48 + i);
            }
            return (char)(65 + (i - 10));
        }

        private void recordPrefix(String prefix) {
            this.prefixes.add(prefix);
        }

        private int prefixIdx(String prefix) {
            return this.prefixes.indexOf(prefix);
        }
    }
}

