/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.MissingRegistrationSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.ExitStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.MissingReflectionRegistrationError;
import sun.misc.Unsafe;

public final class MissingReflectionRegistrationUtils {
    private static final int CONTEXT_LINES = 4;
    private static final Set<String> seenOutputs = Options.MissingRegistrationReportingMode.getValue() == ReportingMode.Warn ? ConcurrentHashMap.newKeySet() : null;
    private static final Map<String, Set<String>> reflectionEntryPoints = Map.of(Class.class.getTypeName(), Set.of("forName", "getClasses", "getDeclaredClasses", "getConstructor", "getConstructors", "getDeclaredConstructor", "getDeclaredConstructors", "getField", "getFields", "getDeclaredField", "getDeclaredFields", "getMethod", "getMethods", "getDeclaredMethod", "getDeclaredMethods", "getNestMembers", "getPermittedSubclasses", "getRecordComponents", "getSigners", "arrayType", "newInstance"), Method.class.getTypeName(), Set.of("invoke"), Constructor.class.getTypeName(), Set.of("newInstance"), "java.lang.reflect.ReflectAccess", Set.of("newInstance"), "jdk.internal.access.JavaLangAccess", Set.of("getDeclaredPublicMethods"), Unsafe.class.getName(), Set.of("allocateInstance"), SubstrateAllocationSnippets.class.getName(), Set.of("instanceHubErrorStub"));

    public static boolean throwMissingRegistrationErrors() {
        return SubstrateOptions.ThrowMissingRegistrationErrors.hasBeenSet();
    }

    public static ReportingMode missingRegistrationReportingMode() {
        return Options.MissingRegistrationReportingMode.getValue();
    }

    public static void forClass(String className) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access class", className), Class.class, null, className, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static void forField(Class<?> declaringClass, String fieldName) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access field", declaringClass.getTypeName() + "#" + fieldName), Field.class, declaringClass, fieldName, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static void forMethod(Class<?> declaringClass, String methodName, Class<?>[] paramTypes) {
        StringJoiner paramTypeNames = new StringJoiner(", ", "(", ")");
        for (Class<?> paramType : paramTypes) {
            paramTypeNames.add(paramType.getTypeName());
        }
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access method", declaringClass.getTypeName() + "#" + methodName + paramTypeNames), Method.class, declaringClass, methodName, (Class[])paramTypes);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static void forQueriedOnlyExecutable(Executable executable) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("invoke method", executable.toString()), executable.getClass(), executable.getDeclaringClass(), executable.getName(), (Class[])executable.getParameterTypes());
        MissingReflectionRegistrationUtils.report(exception);
        throw exception;
    }

    public static void forBulkQuery(Class<?> declaringClass, String methodName) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access", declaringClass.getTypeName() + "." + methodName + "()"), null, declaringClass, methodName, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    private static String errorMessage(String failedAction, String elementDescriptor) {
        return "The program tried to reflectively " + failedAction + " " + elementDescriptor + " without it being registered for runtime reflection. Add it to the reflection metadata to solve this problem. See https://www.graalvm.org/latest/reference-manual/native-image/metadata/#reflection for help.";
    }

    private static void report(MissingReflectionRegistrationError exception) {
        StackTraceElement responsibleClass = MissingReflectionRegistrationUtils.getResponsibleClass((Throwable)exception);
        if (responsibleClass != null && !MissingRegistrationSupport.singleton().reportMissingRegistrationErrors(responsibleClass)) {
            return;
        }
        switch (MissingReflectionRegistrationUtils.missingRegistrationReportingMode()) {
            case Throw: {
                throw exception;
            }
            case Exit: {
                exception.printStackTrace(System.out);
                System.exit(ExitStatus.MISSING_METADATA.getValue());
                break;
            }
            case ExitTest: {
                throw new ExitException((Throwable)exception);
            }
            case Warn: {
                String output;
                StackTraceElement[] stackTrace = exception.getStackTrace();
                int printed = 0;
                StackTraceElement entryPoint = null;
                StringBuilder sb = new StringBuilder(exception.toString());
                sb.append("\n");
                for (StackTraceElement stackTraceElement : stackTrace) {
                    if (printed == 0) {
                        String moduleName = stackTraceElement.getModuleName();
                        if (moduleName != null && (moduleName.equals("java.base") || moduleName.startsWith("org.graalvm"))) {
                            entryPoint = stackTraceElement;
                        } else {
                            MissingReflectionRegistrationUtils.printLine(sb, entryPoint);
                            ++printed;
                        }
                    }
                    if (printed > 0) {
                        MissingReflectionRegistrationUtils.printLine(sb, stackTraceElement);
                        ++printed;
                    }
                    if (printed >= 4) break;
                }
                if (seenOutputs.isEmpty()) {
                    System.out.println("Note: this run will print partial stack traces of the locations where a MissingReflectionRegistrationError would be thrown when the -H:+ThrowMissingRegistrationErrors option is set. The trace stops at the first entry of JDK code and provides 4 lines of context.");
                }
                if (!seenOutputs.add(output = sb.toString())) break;
                System.out.print(output);
            }
        }
    }

    private static void printLine(StringBuilder sb, Object object) {
        sb.append("  ").append(object).append(System.lineSeparator());
    }

    private static StackTraceElement getResponsibleClass(Throwable t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        boolean returnNext = false;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (reflectionEntryPoints.getOrDefault(stackTraceElement.getClassName(), Set.of()).contains(stackTraceElement.getMethodName())) {
                returnNext = true;
                continue;
            }
            if (!returnNext) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static class Options {
        public static final HostedOptionKey<ReportingMode> MissingRegistrationReportingMode = new HostedOptionKey<ReportingMode>(ReportingMode.Throw);
    }

    public static enum ReportingMode {
        Warn,
        Throw,
        ExitTest,
        Exit;

    }

    public static final class ExitException
    extends Error {
        private static final long serialVersionUID = -3638940737396726143L;

        private ExitException(Throwable cause) {
            super(cause);
        }
    }
}

