/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.OptionOrigin;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class OptionClassFilter {
    private final Set<OptionOrigin> reasonCommandLine = Collections.singleton(OptionOrigin.commandLineOptionOriginSingleton);
    private final Map<String, Set<OptionOrigin>> requireCompletePackageOrClass;
    private final Set<Module> requireCompleteModules;
    private boolean requireCompleteAll;

    public OptionClassFilter(Map<String, Set<OptionOrigin>> requireCompletePackageOrClass, Set<Module> requireCompleteModules, boolean requireCompleteAll) {
        this.requireCompletePackageOrClass = requireCompletePackageOrClass;
        this.requireCompleteModules = requireCompleteModules;
        this.requireCompleteAll = requireCompleteAll;
    }

    public Object isIncluded(Class<?> clazz) {
        Module module = clazz.getModule();
        return this.isIncluded(module.isNamed() ? module.getName() : null, clazz.getPackageName(), clazz.getName());
    }

    public Object isIncluded(String moduleName, String packageName, String className) {
        Set<OptionOrigin> origins;
        if (this.requireCompleteAll) {
            return this.reasonCommandLine;
        }
        if (moduleName != null) {
            for (Module module : this.requireCompleteModules) {
                if (!module.getName().equals(moduleName)) continue;
                return module.toString();
            }
        }
        if ((origins = this.requireCompletePackageOrClass.get(className)) != null) {
            return origins;
        }
        return this.requireCompletePackageOrClass.get(packageName);
    }

    public void addPackageOrClass(String packageOrClass, Set<OptionOrigin> reason) {
        this.requireCompletePackageOrClass.put(packageOrClass, reason);
    }
}

