/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AdaptiveCollectionPolicy;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

class AggressiveShrinkCollectionPolicy
extends AdaptiveCollectionPolicy {
    protected static final UnsignedWord INITIAL_HEAP_SIZE = WordFactory.unsigned((int)0x4000000);
    protected static final UnsignedWord FULL_GC_BONUS = WordFactory.unsigned((int)0x200000);
    private UnsignedWord sizeBefore = (UnsignedWord)WordFactory.zero();
    private GCCause lastGCCause = null;

    AggressiveShrinkCollectionPolicy() {
    }

    @Override
    public boolean shouldCollectOnRequest(GCCause cause, boolean fullGC) {
        if (cause == GCCause.HintedGC) {
            this.guaranteeSizeParametersInitialized();
            UnsignedWord edenUsedBytes = HeapImpl.getHeapImpl().getAccounting().getEdenUsedBytes();
            if (fullGC) {
                edenUsedBytes = edenUsedBytes.add(FULL_GC_BONUS);
            }
            return edenUsedBytes.aboveOrEqual(Options.ExpectedEdenSize.getValue().intValue()) || UnsignedUtils.toDouble(edenUsedBytes) / UnsignedUtils.toDouble(this.edenSize) >= Options.UsedEdenProportionThreshold.getValue();
        }
        return super.shouldCollectOnRequest(cause, fullGC);
    }

    @Override
    protected UnsignedWord getInitialHeapSize() {
        return INITIAL_HEAP_SIZE;
    }

    @Override
    public void onCollectionBegin(boolean completeCollection, long requestingNanoTime) {
        this.sizeBefore = GCImpl.getChunkBytes();
        super.onCollectionBegin(completeCollection, requestingNanoTime);
    }

    @Override
    public void onCollectionEnd(boolean completeCollection, GCCause cause) {
        super.onCollectionEnd(completeCollection, cause);
        this.sizeBefore = (UnsignedWord)WordFactory.zero();
        this.lastGCCause = cause;
    }

    @Override
    protected boolean shouldUpdateStats(GCCause cause) {
        return cause == GCCause.HintedGC || super.shouldUpdateStats(cause);
    }

    @Override
    protected void computeEdenSpaceSize(boolean completeCollection, GCCause cause) {
        if (cause == GCCause.HintedGC) {
            UnsignedWord newEdenSize;
            if (completeCollection && this.lastGCCause == GCCause.HintedGC && this.edenSize.aboveThan(newEdenSize = UnsignedUtils.max(this.sizes.initialEdenSize, AggressiveShrinkCollectionPolicy.alignUp(this.edenSize.unsignedDivide(2))))) {
                this.edenSize = newEdenSize;
            }
        } else {
            UnsignedWord sizeAfter = GCImpl.getChunkBytes();
            if (this.sizeBefore.notEqual(0) && this.sizeBefore.belowThan(sizeAfter.multiply(2))) {
                this.edenSize = AggressiveShrinkCollectionPolicy.alignUp(this.edenSize.multiply(2));
            } else {
                super.computeEdenSpaceSize(completeCollection, cause);
            }
        }
    }

    public static final class Options {
        public static final HostedOptionKey<Double> UsedEdenProportionThreshold = new HostedOptionKey<Double>(0.75);
        public static final HostedOptionKey<Integer> ExpectedEdenSize = new HostedOptionKey<Integer>(0x2000000);
    }
}

