/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.util.VMError;
import java.util.List;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;

public class VerifyNoGuardsPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        List guards = graph.getNodes(GuardNode.TYPE).snapshot();
        if (guards.size() > 0) {
            throw VMError.shouldNotReachHere("Graph contains GuardNode: method " + graph.method() + ", guards " + guards.toString());
        }
        List fixedGuards = graph.getNodes(FixedGuardNode.TYPE).snapshot();
        if (fixedGuards.size() > 0) {
            throw VMError.shouldNotReachHere("Graph contains FixedGuardNode: method " + graph.method() + ", guards " + fixedGuards.toString());
        }
    }
}

