/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.reflect.ReflectionMetadataDecoder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.util.json.JsonWriter;
import com.oracle.svm.hosted.BuildArtifactsExporter;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemIOWrappers;
import com.oracle.svm.hosted.ProgressReporterCHelper;
import com.oracle.svm.hosted.ProgressReporterFeature;
import com.oracle.svm.hosted.ProgressReporterJsonHelper;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.util.CPUType;
import com.oracle.svm.hosted.util.VMErrorReporter;
import com.oracle.svm.util.ImageBuildStatistics;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ImageSingletonsSupport;

public class ProgressReporter {
    private static final boolean IS_CI = SubstrateUtil.isRunningInCI();
    private static final int CHARACTERS_PER_LINE = IS_CI ? 120 : ProgressReporterCHelper.getTerminalWindowColumnsClamped();
    private static final String HEADLINE_SEPARATOR = Utils.stringFilledWith(CHARACTERS_PER_LINE, "=");
    private static final String LINE_SEPARATOR = Utils.stringFilledWith(CHARACTERS_PER_LINE, "-");
    private static final int MAX_NUM_BREAKDOWN = 10;
    public static final String STAGE_DOCS_URL = "https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/BuildOutput.md";
    private static final double EXCESSIVE_GC_MIN_THRESHOLD_MILLIS = 15000.0;
    private static final double EXCESSIVE_GC_RATIO = 0.5;
    private static final String BREAKDOWN_BYTE_ARRAY_PREFIX = "byte[] for ";
    private final NativeImageSystemIOWrappers builderIO;
    public final ProgressReporterJsonHelper jsonHelper;
    private final DirectPrinter linePrinter = new DirectPrinter();
    private final StringBuilder buildOutputLog = new StringBuilder();
    private final StagePrinter<?> stagePrinter;
    private final ColorStrategy colorStrategy;
    private final LinkStrategy linkStrategy;
    private final boolean usePrefix;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, Long> codeBreakdown = new HashMap<String, Long>();
    private final Map<String, Long> heapBreakdown = new HashMap<String, Long>();
    private String outputPrefix = "";
    private long lastGCCheckTimeMillis = System.currentTimeMillis();
    private GCStats lastGCStats = GCStats.getCurrent();
    private long numRuntimeCompiledMethods = -1L;
    private long graphEncodingByteLength = -1L;
    private int numJNIClasses = -1;
    private int numJNIFields = -1;
    private int numJNIMethods = -1;
    private Timer debugInfoTimer;
    private boolean creationStageEndCompleted = false;
    private boolean reportStringBytes = true;

    public static ProgressReporter singleton() {
        return (ProgressReporter)ImageSingletons.lookup(ProgressReporter.class);
    }

    public ProgressReporter(OptionValues options) {
        this.builderIO = (Boolean)SubstrateOptions.BuildOutputSilent.getValue(options) != false ? NativeImageSystemIOWrappers.disabled() : NativeImageSystemIOWrappers.singleton();
        this.jsonHelper = new ProgressReporterJsonHelper();
        this.usePrefix = (Boolean)SubstrateOptions.BuildOutputPrefix.getValue(options);
        boolean enableColors = (Boolean)SubstrateOptions.BuildOutputColorful.getValue(options);
        this.colorStrategy = enableColors ? new ColorfulStrategy() : new ColorlessStrategy();
        this.stagePrinter = (Boolean)SubstrateOptions.BuildOutputProgress.getValue(options) != false ? new CharacterwiseStagePrinter() : new LinewiseStagePrinter();
        this.linkStrategy = (Boolean)SubstrateOptions.BuildOutputLinks.getValue(options) != false ? new LinkyStrategy() : new LinklessStrategy();
    }

    public void setNumRuntimeCompiledMethods(int value) {
        this.numRuntimeCompiledMethods = value;
    }

    public void setGraphEncodingByteLength(int value) {
        this.graphEncodingByteLength = value;
    }

    public void setJNIInfo(int numClasses, int numFields, int numMethods) {
        this.numJNIClasses = numClasses;
        this.numJNIFields = numFields;
        this.numJNIMethods = numMethods;
    }

    public void disableStringBytesReporting() {
        this.reportStringBytes = false;
    }

    public void printStart(String imageName, AbstractImage.NativeImageKind imageKind) {
        if (this.usePrefix) {
            this.outputPrefix = String.format("[%s:%s] ", imageName, GraalServices.getExecutionID());
            this.stagePrinter.progressBarStart += this.outputPrefix.length();
        }
        this.l().printHeadlineSeparator();
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.IMAGE_NAME, imageName);
        String imageKindName = imageKind.name().toLowerCase().replace('_', ' ');
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().blueBold()).link("GraalVM Native Image", "https://www.graalvm.org/native-image/")).reset()).a(": Generating '").bold()).a(imageName).reset()).a("' (").doclink(imageKindName, "#glossary-imagekind")).a(")...").println();
        this.l().printHeadlineSeparator();
        this.stagePrinter.start(BuildStage.INITIALIZING);
    }

    public void printUnsuccessfulInitializeEnd() {
        if (this.stagePrinter.activeBuildStage != null) {
            this.stagePrinter.end(0.0);
        }
    }

    public void printInitializeEnd() {
        this.stagePrinter.end(ProgressReporter.getTimer(TimerCollection.Registry.CLASSLIST).getTotalTime() + ProgressReporter.getTimer(TimerCollection.Registry.SETUP).getTotalTime());
        VM vm = (VM)ImageSingletons.lookup(VM.class);
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.JAVA_VERSION, vm.version);
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.VENDOR_VERSION, vm.vendorVersion);
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.GRAALVM_VERSION, vm.vendorVersion);
        ((DirectPrinter)((DirectPrinter)this.l().a(" ").doclink("Java version", "#glossary-java-info")).a(": ").a(vm.version).a(", ").doclink("vendor version", "#glossary-java-info")).a(": ").a(vm.vendorVersion).println();
        String optimizationLevel = SubstrateOptions.Optimize.getValue();
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.GRAAL_COMPILER_OPTIMIZATION_LEVEL, optimizationLevel);
        String march = CPUType.getSelectedOrDefaultMArch();
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.GRAAL_COMPILER_MARCH, march);
        DirectPrinter graalLine = (DirectPrinter)((DirectPrinter)this.l().a(" ").doclink("Graal compiler", "#glossary-graal-compiler")).a(": optimization level: %s, target machine: %s", optimizationLevel, march);
        ((ProgressReporterFeature)ImageSingletons.lookup(ProgressReporterFeature.class)).appendGraalSuffix(graalLine);
        graalLine.println();
        String cCompilerShort = null;
        if (ImageSingletons.contains(CCompilerInvoker.class)) {
            cCompilerShort = ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).compilerInfo.getShortDescription();
            ((DirectPrinter)this.l().a(" ").doclink("C compiler", "#glossary-ccompiler")).a(": ").a(cCompilerShort).println();
        }
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.CC, cCompilerShort);
        String gcName = Heap.getHeap().getGC().getName();
        this.recordJsonMetric(ProgressReporterJsonHelper.GeneralInfo.GC, gcName);
        long maxHeapSize = SubstrateGCOptions.MaxHeapSize.getValue();
        String maxHeapValue = maxHeapSize == 0L ? Heap.getHeap().getGC().getDefaultMaxHeapSize() : ByteFormattingUtil.bytesToHuman(maxHeapSize);
        ((DirectPrinter)((DirectPrinter)this.l().a(" ").doclink("Garbage collector", "#glossary-gc")).a(": ").a(gcName).a(" (").doclink("max heap size", "#glossary-gc-max-heap-size")).a(": ").a(maxHeapValue).a(")").println();
    }

    public void printFeatures(List<Feature> features) {
        int numFeatures = features.size();
        if (numFeatures > 0) {
            ((DirectPrinter)((DirectPrinter)this.l().a(" ").a(numFeatures)).a(" ").doclink("user-specific feature(s)", "#glossary-user-specific-features")).println();
            features.sort((a, b) -> a.getClass().getName().compareTo(b.getClass().getName()));
            for (Feature feature : features) {
                ProgressReporter.printFeature(this.l(), feature);
            }
        }
    }

    private static void printFeature(DirectPrinter printer, Feature feature) {
        printer.a(" - ");
        String name = feature.getClass().getName();
        String url = feature.getURL();
        if (url != null) {
            printer.link(name, url);
        } else {
            printer.a(name);
        }
        String description = feature.getDescription();
        if (description != null) {
            printer.a(": ").a(description);
        }
        printer.println();
    }

    public ReporterClosable printAnalysis(AnalysisUniverse universe, Collection<String> libraries) {
        return this.print(TimerCollection.Registry.ANALYSIS, BuildStage.ANALYSIS, () -> this.printAnalysisStatistics(universe, libraries));
    }

    private ReporterClosable print(TimerCollection.Registry registry, BuildStage buildStage) {
        return this.print(registry, buildStage, null);
    }

    private ReporterClosable print(TimerCollection.Registry registry, BuildStage buildStage, final Runnable extraPrint) {
        final Timer timer = ProgressReporter.getTimer(registry);
        timer.start();
        this.stagePrinter.start(buildStage);
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.stagePrinter.end(timer);
                if (extraPrint != null) {
                    extraPrint.run();
                }
            }
        };
    }

    private void printAnalysisStatistics(AnalysisUniverse universe, Collection<String> libraries) {
        int numLibraries;
        String actualVsTotalFormat = "%,8d (%5.2f%%) of %,6d";
        long reachableTypes = universe.getTypes().stream().filter(t -> t.isReachable()).count();
        long totalTypes = universe.getTypes().size();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.TYPES_TOTAL, totalTypes);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.DEPRECATED_CLASS_TOTAL, totalTypes);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.TYPES_REACHABLE, reachableTypes);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.DEPRECATED_CLASS_REACHABLE, reachableTypes);
        ((DirectPrinter)((DirectPrinter)this.l().a(actualVsTotalFormat, reachableTypes, (double)reachableTypes / (double)totalTypes * 100.0, totalTypes)).a(" types ").doclink("reachable", "#glossary-reachability")).println();
        Collection fields = universe.getFields();
        long reachableFields = fields.stream().filter(f -> f.isAccessed()).count();
        int totalFields = fields.size();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FIELD_TOTAL, totalFields);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FIELD_REACHABLE, reachableFields);
        ((DirectPrinter)((DirectPrinter)this.l().a(actualVsTotalFormat, reachableFields, (double)reachableFields / (double)totalFields * 100.0, totalFields)).a(" fields ").doclink("reachable", "#glossary-reachability")).println();
        Collection methods = universe.getMethods();
        long reachableMethods = methods.stream().filter(m -> m.isReachable()).count();
        int totalMethods = methods.size();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.METHOD_TOTAL, totalMethods);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.METHOD_REACHABLE, reachableMethods);
        ((DirectPrinter)((DirectPrinter)this.l().a(actualVsTotalFormat, reachableMethods, (double)reachableMethods / (double)totalMethods * 100.0, totalMethods)).a(" methods ").doclink("reachable", "#glossary-reachability")).println();
        if (this.numRuntimeCompiledMethods >= 0L) {
            this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.RUNTIME_COMPILED_METHODS_COUNT, this.numRuntimeCompiledMethods);
            ((DirectPrinter)((DirectPrinter)this.l().a(actualVsTotalFormat, this.numRuntimeCompiledMethods, (double)this.numRuntimeCompiledMethods / (double)totalMethods * 100.0, totalMethods)).a(" methods included for ").doclink("runtime compilation", "#glossary-runtime-methods")).println();
        }
        String typesFieldsMethodFormat = "%,8d types, %,5d fields, and %,5d methods ";
        int reflectClassesCount = ClassForNameSupport.count();
        ReflectionHostedSupport rs = (ReflectionHostedSupport)ImageSingletons.lookup(ReflectionHostedSupport.class);
        int reflectFieldsCount = rs.getReflectionFieldsCount();
        int reflectMethodsCount = rs.getReflectionMethodsCount();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.METHOD_REFLECT, reflectMethodsCount);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.TYPES_REFLECT, reflectClassesCount);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.DEPRECATED_CLASS_REFLECT, reflectClassesCount);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FIELD_REFLECT, reflectFieldsCount);
        ((DirectPrinter)((DirectPrinter)this.l().a(typesFieldsMethodFormat, reflectClassesCount, reflectFieldsCount, reflectMethodsCount)).doclink("registered for reflection", "#glossary-reflection-registrations")).println();
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.METHOD_JNI, this.numJNIMethods >= 0 ? (long)this.numJNIMethods : -1L);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.TYPES_JNI, this.numJNIClasses >= 0 ? (long)this.numJNIClasses : -1L);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.DEPRECATED_CLASS_JNI, this.numJNIClasses >= 0 ? (long)this.numJNIClasses : -1L);
        this.recordJsonMetric(ProgressReporterJsonHelper.AnalysisResults.FIELD_JNI, this.numJNIFields >= 0 ? (long)this.numJNIFields : -1L);
        if (this.numJNIClasses >= 0) {
            ((DirectPrinter)((DirectPrinter)this.l().a(typesFieldsMethodFormat, this.numJNIClasses, this.numJNIFields, this.numJNIMethods)).doclink("registered for JNI access", "#glossary-jni-access-registrations")).println();
        }
        if ((numLibraries = libraries.size()) > 0) {
            TreeSet<String> sortedLibraries = new TreeSet<String>(libraries);
            ((DirectPrinter)this.l().a("%,8d native %s: ", numLibraries, numLibraries == 1 ? "library" : "libraries")).a(String.join((CharSequence)", ", sortedLibraries)).println();
        }
    }

    public ReporterClosable printUniverse() {
        return this.print(TimerCollection.Registry.UNIVERSE, BuildStage.UNIVERSE);
    }

    public ReporterClosable printParsing() {
        return this.print(TimerCollection.Registry.PARSE, BuildStage.PARSING);
    }

    public ReporterClosable printInlining() {
        return this.print(TimerCollection.Registry.INLINE, BuildStage.INLINING);
    }

    public ReporterClosable printCompiling() {
        return this.print(TimerCollection.Registry.COMPILE, BuildStage.COMPILING);
    }

    public ReporterClosable printLayouting() {
        return this.print(TimerCollection.Registry.LAYOUT, BuildStage.LAYOUTING);
    }

    public void printCreationStart() {
        this.stagePrinter.start(BuildStage.CREATING);
    }

    public void setDebugInfoTimer(Timer timer) {
        this.debugInfoTimer = timer;
    }

    public void printCreationEnd(int imageFileSize, int numHeapObjects, long imageHeapSize, int codeAreaSize, int numCompilations, int debugInfoSize) {
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.IMAGE_HEAP_OBJECT_COUNT, numHeapObjects);
        Timer imageTimer = ProgressReporter.getTimer(TimerCollection.Registry.IMAGE);
        Timer writeTimer = ProgressReporter.getTimer(TimerCollection.Registry.WRITE);
        this.stagePrinter.end(imageTimer.getTotalTime() + writeTimer.getTotalTime());
        this.creationStageEndCompleted = true;
        String format = "%9s (%5.2f%%) for ";
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(format, ByteFormattingUtil.bytesToHuman(codeAreaSize), (double)codeAreaSize / (double)imageFileSize * 100.0)).doclink("code area", "#glossary-code-area")).a(":%,10d compilation units", numCompilations)).println();
        int numResources = Resources.singleton().count();
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.IMAGE_HEAP_RESOURCE_COUNT, numResources);
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(format, ByteFormattingUtil.bytesToHuman(imageHeapSize), (double)imageHeapSize / (double)imageFileSize * 100.0)).doclink("image heap", "#glossary-image-heap")).a(":%,9d objects and %,d resources", numHeapObjects, numResources)).println();
        if (debugInfoSize > 0) {
            this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.DEBUG_INFO_SIZE, debugInfoSize);
            DirectPrinter l = (DirectPrinter)((DirectPrinter)this.l().a(format, ByteFormattingUtil.bytesToHuman(debugInfoSize), (double)debugInfoSize / (double)imageFileSize * 100.0)).doclink("debug info", "#glossary-debug-info");
            if (this.debugInfoTimer != null) {
                l.a(" generated in %.1fs", Utils.millisToSeconds(this.debugInfoTimer.getTotalTime()));
            }
            l.println();
        }
        long otherBytes = (long)(imageFileSize - codeAreaSize) - imageHeapSize - (long)debugInfoSize;
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.IMAGE_HEAP_SIZE, imageHeapSize);
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.TOTAL_SIZE, imageFileSize);
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.CODE_AREA_SIZE, codeAreaSize);
        this.recordJsonMetric(ProgressReporterJsonHelper.ImageDetailKey.NUM_COMP_UNITS, numCompilations);
        ((DirectPrinter)((DirectPrinter)this.l().a(format, ByteFormattingUtil.bytesToHuman(otherBytes), (double)otherBytes / (double)imageFileSize * 100.0)).doclink("other data", "#glossary-other-data")).println();
        ((DirectPrinter)this.l().a("%9s in total", ByteFormattingUtil.bytesToHuman(imageFileSize))).println();
        this.printBreakdowns();
        this.printRecommendations();
    }

    public void ensureCreationStageEndCompleted() {
        if (!this.creationStageEndCompleted) {
            this.println();
        }
    }

    public void createBreakdowns(HostedMetaAccess metaAccess, Collection<CompileQueue.CompileTask> compilationTasks, Collection<NativeImageHeap.ObjectInfo> heapObjects) {
        if (!SubstrateOptions.BuildOutputBreakdowns.getValue().booleanValue()) {
            return;
        }
        this.calculateCodeBreakdown(compilationTasks);
        this.calculateHeapBreakdown(metaAccess, heapObjects);
    }

    private void calculateCodeBreakdown(Collection<CompileQueue.CompileTask> compilationTasks) {
        for (CompileQueue.CompileTask task : compilationTasks) {
            String key = null;
            Class<?> javaClass = task.method.getDeclaringClass().getJavaClass();
            Module module = javaClass.getModule();
            if (module.isNamed()) {
                key = module.getName();
                if ("org.graalvm.nativeimage.builder".equals(key)) {
                    key = "svm.jar (Native Image)";
                }
            } else {
                key = ProgressReporter.findJARFile(javaClass);
                if (key == null) {
                    key = ProgressReporter.findPackageOrClassName(task.method);
                }
            }
            this.codeBreakdown.merge(key, Long.valueOf(task.result.getTargetCodeSize()), Long::sum);
        }
    }

    private static String findJARFile(Class<?> javaClass) {
        String path;
        CodeSource codeSource = javaClass.getProtectionDomain().getCodeSource();
        if (codeSource != null && codeSource.getLocation() != null && (path = codeSource.getLocation().getPath()).endsWith(".jar")) {
            return path.substring(Math.max(path.lastIndexOf(47) + 1, path.lastIndexOf(92) + 1));
        }
        return null;
    }

    private static String findPackageOrClassName(HostedMethod method) {
        String qualifier = method.format("%H");
        int lastDotIndex = qualifier.lastIndexOf(46);
        if (lastDotIndex > 0) {
            qualifier = qualifier.substring(0, lastDotIndex);
        }
        return qualifier;
    }

    private void calculateHeapBreakdown(HostedMetaAccess metaAccess, Collection<NativeImageHeap.ObjectInfo> heapObjects) {
        ProgressReporter.calculateHeapBreakdown(this.heapBreakdown, this.linkStrategy, metaAccess, heapObjects, this.reportStringBytes, this.graphEncodingByteLength, this::recordJsonMetric);
    }

    public void calculateHeapBreakdown(Map<String, Long> breakdown, LinkStrategy strategy, HostedMetaAccess metaAccess, Collection<NativeImageHeap.ObjectInfo> heapObjects) {
        ProgressReporter.calculateHeapBreakdown(breakdown, strategy, metaAccess, heapObjects, this.reportStringBytes, this.graphEncodingByteLength, (k, v) -> {});
    }

    public static void calculateHeapBreakdown(Map<String, Long> heapBreakdown, LinkStrategy linkStrategy, HostedMetaAccess metaAccess, Collection<NativeImageHeap.ObjectInfo> heapObjects, boolean reportStringBytes, long graphEncodingByteLength, BiConsumer<ProgressReporterJsonHelper.JsonMetric, Object> jsonMetricAction) {
        long stringByteLength = 0L;
        for (NativeImageHeap.ObjectInfo o : heapObjects) {
            heapBreakdown.merge(o.getClazz().toJavaName(true), o.getSize(), Long::sum);
            JavaConstant javaObject = o.getConstant();
            if (!reportStringBytes || !metaAccess.isInstanceOf(javaObject, String.class)) continue;
            stringByteLength += (long)Utils.getInternalByteArrayLength((String)SubstrateObjectConstant.asObject((Constant)javaObject));
        }
        Long byteArraySize = heapBreakdown.remove("byte[]");
        if (byteArraySize != null) {
            long metadataByteLength;
            long codeInfoSize;
            long remainingBytes = byteArraySize;
            if (stringByteLength > 0L) {
                heapBreakdown.put("byte[] for java.lang.String", stringByteLength);
                remainingBytes -= stringByteLength;
            }
            if ((codeInfoSize = CodeInfoTable.getImageCodeCache().getTotalByteArraySize()) > 0L) {
                heapBreakdown.put(BREAKDOWN_BYTE_ARRAY_PREFIX + linkStrategy.asDocLink("code metadata", "#glossary-code-metadata"), codeInfoSize);
                remainingBytes -= codeInfoSize;
            }
            if ((metadataByteLength = ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).getMetadataByteLength()) > 0L) {
                heapBreakdown.put(BREAKDOWN_BYTE_ARRAY_PREFIX + linkStrategy.asDocLink("reflection metadata", "#glossary-reflection-metadata"), metadataByteLength);
                remainingBytes -= metadataByteLength;
            }
            long resourcesByteLength = 0L;
            for (ResourceStorageEntry resourceList : Resources.singleton().resources()) {
                for (byte[] resource : resourceList.getData()) {
                    resourcesByteLength += (long)resource.length;
                }
            }
            jsonMetricAction.accept(ProgressReporterJsonHelper.ImageDetailKey.RESOURCE_SIZE_BYTES, resourcesByteLength);
            if (resourcesByteLength > 0L) {
                heapBreakdown.put(BREAKDOWN_BYTE_ARRAY_PREFIX + linkStrategy.asDocLink("embedded resources", "#glossary-embedded-resources"), resourcesByteLength);
                remainingBytes -= resourcesByteLength;
            }
            if (graphEncodingByteLength >= 0L) {
                jsonMetricAction.accept(ProgressReporterJsonHelper.ImageDetailKey.GRAPH_ENCODING_SIZE, graphEncodingByteLength);
                heapBreakdown.put(BREAKDOWN_BYTE_ARRAY_PREFIX + linkStrategy.asDocLink("graph encodings", "#glossary-graph-encodings"), graphEncodingByteLength);
                remainingBytes -= graphEncodingByteLength;
            }
            assert (remainingBytes >= 0L);
            heapBreakdown.put(BREAKDOWN_BYTE_ARRAY_PREFIX + linkStrategy.asDocLink("general heap data", "#glossary-general-heap-data"), remainingBytes);
        }
    }

    private void printBreakdowns() {
        if (!SubstrateOptions.BuildOutputBreakdowns.getValue().booleanValue()) {
            return;
        }
        this.l().printLineSeparator();
        Iterator packagesBySize = this.codeBreakdown.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).iterator();
        Iterator typesBySizeInHeap = this.heapBreakdown.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).iterator();
        TwoColumnPrinter p = new TwoColumnPrinter();
        ((TwoColumnPrinter)((TwoColumnPrinter)((TwoColumnPrinter)((TwoColumnPrinter)p.l()).yellowBold()).a(String.format("Top %d ", 10)).doclink("origins", "#glossary-code-area-origins")).a(" of code area:").jumpToMiddle().a(String.format("Top %d object types in image heap:", 10)).reset()).flushln();
        long printedCodeBytes = 0L;
        long printedHeapBytes = 0L;
        long printedCodeItems = 0L;
        long printedHeapItems = 0L;
        for (int i = 0; i < 10; ++i) {
            String codeSizePart = "";
            if (packagesBySize.hasNext()) {
                Map.Entry e = (Map.Entry)packagesBySize.next();
                String className = Utils.truncateClassOrPackageName((String)e.getKey());
                codeSizePart = String.format("%9s %s", ByteFormattingUtil.bytesToHuman((Long)e.getValue()), className);
                printedCodeBytes += ((Long)e.getValue()).longValue();
                ++printedCodeItems;
            }
            String heapSizePart = "";
            if (typesBySizeInHeap.hasNext()) {
                Map.Entry e = (Map.Entry)typesBySizeInHeap.next();
                String className = (String)e.getKey();
                if (!className.startsWith(BREAKDOWN_BYTE_ARRAY_PREFIX)) {
                    className = Utils.truncateClassOrPackageName(className);
                }
                heapSizePart = String.format("%9s %s", ByteFormattingUtil.bytesToHuman((Long)e.getValue()), className);
                printedHeapBytes += ((Long)e.getValue()).longValue();
                ++printedHeapItems;
            }
            if (codeSizePart.isEmpty() && heapSizePart.isEmpty()) break;
            ((TwoColumnPrinter)p.l()).a(codeSizePart).jumpToMiddle().a(heapSizePart).flushln();
        }
        int numCodeItems = this.codeBreakdown.size();
        int numHeapItems = this.heapBreakdown.size();
        long totalCodeBytes = this.codeBreakdown.values().stream().collect(Collectors.summingLong(Long::longValue));
        long totalHeapBytes = this.heapBreakdown.values().stream().collect(Collectors.summingLong(Long::longValue));
        ((TwoColumnPrinter)p.l()).a(String.format("%9s for %s more packages", ByteFormattingUtil.bytesToHuman(totalCodeBytes - printedCodeBytes), (long)numCodeItems - printedCodeItems)).jumpToMiddle().a(String.format("%9s for %s more object types", ByteFormattingUtil.bytesToHuman(totalHeapBytes - printedHeapBytes), (long)numHeapItems - printedHeapItems)).flushln();
    }

    private void printRecommendations() {
        if (!SubstrateOptions.BuildOutputRecommendations.getValue().booleanValue()) {
            return;
        }
        List<ProgressReporterFeature.UserRecommendation> recommendations = ((ProgressReporterFeature)ImageSingletons.lookup(ProgressReporterFeature.class)).getRecommendations();
        List<ProgressReporterFeature.UserRecommendation> topApplicableRecommendations = recommendations.stream().filter(r -> r.isApplicable().get()).limit(5L).toList();
        if (topApplicableRecommendations.isEmpty()) {
            return;
        }
        this.l().printLineSeparator();
        ((DirectPrinter)((DirectPrinter)this.l().yellowBold()).a("Recommendations:").reset()).println();
        for (ProgressReporterFeature.UserRecommendation r2 : topApplicableRecommendations) {
            String alignment = Utils.stringFilledWith(Math.max(1, 5 - r2.id().length()), " ");
            ((DirectPrinter)this.l().a(" ").doclink(r2.id(), "#recommendation-" + r2.id().toLowerCase())).a(":").a(alignment).a(r2.description()).println();
        }
    }

    public void printEpilog(Optional<String> optionalImageName, Optional<NativeImageGenerator> optionalGenerator, ImageClassLoader classLoader, Optional<Throwable> optionalError, OptionValues parsedHostedOptions) {
        this.executor.shutdown();
        if (optionalError.isPresent()) {
            Path errorReportPath = NativeImageOptions.getErrorFilePath(parsedHostedOptions);
            Optional featureHandler = optionalGenerator.isEmpty() ? Optional.empty() : Optional.ofNullable(optionalGenerator.get().featureHandler);
            ReportUtils.report((String)"GraalVM Native Image Error Report", (Path)errorReportPath, p -> VMErrorReporter.generateErrorReport(p, this.buildOutputLog, classLoader, featureHandler, (Throwable)optionalError.get()), (boolean)false);
            if (ImageSingletonsSupport.isInstalled()) {
                BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, errorReportPath);
            }
        }
        if (optionalImageName.isEmpty() || optionalGenerator.isEmpty()) {
            this.printErrorMessage(optionalError, parsedHostedOptions);
            return;
        }
        String imageName = optionalImageName.get();
        NativeImageGenerator generator = optionalGenerator.get();
        this.l().printLineSeparator();
        this.printResourceStatistics();
        double totalSeconds = Utils.millisToSeconds(ProgressReporter.getTimer(TimerCollection.Registry.TOTAL).getTotalTime());
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.TOTAL_SECS, totalSeconds);
        this.createAdditionalArtifacts(imageName, generator, optionalError, parsedHostedOptions);
        this.printArtifacts(generator.getBuildArtifacts());
        this.l().printHeadlineSeparator();
        String timeStats = totalSeconds < 60.0 ? String.format("%.1fs", totalSeconds) : String.format("%dm %ds", (int)totalSeconds / 60, (int)totalSeconds % 60);
        ((DirectPrinter)((DirectPrinter)this.l().a(optionalError.isEmpty() ? "Finished" : "Failed").a(" generating '").bold()).a(imageName).reset()).a("' ").a(optionalError.isEmpty() ? "in" : "after").a(" ").a(timeStats).a(".").println();
        this.printErrorMessage(optionalError, parsedHostedOptions);
    }

    private void printErrorMessage(Optional<Throwable> optionalError, OptionValues parsedHostedOptions) {
        if (optionalError.isEmpty()) {
            return;
        }
        Throwable error = optionalError.get();
        this.l().println();
        ((DirectPrinter)((DirectPrinter)this.l().redBold()).a("The build process encountered an unexpected error:").reset()).println();
        if (((Boolean)NativeImageOptions.ReportExceptionStackTraces.getValue(parsedHostedOptions)).booleanValue()) {
            ((DirectPrinter)this.l().dim()).println();
            error.printStackTrace(this.builderIO.getOut());
            ((DirectPrinter)this.l().reset()).println();
        } else {
            this.l().println();
            ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().dim()).a("> %s", error)).reset()).println();
            this.l().println();
            this.l().a("Please inspect the generated error report at:").println();
            ((DirectPrinter)this.l().link(NativeImageOptions.getErrorFilePath(parsedHostedOptions))).println();
            this.l().println();
            this.l().a("If you are unable to resolve this problem, please file an issue with the error report at:").println();
            String supportUrl = VM.getSupportUrl();
            ((DirectPrinter)this.l().link(supportUrl, supportUrl)).println();
        }
    }

    private void createAdditionalArtifacts(String imageName, NativeImageGenerator generator, Optional<Throwable> error, OptionValues parsedHostedOptions) {
        BuildArtifacts artifacts = BuildArtifacts.singleton();
        Optional buildOutputJSONFile = ((LocatableMultiOptionValue.Paths)SubstrateOptions.BuildOutputJSONFile.getValue(parsedHostedOptions)).lastValue();
        if (error.isEmpty() && buildOutputJSONFile.isPresent()) {
            artifacts.add(BuildArtifacts.ArtifactType.BUILD_INFO, this.reportBuildOutput((Path)buildOutputJSONFile.get()));
        }
        if (generator.getBigbang() != null && ((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(parsedHostedOptions)).booleanValue()) {
            artifacts.add(BuildArtifacts.ArtifactType.BUILD_INFO, ProgressReporter.reportImageBuildStatistics());
        }
        ((ProgressReporterFeature)ImageSingletons.lookup(ProgressReporterFeature.class)).createAdditionalArtifacts(artifacts);
        BuildArtifactsExporter.run(imageName, artifacts, generator.getBuildArtifacts());
    }

    private void printArtifacts(Map<BuildArtifacts.ArtifactType, List<Path>> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        this.l().printLineSeparator();
        ((DirectPrinter)((DirectPrinter)this.l().yellowBold()).a("Produced artifacts:").reset()).println();
        TreeMap<Path, List> pathToTypes = new TreeMap<Path, List>();
        artifacts.forEach((artifactType, paths) -> {
            for (Path path : paths) {
                pathToTypes.computeIfAbsent(path, p -> new ArrayList()).add(artifactType.name().toLowerCase());
            }
        });
        pathToTypes.forEach((path, typeNames) -> ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(" ").link((Path)path)).dim()).a(" (").a(String.join((CharSequence)", ", typeNames)).a(")").reset()).println());
    }

    private Path reportBuildOutput(Path jsonOutputFile) {
        String description = "image statistics in json";
        return ReportUtils.report((String)description, (Path)jsonOutputFile.toAbsolutePath(), out -> {
            try {
                this.jsonHelper.print(new JsonWriter((Writer)out));
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Failed to create " + jsonOutputFile, e);
            }
        }, (boolean)false);
    }

    private static Path reportImageBuildStatistics() {
        Consumer statsReporter = ((ImageBuildStatistics)ImageSingletons.lookup(ImageBuildStatistics.class)).getReporter();
        Path reportsPath = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton()).resolve("reports");
        return ReportUtils.report((String)"image build statistics", (Path)reportsPath.resolve("image_build_statistics.json"), (Consumer)statsReporter, (boolean)false);
    }

    private void printResourceStatistics() {
        double totalProcessTimeSeconds = Utils.millisToSeconds(System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime());
        GCStats gcStats = GCStats.getCurrent();
        double gcSeconds = Utils.millisToSeconds(gcStats.totalTimeMillis);
        CenteredTextPrinter p = new CenteredTextPrinter();
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.GC_COUNT, gcStats.totalCount);
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.GC_SECS, gcSeconds);
        ((CenteredTextPrinter)p.a("%.1fs (%.1f%% of total time) in %d ", gcSeconds, gcSeconds / totalProcessTimeSeconds * 100.0, gcStats.totalCount)).doclink("GCs", "#glossary-garbage-collections");
        long peakRSS = ProgressReporterCHelper.getPeakRSS();
        if (peakRSS >= 0L) {
            ((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)p.a(" | ")).doclink("Peak RSS", "#glossary-peak-rss")).a(": ")).a("%.2fGB", ByteFormattingUtil.bytesToGiB(peakRSS));
        }
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.PEAK_RSS, peakRSS >= 0L ? peakRSS : -1L);
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        long processCPUTime = ((com.sun.management.OperatingSystemMXBean)osMXBean).getProcessCpuTime();
        double cpuLoad = -1.0;
        if (processCPUTime > 0L) {
            cpuLoad = Utils.nanosToSeconds(processCPUTime) / totalProcessTimeSeconds;
            ((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)p.a(" | ")).doclink("CPU load", "#glossary-cpu-load")).a(": ")).a("%.2f", cpuLoad);
        }
        this.recordJsonMetric(ProgressReporterJsonHelper.ResourceUsageKey.CPU_LOAD, cpuLoad);
        p.flushln();
    }

    private void checkForExcessiveGarbageCollection() {
        long current = System.currentTimeMillis();
        long timeDeltaMillis = current - this.lastGCCheckTimeMillis;
        this.lastGCCheckTimeMillis = current;
        GCStats currentGCStats = GCStats.getCurrent();
        long gcTimeDeltaMillis = currentGCStats.totalTimeMillis - this.lastGCStats.totalTimeMillis;
        double ratio = (double)gcTimeDeltaMillis / (double)timeDeltaMillis;
        if ((double)gcTimeDeltaMillis > 15000.0 && ratio > 0.5) {
            ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().redBold()).a("GC warning").reset()).a(": %.1fs spent in %d GCs during the last stage, taking up %.2f%% of the time.", Utils.millisToSeconds(gcTimeDeltaMillis), currentGCStats.totalCount - this.lastGCStats.totalCount, ratio * 100.0)).println();
            ((DirectPrinter)this.l().a("            Please ensure more than %.2fGB of memory is available for Native Image", ByteFormattingUtil.bytesToGiB(ProgressReporterCHelper.getPeakRSS()))).println();
            this.l().a("            to reduce GC overhead and improve image build time.").println();
        }
        this.lastGCStats = currentGCStats;
    }

    public void recordJsonMetric(ProgressReporterJsonHelper.JsonMetric metric, Object value) {
        if (this.jsonHelper != null) {
            metric.record(this.jsonHelper, value);
        }
    }

    private static Timer getTimer(TimerCollection.Registry type) {
        return TimerCollection.singleton().get(type);
    }

    private void print(char text) {
        this.builderIO.getOut().print(text);
        this.buildOutputLog.append(text);
    }

    private void print(String text) {
        this.builderIO.getOut().print(text);
        this.buildOutputLog.append(text);
    }

    private void println() {
        this.builderIO.getOut().println();
        this.buildOutputLog.append(System.lineSeparator());
    }

    private DirectPrinter l() {
        return this.linePrinter.a(this.outputPrefix);
    }

    public void reportStageProgress() {
        this.stagePrinter.reportProgress();
    }

    public void beforeNextStdioWrite() {
        this.stagePrinter.beforeNextStdioWrite();
    }

    public final class DirectPrinter
    extends AbstractPrinter<DirectPrinter> {
        @Override
        DirectPrinter getThis() {
            return this;
        }

        @Override
        public DirectPrinter a(String text) {
            ProgressReporter.this.print(text);
            return this;
        }

        void println() {
            ProgressReporter.this.println();
        }

        void printHeadlineSeparator() {
            ((DirectPrinter)((DirectPrinter)this.dim()).a(HEADLINE_SEPARATOR).reset()).println();
        }

        void printLineSeparator() {
            ((DirectPrinter)((DirectPrinter)this.dim()).a(LINE_SEPARATOR).reset()).println();
        }
    }

    private static class GCStats {
        private final long totalCount;
        private final long totalTimeMillis;

        private static GCStats getCurrent() {
            long totalCount = 0L;
            long totalTime = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                long collectionTime;
                long collectionCount = bean.getCollectionCount();
                if (collectionCount > 0L) {
                    totalCount += collectionCount;
                }
                if ((collectionTime = bean.getCollectionTime()) <= 0L) continue;
                totalTime += collectionTime;
            }
            return new GCStats(totalCount, totalTime);
        }

        GCStats(long totalCount, long totalTime) {
            this.totalCount = totalCount;
            this.totalTimeMillis = totalTime;
        }
    }

    final class ColorfulStrategy
    implements ColorStrategy {
        ColorfulStrategy() {
        }

        @Override
        public void bold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1m");
        }

        @Override
        public void blue(AbstractPrinter<?> printer) {
            printer.a("\u001b[0;34m");
        }

        @Override
        public void blueBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;34m");
        }

        @Override
        public void magentaBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;35m");
        }

        @Override
        public void redBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;31m");
        }

        @Override
        public void yellowBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;33m");
        }

        @Override
        public void dim(AbstractPrinter<?> printer) {
            printer.a("\u001b[2m");
        }

        @Override
        public void reset(AbstractPrinter<?> printer) {
            printer.a("\u001b[0m");
        }

        @Override
        public void reset() {
            ProgressReporter.this.print("\u001b[0m");
        }
    }

    final class ColorlessStrategy
    implements ColorStrategy {
        ColorlessStrategy() {
        }
    }

    private static interface ColorStrategy {
        default public void bold(AbstractPrinter<?> printer) {
        }

        default public void blue(AbstractPrinter<?> printer) {
        }

        default public void blueBold(AbstractPrinter<?> printer) {
        }

        default public void magentaBold(AbstractPrinter<?> printer) {
        }

        default public void redBold(AbstractPrinter<?> printer) {
        }

        default public void yellowBold(AbstractPrinter<?> printer) {
        }

        default public void dim(AbstractPrinter<?> printer) {
        }

        default public void reset(AbstractPrinter<?> printer) {
        }

        default public void reset() {
        }
    }

    final class CharacterwiseStagePrinter
    extends StagePrinter<CharacterwiseStagePrinter> {
        CharacterwiseStagePrinter() {
        }

        @Override
        CharacterwiseStagePrinter getThis() {
            return this;
        }

        @Override
        public CharacterwiseStagePrinter a(String value) {
            ProgressReporter.this.print(value);
            return (CharacterwiseStagePrinter)super.a(value);
        }

        @Override
        CharacterwiseStagePrinter start(BuildStage stage) {
            super.start(stage);
            ProgressReporter.this.builderIO.progressReporter = ProgressReporter.this;
            return this.getThis();
        }

        @Override
        void reportProgress() {
            this.reprintLineIfNecessary();
            ProgressReporter.this.builderIO.progressReporter = null;
            super.reportProgress();
            ProgressReporter.this.builderIO.progressReporter = ProgressReporter.this;
        }

        @Override
        void end(double totalTime) {
            this.reprintLineIfNecessary();
            ProgressReporter.this.builderIO.progressReporter = null;
            super.end(totalTime);
        }

        void reprintLineIfNecessary() {
            if (ProgressReporter.this.builderIO.progressReporter == null) {
                this.printLineParts();
            }
        }

        @Override
        void flushln() {
            this.lineParts.clear();
            ProgressReporter.this.println();
        }

        @Override
        void beforeNextStdioWrite() {
            ProgressReporter.this.colorStrategy.reset();
            ProgressReporter.this.print('\r');
            int textLength = this.getCurrentTextLength();
            assert (textLength > 0) : "linePrinter expected to hold current line content";
            for (int i = 0; i <= textLength; ++i) {
                ProgressReporter.this.print(' ');
            }
            ProgressReporter.this.print('\r');
        }
    }

    final class LinewiseStagePrinter
    extends StagePrinter<LinewiseStagePrinter> {
        LinewiseStagePrinter() {
        }

        @Override
        LinewiseStagePrinter getThis() {
            return this;
        }

        @Override
        void beforeNextStdioWrite() {
            throw VMError.shouldNotReachHere("LinewiseStagePrinter not allowed to set builderIO.listenForNextStdioWrite");
        }
    }

    abstract class StagePrinter<T extends StagePrinter<T>>
    extends LinePrinter<T> {
        private int progressBarStart;
        private BuildStage activeBuildStage;
        private ScheduledFuture<?> periodicPrintingTask;
        private AtomicBoolean isCancelled;

        StagePrinter() {
            this.progressBarStart = 30;
            this.activeBuildStage = null;
            this.isCancelled = new AtomicBoolean();
        }

        T start(BuildStage stage) {
            assert (this.activeBuildStage == null);
            this.activeBuildStage = stage;
            this.appendStageStart();
            if (this.activeBuildStage.hasProgressBar) {
                ((StagePrinter)((StagePrinter)this.a(this.progressBarStartPadding())).dim()).a("[");
            }
            if (this.activeBuildStage.hasPeriodicProgress) {
                this.startPeriodicProgress();
            }
            return (T)((StagePrinter)this.getThis());
        }

        private void startPeriodicProgress() {
            this.isCancelled.set(false);
            this.periodicPrintingTask = ProgressReporter.this.executor.scheduleAtFixedRate(new Runnable(){
                int countdown;
                int numPrints;

                @Override
                public void run() {
                    if (StagePrinter.this.isCancelled.get()) {
                        return;
                    }
                    if (--this.countdown < 0) {
                        StagePrinter.this.reportProgress();
                        this.countdown = ++this.numPrints > 2 ? this.numPrints * 2 : this.numPrints;
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }

        private void appendStageStart() {
            ((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)this.a(ProgressReporter.this.outputPrefix)).blue()).a(String.format("[%s/%s] ", 1 + this.activeBuildStage.ordinal(), BuildStage.NUM_STAGES))).reset()).blueBold()).doclink(this.activeBuildStage.message, "#stage-" + this.activeBuildStage.name().toLowerCase())).a("...")).reset();
        }

        final String progressBarStartPadding() {
            return Utils.stringFilledWith(this.progressBarStart - this.getCurrentTextLength(), " ");
        }

        void reportProgress() {
            this.a("*");
        }

        final void end(Timer timer) {
            this.end(timer.getTotalTime());
        }

        void end(double totalTime) {
            boolean optionsAvailable;
            if (this.activeBuildStage.hasPeriodicProgress) {
                this.isCancelled.set(true);
                this.periodicPrintingTask.cancel(false);
            }
            if (this.activeBuildStage.hasProgressBar) {
                ((StagePrinter)this.a("]")).reset();
            }
            String suffix = String.format("(%.1fs @ %.2fGB)", Utils.millisToSeconds(totalTime), Utils.getUsedMemory());
            int textLength = this.getCurrentTextLength();
            String padding = Utils.stringFilledWith(Math.max(0, CHARACTERS_PER_LINE - textLength - suffix.length()), " ");
            ((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)this.a(padding)).dim()).a(suffix)).reset()).flushln();
            this.activeBuildStage = null;
            boolean bl = optionsAvailable = ImageSingletonsSupport.isInstalled() && ImageSingletons.contains(HostedOptionValues.class);
            if (optionsAvailable && SubstrateOptions.BuildOutputGCWarnings.getValue().booleanValue()) {
                ProgressReporter.this.checkForExcessiveGarbageCollection();
            }
        }

        abstract void beforeNextStdioWrite();
    }

    static final class LinkyStrategy
    implements LinkStrategy {
        LinkyStrategy() {
        }

        @Override
        public void link(AbstractPrinter<?> printer, String text, String url) {
            ((AbstractPrinter)((AbstractPrinter)((AbstractPrinter)printer.a("\u001b]8;;" + url)).a("\u001b\\")).a(text)).a("\u001b]8;;\u001b\\");
        }

        @Override
        public String asDocLink(String text, String htmlAnchor) {
            return String.format("\u001b]8;;%s\u001b\\%s\u001b]8;;\u001b\\", ProgressReporter.STAGE_DOCS_URL + htmlAnchor, text);
        }
    }

    static final class LinklessStrategy
    implements LinkStrategy {
        LinklessStrategy() {
        }

        @Override
        public void link(AbstractPrinter<?> printer, String text, String url) {
            printer.a(text);
        }

        @Override
        public String asDocLink(String text, String htmlAnchor) {
            return text;
        }
    }

    public static interface LinkStrategy {
        public void link(AbstractPrinter<?> var1, String var2, String var3);

        public String asDocLink(String var1, String var2);

        default public void link(AbstractPrinter<?> printer, Path path) {
            Path normalized = path.normalize();
            this.link(printer, normalized.toString(), normalized.toUri().toString());
        }

        default public void doclink(AbstractPrinter<?> printer, String text, String htmlAnchor) {
            this.link(printer, text, ProgressReporter.STAGE_DOCS_URL + htmlAnchor);
        }
    }

    public abstract class AbstractPrinter<T extends AbstractPrinter<T>> {
        abstract T getThis();

        public abstract T a(String var1);

        final T a(String text, Object ... args) {
            return this.a(String.format(text, args));
        }

        final T a(int i) {
            return this.a(String.valueOf(i));
        }

        final T a(long i) {
            return this.a(String.valueOf(i));
        }

        final T bold() {
            ProgressReporter.this.colorStrategy.bold(this);
            return this.getThis();
        }

        final T blue() {
            ProgressReporter.this.colorStrategy.blue(this);
            return this.getThis();
        }

        final T blueBold() {
            ProgressReporter.this.colorStrategy.blueBold(this);
            return this.getThis();
        }

        final T magentaBold() {
            ProgressReporter.this.colorStrategy.magentaBold(this);
            return this.getThis();
        }

        final T redBold() {
            ProgressReporter.this.colorStrategy.redBold(this);
            return this.getThis();
        }

        final T yellowBold() {
            ProgressReporter.this.colorStrategy.yellowBold(this);
            return this.getThis();
        }

        final T dim() {
            ProgressReporter.this.colorStrategy.dim(this);
            return this.getThis();
        }

        final T reset() {
            ProgressReporter.this.colorStrategy.reset(this);
            return this.getThis();
        }

        final T link(String text, String url) {
            ProgressReporter.this.linkStrategy.link(this, text, url);
            return this.getThis();
        }

        final T link(Path path) {
            ProgressReporter.this.linkStrategy.link(this, path);
            return this.getThis();
        }

        public final T doclink(String text, String htmlAnchor) {
            ProgressReporter.this.linkStrategy.doclink(this, text, htmlAnchor);
            return this.getThis();
        }
    }

    private static enum BuildStage {
        INITIALIZING("Initializing"),
        ANALYSIS("Performing analysis", true, false),
        UNIVERSE("Building universe"),
        PARSING("Parsing methods", true, true),
        INLINING("Inlining methods", true, false),
        COMPILING("Compiling methods", true, true),
        LAYOUTING("Layouting methods", true, true),
        CREATING("Creating image", true, true);

        private static final int NUM_STAGES;
        private final String message;
        private final boolean hasProgressBar;
        private final boolean hasPeriodicProgress;

        private BuildStage(String message) {
            this(message, false, false);
        }

        private BuildStage(String message, boolean hasProgressBar, boolean hasPeriodicProgress) {
            this.message = message;
            this.hasProgressBar = hasProgressBar;
            this.hasPeriodicProgress = hasPeriodicProgress;
        }

        static {
            NUM_STAGES = BuildStage.values().length;
        }
    }

    public static abstract class ReporterClosable
    implements AutoCloseable {
        @Override
        public void close() {
            this.closeAction();
        }

        abstract void closeAction();
    }

    private static class Utils {
        private static final double MILLIS_TO_SECONDS = 1000.0;
        private static final double NANOS_TO_SECONDS = 1.0E9;
        private static final Field STRING_VALUE = ReflectionUtil.lookupField(String.class, (String)"value");

        private Utils() {
        }

        private static double millisToSeconds(double millis) {
            return millis / 1000.0;
        }

        private static double nanosToSeconds(double nanos) {
            return nanos / 1.0E9;
        }

        private static int getInternalByteArrayLength(String string) {
            try {
                return ((byte[])STRING_VALUE.get(string)).length;
            }
            catch (ReflectiveOperationException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }

        private static double getUsedMemory() {
            return ByteFormattingUtil.bytesToGiB(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        }

        private static String stringFilledWith(int size, String fill) {
            return new String(new char[size]).replace("\u0000", fill);
        }

        private static String truncateClassOrPackageName(String classOrPackageName) {
            int maxLength;
            int classNameLength = classOrPackageName.length();
            if (classNameLength <= (maxLength = CHARACTERS_PER_LINE / 2 - 10)) {
                return classOrPackageName;
            }
            StringBuilder sb = new StringBuilder();
            int currentDot = -1;
            while (true) {
                int nextDot;
                if ((nextDot = classOrPackageName.indexOf(46, currentDot + 1)) < 0) {
                    int restLength;
                    String rest = classOrPackageName.substring(currentDot + 1);
                    int sbLength = sb.length();
                    if (sbLength + (restLength = rest.length()) <= maxLength) {
                        sb.append(rest);
                        break;
                    }
                    int remainingSpaceDivBy2 = (maxLength - sbLength) / 2;
                    sb.append(rest.substring(0, remainingSpaceDivBy2 - 1) + "~" + rest.substring(restLength - remainingSpaceDivBy2, restLength));
                    break;
                }
                sb.append(classOrPackageName.charAt(currentDot + 1)).append('.');
                if (sb.length() + (classNameLength - nextDot) <= maxLength) {
                    sb.append(classOrPackageName.substring(nextDot + 1));
                    break;
                }
                currentDot = nextDot;
            }
            return sb.toString();
        }
    }

    final class TwoColumnPrinter
    extends LinePrinter<TwoColumnPrinter> {
        TwoColumnPrinter() {
        }

        @Override
        TwoColumnPrinter getThis() {
            return this;
        }

        @Override
        public TwoColumnPrinter a(String value) {
            super.a(value);
            return this;
        }

        TwoColumnPrinter jumpToMiddle() {
            int remaining = CHARACTERS_PER_LINE / 2 - this.getCurrentTextLength();
            assert (remaining >= 0) : "Column text too wide";
            this.a(Utils.stringFilledWith(remaining, " "));
            assert (this.getCurrentTextLength() == CHARACTERS_PER_LINE / 2);
            return this;
        }

        @Override
        void flushln() {
            ProgressReporter.this.print(ProgressReporter.this.outputPrefix);
            super.flushln();
        }
    }

    abstract class LinePrinter<T extends LinePrinter<T>>
    extends AbstractPrinter<T> {
        protected final List<String> lineParts = new ArrayList<String>();

        LinePrinter() {
        }

        @Override
        public T a(String value) {
            this.lineParts.add(value);
            return (T)((LinePrinter)this.getThis());
        }

        T l() {
            assert (this.lineParts.isEmpty());
            return (T)((LinePrinter)this.getThis());
        }

        final int getCurrentTextLength() {
            int textLength = 0;
            for (String text : this.lineParts) {
                if (text.startsWith("\u001b")) continue;
                textLength += text.length();
            }
            return textLength;
        }

        final void printLineParts() {
            this.lineParts.forEach(ProgressReporter.this::print);
        }

        void flushln() {
            this.printLineParts();
            this.lineParts.clear();
            ProgressReporter.this.println();
        }
    }

    final class CenteredTextPrinter
    extends LinePrinter<CenteredTextPrinter> {
        CenteredTextPrinter() {
        }

        @Override
        CenteredTextPrinter getThis() {
            return this;
        }

        @Override
        void flushln() {
            ProgressReporter.this.print(ProgressReporter.this.outputPrefix);
            String padding = Utils.stringFilledWith(Math.max(0, CHARACTERS_PER_LINE - this.getCurrentTextLength()) / 2, " ");
            ProgressReporter.this.print(padding);
            super.flushln();
        }
    }

    public static class ANSI {
        static final String ESCAPE = "\u001b";
        static final String RESET = "\u001b[0m";
        static final String BOLD = "\u001b[1m";
        static final String DIM = "\u001b[2m";
        static final String STRIP_COLORS = "\u001b\\[[;\\d]*m";
        static final String LINK_START = "\u001b]8;;";
        static final String LINK_TEXT = "\u001b\\";
        static final String LINK_END = "\u001b]8;;\u001b\\";
        static final String LINK_FORMAT = "\u001b]8;;%s\u001b\\%s\u001b]8;;\u001b\\";
        static final String STRIP_LINKS = "\u001b]8;;https://\\S+\u001b\\\\([^\u001b]*)\u001b]8;;\u001b\\\\";
        static final String BLUE = "\u001b[0;34m";
        static final String RED_BOLD = "\u001b[1;31m";
        static final String YELLOW_BOLD = "\u001b[1;33m";
        static final String BLUE_BOLD = "\u001b[1;34m";
        static final String MAGENTA_BOLD = "\u001b[1;35m";

        public static String strip(String string) {
            return string.replaceAll(STRIP_COLORS, "").replaceAll(STRIP_LINKS, "$1");
        }
    }
}

