/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.SubstrateVirtualThread;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.word.Pointer;

public final class SubstrateVirtualThreads
implements VirtualThreads {
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> {
        if (SubstrateVirtualThreads.haveAssertions()) {
            throw VMError.shouldNotReachHere("Exception in continuation or virtual thread code", e);
        }
    };
    final ForkJoinPool scheduler = new ForkJoinPool(Options.SubstrateVirtualThreadsParallelism.getValue(), CarrierThread::new, UNCAUGHT_EXCEPTION_HANDLER, true);

    @Fold
    static boolean haveAssertions() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(SubstrateVirtualThreads.class);
    }

    private static SubstrateVirtualThread cast(Thread thread) {
        return (SubstrateVirtualThread)thread;
    }

    private static SubstrateVirtualThread current() {
        return (SubstrateVirtualThread)Thread.currentThread();
    }

    @Override
    public ThreadFactory createFactory() {
        return task -> new SubstrateVirtualThread(null, task);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isVirtual(Thread thread) {
        return thread instanceof SubstrateVirtualThread;
    }

    @Override
    public boolean getAndClearInterrupt(Thread thread) {
        return SubstrateVirtualThreads.cast(thread).getAndClearInterrupted();
    }

    @Override
    public void join(Thread thread, long millis) throws InterruptedException {
        if (thread.isAlive()) {
            long nanos = TimeUnit.MILLISECONDS.toNanos(millis);
            ((SubstrateVirtualThread)thread).joinNanos(nanos);
        }
    }

    @Override
    public void yield() {
        SubstrateVirtualThreads.current().tryYield();
    }

    @Override
    public void sleepMillis(long millis) throws InterruptedException {
        long nanos = TimeUnit.NANOSECONDS.convert(millis, TimeUnit.MILLISECONDS);
        SubstrateVirtualThreads.current().sleepNanos(nanos);
    }

    @Override
    public boolean isAlive(Thread thread) {
        Thread.State state = thread.getState();
        return state != Thread.State.NEW && state != Thread.State.TERMINATED;
    }

    @Override
    public void unpark(Thread thread) {
        SubstrateVirtualThreads.cast(thread).unpark();
    }

    @Override
    public void park() {
        SubstrateVirtualThreads.current().park();
    }

    @Override
    public void parkNanos(long nanos) {
        SubstrateVirtualThreads.current().parkNanos(nanos);
    }

    @Override
    public void parkUntil(long deadline) {
        SubstrateVirtualThreads.current().parkUntil(deadline);
    }

    @Override
    public void pinCurrent() {
        SubstrateVirtualThreads.current().pin();
    }

    @Override
    public void unpinCurrent() {
        SubstrateVirtualThreads.current().unpin();
    }

    @Override
    public boolean isCurrentPinned() {
        return SubstrateVirtualThreads.current().isPinned();
    }

    @Override
    public Executor getScheduler(Thread thread) {
        return SubstrateVirtualThreads.cast(thread).getScheduler();
    }

    @Override
    public void blockedOn(Target_sun_nio_ch_Interruptible b) {
        SubstrateVirtualThreads.current().blockedOn(b);
    }

    @Override
    public StackTraceElement[] getVirtualOrPlatformThreadStackTrace(boolean filterExceptions, Thread thread, Pointer callerSP) {
        if (!this.isVirtual(thread)) {
            return PlatformThreads.getStackTrace(filterExceptions, thread, callerSP);
        }
        if (thread != Thread.currentThread()) {
            return Target_java_lang_Thread.EMPTY_STACK_TRACE;
        }
        Pointer endSP = SubstrateVirtualThreads.current().getBaseSP();
        if (endSP.isNull()) {
            return null;
        }
        return StackTraceUtils.getStackTrace(false, callerSP, endSP);
    }

    @Override
    public StackTraceElement[] getVirtualOrPlatformThreadStackTraceAtSafepoint(Thread thread, Pointer callerSP) {
        return PlatformThreads.getStackTraceAtSafepoint(thread, callerSP);
    }

    public static final class Options {
        static final int MAX_PARALLELISM = Short.MAX_VALUE;
        static final int DEFAULT_PARALLELISM = Short.MAX_VALUE;
        public static final HostedOptionKey<Integer> SubstrateVirtualThreadsParallelism = new HostedOptionKey<Integer>(null){

            public Integer getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                Integer value = (Integer)values.get((Object)this);
                if (value != null) {
                    UserError.guarantee(value >= 1 && value <= Short.MAX_VALUE, "%s value must be between 1 and %d.", this.getName(), Short.MAX_VALUE);
                    return value;
                }
                String propertyKey = "jdk.virtualThreadScheduler.parallelism";
                String propertyValue = System.getProperty(propertyKey, String.valueOf(Short.MAX_VALUE));
                try {
                    value = Integer.valueOf(propertyValue);
                }
                catch (NumberFormatException e) {
                    throw UserError.abort("%s is not a permitted value for %s: must be an integer between 1 and %d.", propertyValue, propertyKey, this.getName(), Short.MAX_VALUE);
                }
                return value;
            }

            public Integer getValue(OptionValues values) {
                assert (this.checkDescriptorExists());
                return this.getValueOrDefault(values.getMap());
            }
        };
    }

    private static final class CarrierThread
    extends ForkJoinWorkerThread {
        CarrierThread(ForkJoinPool pool) {
            super(pool);
        }

        @Override
        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        }

        @Override
        protected void onTermination(Throwable exception) {
            if (exception != null) {
                throw VMError.shouldNotReachHere("Carrier thread must not terminate abnormally because it cancels pending tasks which can result in virtual threads never being scheduled again.", exception);
            }
        }
    }
}

