/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

@CContext(value=PosixDirectives.class)
@CLibrary(value="pthread")
public class Pthread {
    @CConstant
    public static native int PTHREAD_KEYS_MAX();

    @CConstant
    public static native int PTHREAD_CREATE_JOINABLE();

    @CConstant
    public static native UnsignedWord PTHREAD_STACK_MIN();

    @CFunction
    public static native int pthread_create(pthread_tPointer var0, pthread_attr_t var1, WordBase var2, WordBase var3);

    @CFunction(value="pthread_create", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_create_no_transition(pthread_tPointer var0, pthread_attr_t var1, WordBase var2, WordBase var3);

    @CFunction
    public static native int pthread_join(pthread_t var0, WordPointer var1);

    @CFunction(value="pthread_join", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_join_no_transition(pthread_t var0, WordPointer var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native pthread_t pthread_self();

    @CFunction
    public static native int pthread_attr_init(pthread_attr_t var0);

    @CFunction(value="pthread_attr_init", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_init_no_transition(pthread_attr_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_destroy(pthread_attr_t var0);

    @CFunction(value="pthread_attr_destroy", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_destroy_no_transition(pthread_attr_t var0);

    @CFunction
    public static native int pthread_attr_setdetachstate(pthread_attr_t var0, int var1);

    @CFunction(value="pthread_attr_setdetachstate", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_setdetachstate_no_transition(pthread_attr_t var0, int var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_getguardsize(pthread_attr_t var0, WordPointer var1);

    @CFunction
    public static native int pthread_attr_setstacksize(pthread_attr_t var0, UnsignedWord var1);

    @CFunction(value="pthread_attr_setstacksize", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_setstacksize_no_transition(pthread_attr_t var0, UnsignedWord var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_getstack(pthread_attr_t var0, WordPointer var1, WordPointer var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_getattr_np(pthread_t var0, pthread_attr_t var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_init(pthread_mutex_t var0, pthread_mutexattr_t var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_destroy(pthread_mutex_t var0);

    @CFunction(value="pthread_mutex_trylock", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_trylock_no_transition(pthread_mutex_t var0);

    @CFunction(transition=CFunction.Transition.TO_NATIVE)
    public static native int pthread_mutex_lock(pthread_mutex_t var0);

    @CFunction(value="pthread_mutex_lock", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_lock_no_transition(pthread_mutex_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_unlock(pthread_mutex_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_init(pthread_cond_t var0, pthread_condattr_t var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_destroy(pthread_cond_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_signal(pthread_cond_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_broadcast(pthread_cond_t var0);

    @CFunction
    public static native int pthread_cond_wait(pthread_cond_t var0, pthread_mutex_t var1);

    @CFunction(value="pthread_cond_wait", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_wait_no_transition(pthread_cond_t var0, pthread_mutex_t var1);

    @CFunction
    public static native int pthread_cond_timedwait(pthread_cond_t var0, pthread_mutex_t var1, Time.timespec var2);

    @CFunction(value="pthread_cond_timedwait", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_timedwait_no_transition(pthread_cond_t var0, pthread_mutex_t var1, Time.timespec var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_condattr_init(pthread_condattr_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_condattr_destroy(pthread_condattr_t var0);

    @CFunction
    public static native int pthread_kill(pthread_t var0, Signal.SignalEnum var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_key_create(pthread_key_tPointer var0, PointerBase var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_key_delete(pthread_key_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_setspecific(pthread_key_t var0, VoidPointer var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native VoidPointer pthread_getspecific(pthread_key_t var0);

    @CPointerTo(nameOfCType="size_t")
    public static interface pthread_key_tPointer
    extends PointerBase {
        public pthread_key_t read();
    }

    public static interface pthread_key_t
    extends UnsignedWord {
    }

    @CStruct
    public static interface pthread_condattr_t
    extends PointerBase {
    }

    @CStruct
    public static interface pthread_cond_t
    extends PointerBase {
    }

    public static interface pthread_mutexattr_t
    extends PointerBase {
    }

    @CStruct
    public static interface pthread_mutex_t
    extends PointerBase {
    }

    @CStruct
    public static interface pthread_attr_t
    extends PointerBase {
    }

    @CPointerTo(nameOfCType="pthread_t")
    public static interface pthread_tPointer
    extends PointerBase {
        public pthread_t read();
    }

    public static interface pthread_t
    extends VMThreads.OSThreadHandle,
    VMThreads.OSThreadId {
    }
}

