/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jni.access.JNIAccessibleClass;
import com.oracle.svm.core.jni.access.JNIAccessibleMember;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JNIAccessibleField
extends JNIAccessibleMember {
    private static final UnsignedWord ID_STATIC_FLAG = WordFactory.unsigned((long)-1L).unsignedShiftRight(1).add(1);
    private static final UnsignedWord ID_OBJECT_FLAG = ID_STATIC_FLAG.unsignedShiftRight(1);
    private static final UnsignedWord ID_OFFSET_MASK = ID_OBJECT_FLAG.subtract(1);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final UnsignedWord flags;
    private UnsignedWord id = (UnsignedWord)WordFactory.zero();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static WordBase getOffsetFromId(JNIFieldId id) {
        UnsignedWord result = ((UnsignedWord)id).and(ID_OFFSET_MASK);
        assert (result.notEqual(0));
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JNIAccessibleField(JNIAccessibleClass declaringClass, JavaKind kind, int modifiers) {
        super(declaringClass);
        UnsignedWord bits;
        UnsignedWord unsignedWord = bits = Modifier.isStatic(modifiers) ? ID_STATIC_FLAG : (UnsignedWord)WordFactory.zero();
        if (kind.isObject()) {
            bits = bits.or(ID_OBJECT_FLAG);
        }
        this.flags = bits;
    }

    public JNIFieldId getId() {
        return (JNIFieldId)this.id;
    }

    public boolean isStatic() {
        assert (!this.id.equal(0));
        return this.id.and(ID_STATIC_FLAG).notEqual(0);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void finishBeforeCompilation(int offset, EconomicSet<Class<?>> hidingSubclasses) {
        assert (this.id.equal(0));
        assert (ID_OFFSET_MASK.and(offset).equal(offset)) : "Offset is too large to be encoded in the JNIAccessibleField ID";
        this.id = this.flags.or(offset);
        this.setHidingSubclasses(hidingSubclasses);
    }
}

