/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jni.JNIJavaVMList;
import com.oracle.svm.core.jni.functions.JNIFunctionTables;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.sampler.ProfilingSampler;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@InternalVMMethod
public class JavaMainWrapper {
    public static final CGlobalData<CEntryPointCreateIsolateParameters> MAIN_ISOLATE_PARAMETERS = CGlobalDataFactory.createBytes(() -> SizeOf.get(CEntryPointCreateIsolateParameters.class));
    private static UnsignedWord argvLength;
    private static final CGlobalData<CCharPointer> START_THREAD_UNMANAGED_ERROR_MESSAGE;
    private static final CGlobalData<CCharPointer> JOIN_THREAD_UNMANAGED_ERROR_MESSAGE;
    private static final CGlobalData<CFunctionPointer> RUN_MAIN_ROUTINE;

    @Uninterruptible(reason="The caller initialized the thread state, so the callees do not need to be uninterruptible.", calleeMustBe=false)
    private static int runCore() {
        return JavaMainWrapper.runCore0();
    }

    private static int runCore0() {
        try {
            if (SubstrateOptions.DumpHeapAndExit.getValue().booleanValue()) {
                if (VMInspectionOptions.hasHeapDumpSupport()) {
                    String absoluteHeapDumpPath = new File(SubstrateOptions.Name.getValue() + ".hprof").getAbsolutePath();
                    VMRuntime.dumpHeap((String)absoluteHeapDumpPath, (boolean)true);
                    System.out.println("Heap dump created at '" + absoluteHeapDumpPath + "'.");
                    int n = 0;
                    return n;
                }
                System.err.println("Unable to dump heap. Heap dumping is only supported for native executables built with `" + VMInspectionOptions.getHeapdumpsCommandArgument() + "`.");
                int absoluteHeapDumpPath = 1;
                return absoluteHeapDumpPath;
            }
            if (SubstrateOptions.ParseRuntimeOptions.getValue().booleanValue()) {
                VMRuntime.initialize();
            }
            if (ImageSingletons.contains(ProfilingSampler.class)) {
                ((ProfilingSampler)ImageSingletons.lookup(ProfilingSampler.class)).registerSampler();
            }
            JNIJavaVMList.addJavaVM(JNIFunctionTables.singleton().getGlobalJavaVM());
            JavaMainSupport mainSupport = (JavaMainSupport)ImageSingletons.lookup(JavaMainSupport.class);
            mainSupport.javaMainHandle.invokeExact(mainSupport.mainArgs);
            int n = 0;
            return n;
        }
        catch (Throwable ex) {
            JavaThreads.dispatchUncaughtException(Thread.currentThread(), ex);
            int n = 1;
            return n;
        }
        finally {
            PlatformThreads.exit(Thread.currentThread());
        }
    }

    @Uninterruptible(reason="The caller initialized the thread state, so the callees do not need to be uninterruptible.", calleeMustBe=false)
    private static void runShutdown() {
        JavaMainWrapper.runShutdown0();
    }

    private static void runShutdown0() {
        PlatformThreads.ensureCurrentAssigned("DestroyJavaVM", null, false);
        PlatformThreads.singleton().joinAllNonDaemons();
        RuntimeSupport.getRuntimeSupport().shutdown();
        Counter.logValues(Log.log());
    }

    @Uninterruptible(reason="Thread state not set up yet.")
    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static int run(int argc, CCharPointerPointer argv) {
        if (SubstrateOptions.RunMainInNewThread.getValue().booleanValue()) {
            return JavaMainWrapper.doRunInNewThread(argc, argv);
        }
        return JavaMainWrapper.doRun(argc, argv);
    }

    @Uninterruptible(reason="Thread state not setup yet.")
    private static int doRun(int argc, CCharPointerPointer argv) {
        try {
            CPUFeatureAccess cpuFeatureAccess = (CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class);
            cpuFeatureAccess.verifyHostSupportsArchitectureEarlyOrExit();
            EnterCreateIsolateWithCArgumentsPrologue.enter(argc, argv);
            assert (!VMThreads.wasStartedByCurrentIsolate(CurrentIsolate.getCurrentThread())) : "re-attach would cause issues otherwise";
            Isolate isolate = CurrentIsolate.getIsolate();
            int exitCode = JavaMainWrapper.runCore();
            CEntryPointSetup.LeaveDetachThreadEpilogue.leave();
            EnterAttachThreadForShutdown.enter(isolate);
            JavaMainWrapper.runShutdown();
            CEntryPointSetup.LeaveDetachThreadEpilogue.leave();
            return exitCode;
        }
        catch (Throwable e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Thread state not setup yet.")
    private static int doRunInNewThread(int argc, CCharPointerPointer argv) {
        MAIN_ISOLATE_PARAMETERS.get().setArgc(argc);
        MAIN_ISOLATE_PARAMETERS.get().setArgv(argv);
        long stackSize = SubstrateOptions.StackSize.getHostedValue();
        PlatformThreads.OSThreadHandle osThreadHandle = PlatformThreads.singleton().startThreadUnmanaged(RUN_MAIN_ROUTINE.get(), WordFactory.nullPointer(), (int)stackSize);
        if (osThreadHandle.isNull()) {
            CEntryPointActions.failFatally(1, START_THREAD_UNMANAGED_ERROR_MESSAGE.get());
            return 1;
        }
        try {
            WordPointer threadExitStatus = (WordPointer)StackValue.get(WordPointer.class);
            boolean joined = PlatformThreads.singleton().joinThreadUnmanaged(osThreadHandle, threadExitStatus);
            if (!joined) {
                CEntryPointActions.failFatally(1, JOIN_THREAD_UNMANAGED_ERROR_MESSAGE.get());
                int n = 1;
                return n;
            }
            int n = (int)threadExitStatus.read().rawValue();
            return n;
        }
        finally {
            PlatformThreads.singleton().closeOSThreadHandle(osThreadHandle);
        }
    }

    @Uninterruptible(reason="Thread state not setup yet.")
    @CEntryPoint(name="__svm_JavaMainWrapper_runMainRoutine", include=RunMainInNewThreadBooleanSupplier.class)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    static WordBase runMainRoutine(PointerBase data) {
        int exitStatus = JavaMainWrapper.doRun(MAIN_ISOLATE_PARAMETERS.get().getArgc(), MAIN_ISOLATE_PARAMETERS.get().getArgv());
        return WordFactory.signed((int)exitStatus);
    }

    private static boolean isArgumentBlockSupported() {
        if (!Platform.includedIn(Platform.LINUX.class) && !Platform.includedIn(Platform.DARWIN.class)) {
            return false;
        }
        CEntryPointCreateIsolateParameters args = MAIN_ISOLATE_PARAMETERS.get();
        return !args.getArgv().isNull() && args.getArgc() > 0;
    }

    public static int getCRuntimeArgumentBlockLength() {
        if (!JavaMainWrapper.isArgumentBlockSupported()) {
            return -1;
        }
        CEntryPointCreateIsolateParameters args = MAIN_ISOLATE_PARAMETERS.get();
        CCharPointer firstArgPos = args.getArgv().read(0);
        if (argvLength.equal((UnsignedWord)WordFactory.zero())) {
            CCharPointer lastArgPos = args.getArgv().read(args.getArgc() - 1);
            UnsignedWord lastArgLength = SubstrateUtil.strlen(lastArgPos);
            argvLength = WordFactory.unsigned((long)lastArgPos.rawValue()).add(lastArgLength).subtract(WordFactory.unsigned((long)firstArgPos.rawValue()));
        }
        return Math.toIntExact(argvLength.rawValue());
    }

    public static boolean setCRuntimeArgument0(String arg0) {
        if (!JavaMainWrapper.isArgumentBlockSupported()) {
            throw new UnsupportedOperationException("Argument vector support not available");
        }
        boolean arg0truncation = false;
        try (CTypeConversion.CCharPointerHolder arg0Pin = CTypeConversion.toCString((CharSequence)arg0);){
            UnsignedWord origLength;
            CCharPointer arg0Pointer = arg0Pin.get();
            UnsignedWord arg0Length = SubstrateUtil.strlen(arg0Pointer);
            UnsignedWord newArgLength = origLength = WordFactory.unsigned((int)JavaMainWrapper.getCRuntimeArgumentBlockLength());
            if (arg0Length.add(1).belowThan(origLength)) {
                newArgLength = arg0Length.add(1);
            }
            arg0truncation = arg0Length.aboveThan(origLength);
            CCharPointer firstArgPos = MAIN_ISOLATE_PARAMETERS.get().getArgv().read(0);
            UnmanagedMemoryUtil.copy((Pointer)arg0Pointer, (Pointer)firstArgPos, newArgLength);
            UnmanagedMemoryUtil.fill(((Pointer)firstArgPos).add(newArgLength), origLength.subtract(newArgLength), (byte)0);
        }
        return arg0truncation;
    }

    public static String getCRuntimeArgument0() {
        if (!JavaMainWrapper.isArgumentBlockSupported()) {
            throw new UnsupportedOperationException("Argument vector support not available");
        }
        return CTypeConversion.toJavaString((CCharPointer)MAIN_ISOLATE_PARAMETERS.get().getArgv().read(0));
    }

    static {
        Word.ensureInitialized();
        argvLength = (UnsignedWord)WordFactory.zero();
        START_THREAD_UNMANAGED_ERROR_MESSAGE = CGlobalDataFactory.createCString("Running main entry point in a new platform thread failed. Platform thread failed to start.");
        JOIN_THREAD_UNMANAGED_ERROR_MESSAGE = CGlobalDataFactory.createCString("Thread that the main entry point was running on failed to join.");
        RUN_MAIN_ROUTINE = CGlobalDataFactory.forSymbol("__svm_JavaMainWrapper_runMainRoutine");
    }

    public static class EnterAttachThreadForShutdown
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to re-attach the main thread for shutting down the main isolate.");

        @Uninterruptible(reason="prologue")
        static void enter(Isolate isolate) {
            int code = CEntryPointActions.enterAttachThread(isolate, false);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    private static class EnterCreateIsolateWithCArgumentsPrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to create the main Isolate.");

        private EnterCreateIsolateWithCArgumentsPrologue() {
        }

        @Uninterruptible(reason="prologue")
        public static void enter(int paramArgc, CCharPointerPointer paramArgv) {
            CEntryPointCreateIsolateParameters args = MAIN_ISOLATE_PARAMETERS.get();
            args.setVersion(4);
            args.setArgc(paramArgc);
            args.setArgv(paramArgv);
            args.setIgnoreUnrecognizedArguments(false);
            args.setExitWhenArgumentParsingFails(true);
            int code = CEntryPointActions.enterCreateIsolate(args);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    private static class RunMainInNewThreadBooleanSupplier
    implements BooleanSupplier {
        private RunMainInNewThreadBooleanSupplier() {
        }

        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.RunMainInNewThread.getValue();
        }
    }

    public static class JavaMainSupport {
        final MethodHandle javaMainHandle;
        final String javaMainClassName;
        public String[] mainArgs;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public JavaMainSupport(Method javaMainMethod) throws IllegalAccessException {
            this.javaMainHandle = MethodHandles.lookup().unreflect(javaMainMethod);
            this.javaMainClassName = javaMainMethod.getDeclaringClass().getName();
        }

        public String getJavaCommand() {
            if (this.mainArgs != null) {
                StringBuilder commandLine = new StringBuilder(this.javaMainClassName);
                for (String arg : this.mainArgs) {
                    commandLine.append(' ');
                    commandLine.append(arg);
                }
                return commandLine.toString();
            }
            return null;
        }

        public List<String> getInputArguments() {
            CEntryPointCreateIsolateParameters args = MAIN_ISOLATE_PARAMETERS.get();
            if (args.getArgv().isNonNull() && args.getArgc() > 0) {
                String[] unmodifiedArgs = SubstrateUtil.convertCToJavaArgs(args.getArgc(), args.getArgv());
                ArrayList<String> inputArgs = new ArrayList<String>(Arrays.asList(unmodifiedArgs));
                if (this.mainArgs != null) {
                    inputArgs.removeAll(Arrays.asList(this.mainArgs));
                }
                return Collections.unmodifiableList(inputArgs);
            }
            return Collections.emptyList();
        }
    }
}

