/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferPool;
import com.oracle.svm.core.sampler.SamplerIsolateLocal;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

class SamplerThreadLocal
implements ThreadListener {
    private static final FastThreadLocalWord<SamplerBuffer> localBuffer = FastThreadLocalFactory.createWord("SamplerThreadLocal.localBuffer");
    private static final FastThreadLocalLong missedSamples = FastThreadLocalFactory.createLong("SamplerThreadLocal.missedSamples");
    private static final FastThreadLocalLong unparseableStacks = FastThreadLocalFactory.createLong("SamplerThreadLocal.unparseableStacks");
    private static final FastThreadLocalWord<SamplerSampleWriterData> writerData = FastThreadLocalFactory.createWord("SamplerThreadLocal.writerData");

    SamplerThreadLocal() {
    }

    @Override
    @Uninterruptible(reason="Only uninterruptible code may be executed before Thread.run.")
    public void beforeThreadRun(IsolateThread isolateThread, Thread javaThread) {
        if (SubstrateSigprofHandler.singleton().isProfilingEnabled()) {
            SamplerThreadLocal.initialize(isolateThread);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void initialize(IsolateThread isolateThread) {
        if (SamplerIsolateLocal.isKeySet()) {
            SamplerBufferPool.adjustBufferCount();
            UnsignedWord key = SamplerIsolateLocal.getKey();
            SubstrateSigprofHandler.singleton().setThreadLocalKeyValue(key, isolateThread);
        }
    }

    @Override
    @Uninterruptible(reason="Only uninterruptible code may be executed after Thread.exit.")
    public void afterThreadExit(IsolateThread isolateThread, Thread javaThread) {
        if (SubstrateSigprofHandler.singleton().isProfilingEnabled() && SamplerIsolateLocal.isKeySet()) {
            SamplerThreadLocal.teardown(isolateThread);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void teardown(IsolateThread isolateThread) {
        UnsignedWord key = SamplerIsolateLocal.getKey();
        SubstrateSigprofHandler.singleton().setThreadLocalKeyValue(key, (IsolateThread)WordFactory.nullPointer());
        SamplerBuffer threadLocalBuffer = localBuffer.get(isolateThread);
        SamplerBufferPool.releaseBufferAndAdjustCount(threadLocalBuffer);
        localBuffer.set(isolateThread, (SamplerBuffer)WordFactory.nullPointer());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static SamplerBuffer getThreadLocalBuffer() {
        return localBuffer.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setThreadLocalBuffer(SamplerBuffer buffer) {
        buffer.setOwner(SubstrateJVM.getThreadId(CurrentIsolate.getCurrentThread()));
        localBuffer.set(buffer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void increaseMissedSamples() {
        missedSamples.set(SamplerThreadLocal.getMissedSamples() + 1L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getMissedSamples() {
        return missedSamples.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void increaseUnparseableStacks() {
        unparseableStacks.set(SamplerThreadLocal.getUnparseableStacks() + 1L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getUnparseableStacks() {
        return unparseableStacks.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setWriterData(SamplerSampleWriterData data) {
        writerData.set(data);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static SamplerSampleWriterData getWriterData() {
        return writerData.get();
    }
}

