/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.os.AbstractRawFileOperationSupport;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.posix.PosixStat;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class PosixRawFileOperationSupport
extends AbstractRawFileOperationSupport {
    private static final int DEFAULT_PERMISSIONS = 438;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixRawFileOperationSupport(boolean useNativeByteOrder) {
        super(useNativeByteOrder);
    }

    @Override
    public RawFileOperationSupport.RawFileDescriptor open(File file, RawFileOperationSupport.FileAccessMode mode) {
        String path = file.getPath();
        int flags = PosixRawFileOperationSupport.parseMode(mode);
        try (CTypeConversion.CCharPointerHolder cPath = CTypeConversion.toCString((CharSequence)path);){
            RawFileOperationSupport.RawFileDescriptor rawFileDescriptor = (RawFileOperationSupport.RawFileDescriptor)WordFactory.signed((int)Fcntl.NoTransitions.open(cPath.get(), flags, 438));
            return rawFileDescriptor;
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isValid(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return posixFd > 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean close(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        int result = Unistd.NoTransitions.close(posixFd);
        return result == 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public SignedWord size(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return PosixStat.getSize(posixFd);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public SignedWord position(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return Unistd.NoTransitions.lseek(posixFd, WordFactory.signed((int)0), Unistd.SEEK_CUR());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean seek(RawFileOperationSupport.RawFileDescriptor fd, SignedWord position) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        SignedWord newPos = Unistd.NoTransitions.lseek(posixFd, position, Unistd.SEEK_SET());
        return position.equal(newPos);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean write(RawFileOperationSupport.RawFileDescriptor fd, Pointer data, UnsignedWord size) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        Pointer position = data;
        UnsignedWord remaining = size;
        while (remaining.aboveThan(0)) {
            SignedWord writtenBytes = Unistd.NoTransitions.write(posixFd, (PointerBase)position, remaining);
            if (writtenBytes.equal(-1)) {
                if (LibC.errno() == Errno.EINTR()) continue;
                return false;
            }
            position = position.add((UnsignedWord)writtenBytes);
            remaining = remaining.subtract((UnsignedWord)writtenBytes);
        }
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public SignedWord read(RawFileOperationSupport.RawFileDescriptor fd, Pointer buffer, UnsignedWord bufferSize) {
        SignedWord readBytes;
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        while ((readBytes = Unistd.NoTransitions.read(posixFd, (PointerBase)buffer, bufferSize)).equal(-1) && LibC.errno() == Errno.EINTR()) {
        }
        return readBytes;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getPosixFileDescriptor(RawFileOperationSupport.RawFileDescriptor fd) {
        int result = (int)fd.rawValue();
        assert ((long)result == fd.rawValue());
        return result;
    }

    private static int parseMode(RawFileOperationSupport.FileAccessMode mode) {
        switch (mode) {
            case READ: {
                return Fcntl.O_RDONLY();
            }
            case READ_WRITE: {
                return Fcntl.O_RDWR() | Fcntl.O_CREAT();
            }
            case WRITE: {
                return Fcntl.O_WRONLY() | Fcntl.O_CREAT();
            }
        }
        throw VMError.shouldNotReachHere();
    }
}

