/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK17OrEarlier;
import com.oracle.svm.core.jfr.JfrMetadataTypeLibrary;
import com.oracle.svm.util.ReflectionUtil;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrEvent {
    public static final JfrEvent ThreadStart = JfrEvent.create("jdk.ThreadStart");
    public static final JfrEvent ThreadEnd = JfrEvent.create("jdk.ThreadEnd");
    public static final JfrEvent DataLoss = JfrEvent.create("jdk.DataLoss");
    public static final JfrEvent ClassLoadingStatistics = JfrEvent.create("jdk.ClassLoadingStatistics");
    public static final JfrEvent InitialEnvironmentVariable = JfrEvent.create("jdk.InitialEnvironmentVariable");
    public static final JfrEvent InitialSystemProperty = JfrEvent.create("jdk.InitialSystemProperty");
    public static final JfrEvent JavaThreadStatistics = JfrEvent.create("jdk.JavaThreadStatistics");
    public static final JfrEvent JVMInformation = JfrEvent.create("jdk.JVMInformation");
    public static final JfrEvent OSInformation = JfrEvent.create("jdk.OSInformation");
    public static final JfrEvent PhysicalMemory = JfrEvent.create("jdk.PhysicalMemory");
    public static final JfrEvent ExecutionSample = JfrEvent.create("jdk.ExecutionSample");
    public static final JfrEvent NativeMethodSample = JfrEvent.create("jdk.NativeMethodSample");
    public static final JfrEvent GarbageCollection = JfrEvent.create("jdk.GarbageCollection");
    public static final JfrEvent GCPhasePauseEvent = JfrEvent.create("jdk.GCPhasePause");
    public static final JfrEvent GCPhasePauseLevel1Event = JfrEvent.create("jdk.GCPhasePauseLevel1");
    public static final JfrEvent GCPhasePauseLevel2Event = JfrEvent.create("jdk.GCPhasePauseLevel2");
    public static final JfrEvent GCPhasePauseLevel3Event = JfrEvent.create("jdk.GCPhasePauseLevel3");
    public static final JfrEvent GCPhasePauseLevel4Event = JfrEvent.create("jdk.GCPhasePauseLevel4");
    public static final JfrEvent SafepointBegin = JfrEvent.create("jdk.SafepointBegin");
    public static final JfrEvent SafepointEnd = JfrEvent.create("jdk.SafepointEnd");
    public static final JfrEvent ExecuteVMOperation = JfrEvent.create("jdk.ExecuteVMOperation");
    public static final JfrEvent JavaMonitorEnter = JfrEvent.create("jdk.JavaMonitorEnter");
    public static final JfrEvent ThreadSleep = JfrEvent.create("jdk.ThreadSleep", JDK17OrEarlier.class);
    public static final JfrEvent JavaMonitorWait = JfrEvent.create("jdk.JavaMonitorWait");
    private final long id;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static JfrEvent create(String name) {
        return JfrEvent.create(name, TargetClass.AlwaysIncluded.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static JfrEvent create(String name, Class<? extends BooleanSupplier> onlyWith) {
        BooleanSupplier onlyWithProvider = (BooleanSupplier)ReflectionUtil.newInstance(onlyWith);
        if (onlyWithProvider.getAsBoolean()) {
            return new JfrEvent(name);
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEvent(String name) {
        this.id = JfrMetadataTypeLibrary.lookupPlatformEvent(name);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getId() {
        return this.id;
    }
}

