/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ImageHeapInfo {
    public static final long NO_CHUNK = -1L;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyPrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyPrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyRelocatableObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyRelocatableObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritablePrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritablePrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritableReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritableReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritableHugeObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritableHugeObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyHugeObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyHugeObject;
    @UnknownObjectField(types={Object.class})
    public Object firstObject;
    @UnknownObjectField(types={Object.class})
    public Object lastObject;
    @UnknownPrimitiveField
    public long offsetOfFirstWritableAlignedChunk;
    @UnknownPrimitiveField
    public long offsetOfFirstWritableUnalignedChunk;
    @UnknownPrimitiveField
    public int dynamicHubCount;

    public void initialize(Object firstReadOnlyPrimitiveObject, Object lastReadOnlyPrimitiveObject, Object firstReadOnlyReferenceObject, Object lastReadOnlyReferenceObject, Object firstReadOnlyRelocatableObject, Object lastReadOnlyRelocatableObject, Object firstWritablePrimitiveObject, Object lastWritablePrimitiveObject, Object firstWritableReferenceObject, Object lastWritableReferenceObject, Object firstWritableHugeObject, Object lastWritableHugeObject, Object firstReadOnlyHugeObject, Object lastReadOnlyHugeObject, long offsetOfFirstWritableAlignedChunk, long offsetOfFirstWritableUnalignedChunk, int dynamicHubCount) {
        Object firstReadOnlyObject;
        assert (offsetOfFirstWritableAlignedChunk == -1L || offsetOfFirstWritableAlignedChunk >= 0L);
        assert (offsetOfFirstWritableUnalignedChunk == -1L || offsetOfFirstWritableUnalignedChunk >= 0L);
        this.firstReadOnlyPrimitiveObject = firstReadOnlyPrimitiveObject;
        this.lastReadOnlyPrimitiveObject = lastReadOnlyPrimitiveObject;
        this.firstReadOnlyReferenceObject = firstReadOnlyReferenceObject;
        this.lastReadOnlyReferenceObject = lastReadOnlyReferenceObject;
        this.firstReadOnlyRelocatableObject = firstReadOnlyRelocatableObject;
        this.lastReadOnlyRelocatableObject = lastReadOnlyRelocatableObject;
        this.firstWritablePrimitiveObject = firstWritablePrimitiveObject;
        this.lastWritablePrimitiveObject = lastWritablePrimitiveObject;
        this.firstWritableReferenceObject = firstWritableReferenceObject;
        this.lastWritableReferenceObject = lastWritableReferenceObject;
        this.firstWritableHugeObject = firstWritableHugeObject;
        this.lastWritableHugeObject = lastWritableHugeObject;
        this.firstReadOnlyHugeObject = firstReadOnlyHugeObject;
        this.lastReadOnlyHugeObject = lastReadOnlyHugeObject;
        this.offsetOfFirstWritableAlignedChunk = offsetOfFirstWritableAlignedChunk;
        this.offsetOfFirstWritableUnalignedChunk = offsetOfFirstWritableUnalignedChunk;
        this.dynamicHubCount = dynamicHubCount;
        Object object = firstReadOnlyPrimitiveObject != null ? firstReadOnlyPrimitiveObject : (firstReadOnlyObject = firstReadOnlyReferenceObject != null ? firstReadOnlyReferenceObject : firstReadOnlyRelocatableObject);
        Object lastReadOnlyObject = lastReadOnlyRelocatableObject != null ? lastReadOnlyRelocatableObject : (lastReadOnlyReferenceObject != null ? lastReadOnlyReferenceObject : lastReadOnlyPrimitiveObject);
        Object firstWritableObject = firstWritablePrimitiveObject != null ? firstWritablePrimitiveObject : firstWritableReferenceObject;
        Object lastWritableObject = lastWritableReferenceObject != null ? lastWritableReferenceObject : lastWritablePrimitiveObject;
        Object firstRegularObject = firstReadOnlyObject != null ? firstReadOnlyObject : firstWritableObject;
        Object lastRegularObject = lastWritableObject != null ? lastWritableObject : lastReadOnlyObject;
        Object firstHugeObject = firstWritableHugeObject != null ? firstWritableHugeObject : firstReadOnlyHugeObject;
        Object lastHugeObject = lastReadOnlyHugeObject != null ? lastReadOnlyHugeObject : lastWritableHugeObject;
        this.firstObject = firstRegularObject != null ? firstRegularObject : firstHugeObject;
        this.lastObject = lastHugeObject != null ? lastHugeObject : lastRegularObject;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyPrimitivePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyPrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastReadOnlyPrimitiveObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyReferencePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastReadOnlyReferenceObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyRelocatablePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyRelocatableObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastReadOnlyRelocatableObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritablePrimitivePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritablePrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastWritablePrimitiveObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritableReferencePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritableReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastWritableReferenceObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritableHugePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritableHugeObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastWritableHugeObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyHugePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyHugeObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastReadOnlyHugeObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer objectPointer) {
        boolean result = objectPointer.isNull() ? false : objectPointer.aboveOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.firstObject)) && objectPointer.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastObject));
        return result;
    }

    public AlignedHeapChunk.AlignedHeader getFirstWritableAlignedChunk() {
        return (AlignedHeapChunk.AlignedHeader)ImageHeapInfo.asImageHeapChunk(this.offsetOfFirstWritableAlignedChunk);
    }

    public UnalignedHeapChunk.UnalignedHeader getFirstWritableUnalignedChunk() {
        return (UnalignedHeapChunk.UnalignedHeader)ImageHeapInfo.asImageHeapChunk(this.offsetOfFirstWritableUnalignedChunk);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Word getObjectEnd(Object obj) {
        if (obj == null) {
            return (Word)WordFactory.nullPointer();
        }
        return Word.objectToUntrackedPointer((Object)obj).add(LayoutEncoding.getSizeFromObject(obj));
    }

    private static <T extends HeapChunk.Header<T>> T asImageHeapChunk(long offsetInImageHeap) {
        if (offsetInImageHeap < 0L) {
            return (T)((HeapChunk.Header)WordFactory.nullPointer());
        }
        UnsignedWord offset = WordFactory.unsigned((long)offsetInImageHeap);
        return (T)((HeapChunk.Header)KnownIntrinsics.heapBase().add(offset));
    }

    public void print(Log log) {
        log.string("ReadOnly Primitives: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstReadOnlyPrimitiveObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastReadOnlyPrimitiveObject)).newline();
        log.string("ReadOnly References: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstReadOnlyReferenceObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastReadOnlyReferenceObject)).newline();
        log.string("ReadOnly Relocatables: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstReadOnlyRelocatableObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastReadOnlyRelocatableObject)).newline();
        log.string("Writable Primitives: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstWritablePrimitiveObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastWritablePrimitiveObject)).newline();
        log.string("Writable References: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstWritableReferenceObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastWritableReferenceObject)).newline();
        log.string("Writable Huge: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstWritableHugeObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastWritableHugeObject)).newline();
        log.string("ReadOnly Huge: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstReadOnlyHugeObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastReadOnlyHugeObject));
    }
}

