/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.c.HostedNonmovableArray;
import com.oracle.svm.core.c.HostedNonmovableObjectArray;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class NonmovableArrays {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final HostedNonmovableArray<?> HOSTED_NULL_VALUE = new HostedNonmovableObjectArray(null);
    private static final UninterruptibleUtils.AtomicLong runtimeArraysInExistence = new UninterruptibleUtils.AtomicLong(0L);
    private static final OutOfMemoryError OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate nonmovable array");

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static <T extends NonmovableArray<?>> T createArray(int length, Class<?> arrayType) {
        if (SubstrateUtil.HOSTED) {
            Class<?> componentType = arrayType.getComponentType();
            Object array = Array.newInstance(componentType, length);
            return (T)(componentType.isPrimitive() ? new HostedNonmovableArray(array) : new HostedNonmovableObjectArray(array));
        }
        DynamicHub hub = SubstrateUtil.cast(arrayType, DynamicHub.class);
        assert (LayoutEncoding.isArray(hub.getLayoutEncoding()));
        UnsignedWord size = LayoutEncoding.getArraySize(hub.getLayoutEncoding(), length);
        Pointer array = (Pointer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).calloc(size);
        if (array.isNull()) {
            throw OUT_OF_MEMORY_ERROR;
        }
        ObjectHeader header = Heap.getHeap().getObjectHeader();
        Word encodedHeader = header.encodeAsUnmanagedObjectHeader(hub);
        header.initializeHeaderOfNewObject(array, encodedHeader);
        array.writeInt(ConfigurationValues.getObjectLayout().getArrayLengthOffset(), length);
        NonmovableArrays.trackUnmanagedArray((NonmovableArray)array);
        return (T)((NonmovableArray)array);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void trackUnmanagedArray(NonmovableArray<?> array) {
        assert (!Heap.getHeap().isInImageHeap((Pointer)array)) : "must not track image heap objects";
        assert (array.isNull() || runtimeArraysInExistence.incrementAndGet() > 0L) : "overflow";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static DynamicHub readHub(NonmovableArray<?> array) {
        ObjectHeader objectHeader = Heap.getHeap().getObjectHeader();
        return objectHeader.readDynamicHubFromPointer((Pointer)array);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int readLayoutEncoding(NonmovableArray<?> array) {
        return NonmovableArrays.readHub(array).getLayoutEncoding();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int readElementShift(NonmovableArray<?> array) {
        return LayoutEncoding.getArrayIndexShift(NonmovableArrays.readLayoutEncoding(array));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int readArrayBase(NonmovableArray<?> array) {
        return (int)LayoutEncoding.getArrayBaseOffset(NonmovableArrays.readLayoutEncoding(array)).rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int lengthOf(NonmovableArray<?> array) {
        if (SubstrateUtil.HOSTED) {
            return Array.getLength(NonmovableArrays.getHostedArray(array));
        }
        return ((Pointer)array).readInt(ConfigurationValues.getObjectLayout().getArrayLengthOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord byteSizeOf(NonmovableArray<?> array) {
        return array.isNonNull() ? LayoutEncoding.getArraySize(NonmovableArrays.readLayoutEncoding(array), NonmovableArrays.lengthOf(array)) : (UnsignedWord)WordFactory.zero();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void arraycopy(NonmovableArray<?> src, int srcPos, NonmovableArray<?> dest, int destPos, int length) {
        if (SubstrateUtil.HOSTED) {
            System.arraycopy(NonmovableArrays.getHostedArray(src), srcPos, NonmovableArrays.getHostedArray(dest), destPos, length);
            return;
        }
        assert (srcPos >= 0 && destPos >= 0 && length >= 0 && srcPos + length <= NonmovableArrays.lengthOf(src) && destPos + length <= NonmovableArrays.lengthOf(dest));
        assert (NonmovableArrays.readHub(src) == NonmovableArrays.readHub(dest)) : "copying is only allowed with same component types";
        UnmanagedMemoryUtil.copy((Pointer)NonmovableArrays.addressOf(src, srcPos), (Pointer)NonmovableArrays.addressOf(dest, destPos), WordFactory.unsigned((int)(length << NonmovableArrays.readElementShift(dest))));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends NonmovableArray<?>> T nullArray() {
        if (SubstrateUtil.HOSTED) {
            return (T)HOSTED_NULL_VALUE;
        }
        return (T)((NonmovableArray)WordFactory.nullPointer());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<Byte> createByteArray(int nbytes) {
        return NonmovableArrays.createArray(nbytes, byte[].class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<Integer> createIntArray(int length) {
        return NonmovableArrays.createArray(length, int[].class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends WordBase> NonmovableArray<T> createWordArray(int length) {
        return NonmovableArrays.createArray(length, WordBase[].class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> NonmovableObjectArray<T> createObjectArray(Class<T[]> arrayType, int length) {
        assert (!SubstrateUtil.HOSTED ? LayoutEncoding.isObjectArray(SubstrateUtil.cast(arrayType, DynamicHub.class).getLayoutEncoding()) : arrayType.isArray() && !arrayType.getComponentType().isPrimitive()) : "must be an object array type";
        return (NonmovableObjectArray)NonmovableArrays.createArray(length, arrayType);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> NonmovableObjectArray<T> copyOfObjectArray(T[] source, int newLength) {
        NonmovableObjectArray array = (NonmovableObjectArray)NonmovableArrays.createArray(newLength, source.getClass());
        int copyLength = source.length < newLength ? source.length : newLength;
        for (int i = 0; i < copyLength; ++i) {
            NonmovableArrays.setObject(array, i, source[i]);
        }
        return array;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> NonmovableObjectArray<T> copyOfObjectArray(T[] source) {
        return NonmovableArrays.copyOfObjectArray(source, source.length);
    }

    public static byte[] heapCopyOfByteArray(NonmovableArray<Byte> source) {
        if (source.isNull()) {
            return null;
        }
        int length = NonmovableArrays.lengthOf(source);
        return NonmovableArrays.arraycopyToHeap(source, 0, new byte[length], 0, length);
    }

    public static int[] heapCopyOfIntArray(NonmovableArray<Integer> source) {
        if (source.isNull()) {
            return null;
        }
        int length = NonmovableArrays.lengthOf(source);
        return NonmovableArrays.arraycopyToHeap(source, 0, new int[length], 0, length);
    }

    public static <T> T[] heapCopyOfObjectArray(NonmovableObjectArray<T> source) {
        if (source.isNull()) {
            return null;
        }
        if (SubstrateUtil.HOSTED) {
            Object[] hosted = (Object[])NonmovableArrays.getHostedArray(source);
            return Arrays.copyOf(hosted, hosted.length);
        }
        int length = NonmovableArrays.lengthOf(source);
        Class<?> componentType = DynamicHub.toClass(NonmovableArrays.readHub(source).getComponentHub());
        Object[] dest = (Object[])Array.newInstance(componentType, length);
        return NonmovableArrays.arraycopyToHeap(source, 0, dest, 0, length);
    }

    @Uninterruptible(reason="Destination array must not move.")
    private static <T> T arraycopyToHeap(NonmovableArray<?> src, int srcPos, T dest, int destPos, int length) {
        if (SubstrateUtil.HOSTED) {
            System.arraycopy(NonmovableArrays.getHostedArray(src), srcPos, dest, destPos, length);
            return dest;
        }
        DynamicHub destHub = KnownIntrinsics.readHub(dest);
        assert (LayoutEncoding.isArray(destHub.getLayoutEncoding()) && destHub == NonmovableArrays.readHub(src)) : "Copying is only supported for arrays with identical types";
        assert (srcPos >= 0 && destPos >= 0 && length >= 0 && srcPos + length <= NonmovableArrays.lengthOf(src) && destPos + length <= ArrayLengthNode.arrayLength(dest));
        Word destAddressAtPos = Word.objectToUntrackedPointer(dest).add(LayoutEncoding.getArrayElementOffset(destHub.getLayoutEncoding(), destPos));
        if (LayoutEncoding.isPrimitiveArray(destHub.getLayoutEncoding())) {
            Pointer srcAddressAtPos = (Pointer)NonmovableArrays.addressOf(src, srcPos);
            JavaMemoryUtil.copyPrimitiveArrayForward(srcAddressAtPos, (Pointer)destAddressAtPos, WordFactory.unsigned((int)(length << NonmovableArrays.readElementShift(src))));
        } else {
            Object[] destArr = (Object[])dest;
            for (int i = 0; i < length; ++i) {
                destArr[destPos + i] = NonmovableArrays.getObject((NonmovableObjectArray)src, srcPos + i);
            }
        }
        return dest;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void releaseUnmanagedArray(NonmovableArray<?> array) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free(array);
        NonmovableArrays.untrackUnmanagedArray(array);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void untrackUnmanagedArray(NonmovableArray<?> array) {
        assert (!Heap.getHeap().isInImageHeap((Pointer)array)) : "must not track image heap objects";
        assert (array.isNull() || runtimeArraysInExistence.getAndDecrement() > 0L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> NonmovableArray<T> fromImageHeap(Object array) {
        if (SubstrateUtil.HOSTED) {
            if (array == null) {
                return HOSTED_NULL_VALUE;
            }
            VMError.guarantee(array.getClass().getComponentType().isPrimitive(), "Must call the method for Object[]");
            return new HostedNonmovableArray(array);
        }
        assert (array == null || Heap.getHeap().isInImageHeap(array));
        return array != null ? (NonmovableArray)Word.objectToUntrackedPointer((Object)array) : (NonmovableArray)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> NonmovableObjectArray<T> fromImageHeap(Object[] array) {
        if (SubstrateUtil.HOSTED) {
            return array != null ? new HostedNonmovableObjectArray(array) : (NonmovableObjectArray)((Object)HOSTED_NULL_VALUE);
        }
        return (NonmovableObjectArray)NonmovableArrays.fromImageHeap((Object)array);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <T> T getHostedArray(NonmovableArray<?> array) {
        return (T)((HostedNonmovableArray)array).getArray();
    }

    public static ByteBuffer asByteBuffer(NonmovableArray<Byte> array) {
        if (SubstrateUtil.HOSTED) {
            return ByteBuffer.wrap((byte[])NonmovableArrays.getHostedArray(array));
        }
        return CTypeConversion.asByteBuffer(NonmovableArrays.addressOf(array, 0), (int)NonmovableArrays.lengthOf(array));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean matches(NonmovableArray<?> array, boolean primitive, int elementSize) {
        int encoding = NonmovableArrays.readLayoutEncoding(array);
        return primitive == LayoutEncoding.isPrimitiveArray(encoding) && 1 << LayoutEncoding.getArrayIndexShift(encoding) == elementSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getInt(NonmovableArray<Integer> array, int index) {
        if (SubstrateUtil.HOSTED) {
            int[] hosted = (int[])NonmovableArrays.getHostedArray(array);
            return hosted[index];
        }
        assert (DynamicHub.toClass(NonmovableArrays.readHub(array)) == int[].class);
        return ((Pointer)NonmovableArrays.addressOf(array, index)).readInt(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setInt(NonmovableArray<Integer> array, int index, int value) {
        if (SubstrateUtil.HOSTED) {
            int[] hosted = (int[])NonmovableArrays.getHostedArray(array);
            hosted[index] = value;
            return;
        }
        assert (DynamicHub.toClass(NonmovableArrays.readHub(array)) == int[].class);
        ((Pointer)NonmovableArrays.addressOf(array, index)).writeInt(0, value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends WordBase> void setWord(NonmovableArray<T> array, int index, T value) {
        if (SubstrateUtil.HOSTED) {
            WordBase[] hosted = (WordBase[])NonmovableArrays.getHostedArray(array);
            hosted[index] = value;
            return;
        }
        assert (NonmovableArrays.matches(array, true, ConfigurationValues.getTarget().wordSize));
        ((Pointer)NonmovableArrays.addressOf(array, index)).writeWord(0, value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends WordBase> T getWord(NonmovableArray<T> array, int index) {
        if (SubstrateUtil.HOSTED) {
            WordBase[] hosted = (WordBase[])NonmovableArrays.getHostedArray(array);
            return (T)hosted[index];
        }
        assert (NonmovableArrays.matches(array, true, ConfigurationValues.getTarget().wordSize));
        return (T)((Pointer)NonmovableArrays.addressOf(array, index)).readWord(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T addressOf(NonmovableArray<?> array, int index) {
        assert (index >= 0 && index <= NonmovableArrays.lengthOf(array));
        return (T)NonmovableArrays.getArrayBase(array).add(index << NonmovableArrays.readElementShift(array));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Pointer> T getArrayBase(NonmovableArray<?> array) {
        return (T)((Pointer)array).add(NonmovableArrays.readArrayBase(array));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> T getObject(NonmovableObjectArray<T> array, int index) {
        if (SubstrateUtil.HOSTED) {
            Object[] hosted = (Object[])NonmovableArrays.getHostedArray(array);
            return (T)hosted[index];
        }
        assert (NonmovableArrays.matches(array, false, ConfigurationValues.getObjectLayout().getReferenceSize()));
        return (T)ReferenceAccess.singleton().readObjectAt((Pointer)NonmovableArrays.addressOf(array, index), true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> void setObject(NonmovableObjectArray<T> array, int index, T value) {
        if (SubstrateUtil.HOSTED) {
            Object[] hosted = (Object[])NonmovableArrays.getHostedArray(array);
            hosted[index] = value;
            return;
        }
        assert (NonmovableArrays.matches(array, false, ConfigurationValues.getObjectLayout().getReferenceSize()));
        ReferenceAccess.singleton().writeObjectAt((Pointer)NonmovableArrays.addressOf(array, index), value, true);
    }

    public static boolean walkUnmanagedObjectArray(NonmovableObjectArray<?> array, ObjectReferenceVisitor visitor) {
        if (array.isNonNull()) {
            return NonmovableArrays.walkUnmanagedObjectArray(array, visitor, 0, NonmovableArrays.lengthOf(array));
        }
        return true;
    }

    public static boolean walkUnmanagedObjectArray(NonmovableObjectArray<?> array, ObjectReferenceVisitor visitor, int startIndex, int count) {
        if (array.isNonNull()) {
            assert (startIndex >= 0 && count <= NonmovableArrays.lengthOf(array) - startIndex);
            int refSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            assert (refSize == 1 << NonmovableArrays.readElementShift(array));
            Pointer p = ((Pointer)array).add(NonmovableArrays.readArrayBase(array)).add(startIndex * refSize);
            for (int i = 0; i < count; ++i) {
                if (!visitor.visitObjectReference(p, true, null)) {
                    return false;
                }
                p = p.add(refSize);
            }
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void tearDown() {
        assert (runtimeArraysInExistence.get() == 0L) : "All runtime-allocated NonmovableArrays must have been freed";
    }

    private NonmovableArrays() {
    }
}

