/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.invoke;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodHandle;
import sun.invoke.util.Wrapper;

public class MethodHandleUtils {
    public static Object cast(Object obj, Class<?> type) {
        Wrapper destinationWrapper = type.isPrimitive() ? Wrapper.forPrimitiveType(type) : (Wrapper.isWrapperType(type) ? Wrapper.forWrapperType(type) : Wrapper.OBJECT);
        return destinationWrapper.cast(obj, type);
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static long longUnbox(Object retVal, MethodHandle methodHandle) {
        return MethodHandleUtils.longUnbox(retVal, methodHandle.type().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static long longUnbox(Object retVal, Target_java_lang_invoke_MemberName memberName) {
        return MethodHandleUtils.longUnbox(retVal, memberName.getMethodType().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    private static long longUnbox(Object retVal, Class<?> returnType) {
        switch (Wrapper.forPrimitiveType(returnType)) {
            case BOOLEAN: {
                return (Boolean)retVal != false ? 1L : 0L;
            }
            case BYTE: {
                return ((Byte)retVal).byteValue();
            }
            case SHORT: {
                return ((Short)retVal).shortValue();
            }
            case CHAR: {
                return ((Character)retVal).charValue();
            }
            case INT: {
                return ((Integer)retVal).intValue();
            }
            case LONG: {
                return (Long)retVal;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected type for unbox function");
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static int intUnbox(Object retVal, MethodHandle methodHandle) {
        return MethodHandleUtils.intUnbox(retVal, methodHandle.type().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static int intUnbox(Object retVal, Target_java_lang_invoke_MemberName memberName) {
        return MethodHandleUtils.intUnbox(retVal, memberName.getMethodType().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static int intUnbox(Object retVal, Class<?> returnType) {
        switch (Wrapper.forPrimitiveType(returnType)) {
            case BOOLEAN: {
                return (Boolean)retVal != false ? 1 : 0;
            }
            case BYTE: {
                return ((Byte)retVal).byteValue();
            }
            case SHORT: {
                return ((Short)retVal).shortValue();
            }
            case CHAR: {
                return ((Character)retVal).charValue();
            }
            case INT: {
                return (Integer)retVal;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected type for unbox function");
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static short shortUnbox(Object retVal, MethodHandle methodHandle) {
        return MethodHandleUtils.shortUnbox(retVal, methodHandle.type().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static short shortUnbox(Object retVal, Target_java_lang_invoke_MemberName memberName) {
        return MethodHandleUtils.shortUnbox(retVal, memberName.getMethodType().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static short shortUnbox(Object retVal, Class<?> returnType) {
        switch (Wrapper.forPrimitiveType(returnType)) {
            case BOOLEAN: {
                return (Boolean)retVal != false ? (short)1 : 0;
            }
            case BYTE: {
                return ((Byte)retVal).byteValue();
            }
            case SHORT: {
                return (Short)retVal;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected type for unbox function");
    }
}

