/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.CallChecker;
import com.oracle.svm.hosted.analysis.CustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.DynamicHubInitializer;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.PointsToCustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.UserLimitationsChecker;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.options.OptionValues;

public class NativeImagePointsToAnalysis
extends PointsToAnalysis
implements Inflation {
    private final AnnotationSubstitutionProcessor annotationSubstitutionProcessor;
    private final DynamicHubInitializer dynamicHubInitializer;
    private final CustomTypeFieldHandler customTypeFieldHandler;
    private final CallChecker callChecker;

    public NativeImagePointsToAnalysis(OptionValues options, AnalysisUniverse universe, HostedProviders providers, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ForkJoinPool executor, Runnable heartbeatCallback, UnsupportedFeatures unsupportedFeatures, TimerCollection timerCollection) {
        super(options, universe, providers, universe.hostVM(), executor, heartbeatCallback, unsupportedFeatures, timerCollection, SubstrateOptions.parseOnce());
        this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        this.dynamicHubInitializer = new DynamicHubInitializer(this);
        this.customTypeFieldHandler = new PointsToCustomTypeFieldHandler(this, this.metaAccess);
        this.callChecker = new CallChecker();
    }

    public boolean isCallAllowed(PointsToAnalysis bb, AnalysisMethod caller, AnalysisMethod target, BytecodePosition srcPosition) {
        return this.callChecker.isCallAllowed((BigBang)bb, caller, target, srcPosition);
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod methodFlow) {
        return HostedConfiguration.instance().createMethodTypeFlowBuilder(bb, methodFlow);
    }

    @Override
    public SVMHost getHostVM() {
        return (SVMHost)this.hostVM;
    }

    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.customTypeFieldHandler.cleanupAfterAnalysis();
    }

    public void checkUserLimitations() {
        super.checkUserLimitations();
        UserLimitationsChecker.check(this);
    }

    @Override
    public AnnotationSubstitutionProcessor getAnnotationSubstitutionProcessor() {
        return this.annotationSubstitutionProcessor;
    }

    public void onFieldAccessed(AnalysisField field) {
        this.customTypeFieldHandler.handleField(field);
    }

    public void onTypeInitialized(AnalysisType type) {
        this.postTask(d -> this.initializeMetaData(type));
    }

    public void initializeMetaData(AnalysisType type) {
        this.dynamicHubInitializer.initializeMetaData(this.universe.getHeapScanner(), type);
    }

    public static ResolvedJavaType toWrappedType(ResolvedJavaType type) {
        if (type instanceof AnalysisType) {
            return ((AnalysisType)type).getWrappedWithoutResolve();
        }
        if (type instanceof HostedType) {
            return ((HostedType)type).getWrapped().getWrappedWithoutResolve();
        }
        return type;
    }

    public boolean trackConcreteAnalysisObjects(AnalysisType type) {
        return !SVMHost.isUnknownClass((ResolvedJavaType)type);
    }

    @Override
    public SubstrateReplacements getReplacements() {
        return (SubstrateReplacements)super.getReplacements();
    }
}

