/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.code.SubstrateCompilationIdentifier;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.meta.SubstrateMethod;
import java.io.PrintStream;
import java.util.EnumMap;
import java.util.Map;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationWatchDog;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.nativeimage.ImageSingletons;

public class SubstrateGraalUtils {
    private static final Map<CompilationWrapper.ExceptionAction, Integer> compilationProblemsPerAction = new EnumMap<CompilationWrapper.ExceptionAction, Integer>(CompilationWrapper.ExceptionAction.class);
    private static final CompilationWatchDog.EventHandler COMPILATION_WATCH_DOG_EVENT_HANDLER = new CompilationWatchDog.EventHandler(){

        public void onStuckCompilation(CompilationWatchDog watchDog, Thread watched, CompilationIdentifier compilation, StackTraceElement[] stackTrace, int stuckTime) {
            super.onStuckCompilation(watchDog, watched, compilation, stackTrace, stuckTime);
            TTY.println((String)"Compilation %s on %s appears stuck - exiting VM", (Object[])new Object[]{compilation, watched});
            System.exit(84);
        }
    };
    private static boolean architectureInitialized;

    public static CompilationResult compile(DebugContext debug, SubstrateMethod method) {
        return SubstrateGraalUtils.doCompile(debug, GraalSupport.getRuntimeConfig(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), method);
    }

    public static CompilationResult doCompile(DebugContext initialDebug, final RuntimeConfiguration runtimeConfig, final Suites suites, final LIRSuites lirSuites, final SubstrateMethod method) {
        SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures(runtimeConfig.lookupBackend(method));
        final String methodString = method.format("%H.%n(%p)");
        final SubstrateCompilationIdentifier compilationId = new SubstrateCompilationIdentifier(method);
        return (CompilationResult)new CompilationWrapper<CompilationResult>(GraalSupport.get().getDebugOutputDirectory(), compilationProblemsPerAction){

            <E extends Throwable> RuntimeException silenceThrowable(Class<E> type, Throwable ex) throws E {
                throw ex;
            }

            protected CompilationResult handleException(Throwable t) {
                throw this.silenceThrowable(RuntimeException.class, t);
            }

            protected CompilationResult performCompilation(DebugContext debug) {
                try (CompilationWatchDog watchdog = CompilationWatchDog.watch((CompilationIdentifier)compilationId, (OptionValues)debug.getOptions(), (boolean)false, (CompilationWatchDog.EventHandler)COMPILATION_WATCH_DOG_EVENT_HANDLER);){
                    StructuredGraph graph = GraalSupport.decodeGraph(debug, null, compilationId, method);
                    CompilationResult compilationResult = SubstrateGraalUtils.compileGraph(runtimeConfig, suites, lirSuites, method, graph);
                    return compilationResult;
                }
            }

            public String toString() {
                return methodString;
            }

            protected DebugContext createRetryDebugContext(DebugContext initialDebug, OptionValues options, PrintStream logStream) {
                return GraalSupport.get().openDebugContext(options, compilationId, method, logStream);
            }

            protected void exitHostVM(int status) {
                System.exit(status);
            }
        }.run(initialDebug);
    }

    public static void updateGraalArchitectureWithHostCPUFeatures(Backend graalBackend) {
        if (SubstrateUtil.HOSTED) {
            throw VMError.shouldNotReachHere("Architecture should be updated only at runtime.");
        }
        if (!architectureInitialized) {
            architectureInitialized = true;
            CPUFeatureAccess cpuFeatureAccess = (CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class);
            if (cpuFeatureAccess != null) {
                Architecture architecture = graalBackend.getCodeCache().getTarget().arch;
                cpuFeatureAccess.enableFeatures(architecture);
            }
        }
    }

    public static CompilationResult compileGraph(SharedMethod method, StructuredGraph graph) {
        return SubstrateGraalUtils.compileGraph(GraalSupport.getRuntimeConfig(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), method, graph);
    }

    /*
     * Exception decompiling
     */
    private static CompilationResult compileGraph(RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites, SharedMethod method, StructuredGraph graph) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Options {
        public static final RuntimeOptionKey<Boolean> ForceDumpGraphsBeforeCompilation = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
    }
}

