/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jvmstat.PerfDataHolder;
import com.oracle.svm.core.jvmstat.PerfLongConstant;
import com.oracle.svm.core.jvmstat.PerfLongCounter;
import com.oracle.svm.core.jvmstat.PerfLongVariable;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfStringConstant;
import com.oracle.svm.core.jvmstat.PerfUnit;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationListener;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

class SystemCounters
implements PerfDataHolder,
VMOperationListener {
    private final PerfLongConstant initDoneTime;
    private final PerfStringConstant javaCommand;
    private final PerfStringConstant vmArgs;
    private final PerfStringConstant vmFlags;
    private final PerfLongConstant frequency;
    private final PerfLongConstant loadedClasses;
    private final PerfLongConstant processors;
    private final PerfStringConstant tempDir;
    private final PerfStringConstant javaVersion;
    private final PerfStringConstant vmName;
    private final PerfStringConstant vmVendor;
    private final PerfStringConstant vmVersion;
    private final PerfStringConstant osArch;
    private final PerfStringConstant osName;
    private final PerfStringConstant userDir;
    private final PerfStringConstant userName;
    private final PerfLongVariable gcInProgress;
    private final PerfLongCounter uptime;
    private final PerfLongCounter startedThreads;
    private final PerfLongVariable liveThreads;
    private final PerfLongCounter peakThreads;
    private final PerfLongVariable daemonThreads;
    private final PerfLongCounter processCPUTimeCounter;
    private OperatingSystemMXBean osMXBean;
    private ThreadMXBean threadMXBean;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SystemCounters(PerfManager perfManager) {
        boolean hasJavaMainSupport = ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class);
        this.initDoneTime = perfManager.createLongConstant("sun.rt.vmInitDoneTime", PerfUnit.TICKS);
        this.javaCommand = hasJavaMainSupport ? perfManager.createStringConstant("sun.rt.javaCommand") : null;
        this.vmArgs = hasJavaMainSupport ? perfManager.createStringConstant("java.rt.vmArgs") : null;
        this.vmFlags = perfManager.createStringConstant("java.rt.vmFlags");
        this.frequency = perfManager.createLongConstant("sun.os.hrt.frequency", PerfUnit.HERTZ);
        this.loadedClasses = perfManager.createLongConstant("java.cls.loadedClasses", PerfUnit.EVENTS);
        this.processors = perfManager.createLongConstant("com.oracle.svm.processors", PerfUnit.EVENTS);
        this.tempDir = perfManager.createStringConstant("java.property.java.io.tmpdir");
        this.javaVersion = perfManager.createStringConstant("java.property.java.version");
        this.vmName = perfManager.createStringConstant("java.property.java.vm.name");
        this.vmVendor = perfManager.createStringConstant("java.property.java.vm.vendor");
        this.vmVersion = perfManager.createStringConstant("java.property.java.vm.version");
        this.osArch = perfManager.createStringConstant("java.property.os.arch");
        this.osName = perfManager.createStringConstant("java.property.os.name");
        this.userDir = perfManager.createStringConstant("java.property.user.dir");
        this.userName = perfManager.createStringConstant("java.property.user.name");
        this.gcInProgress = perfManager.createLongVariable("com.oracle.svm.gcInProgress", PerfUnit.NONE);
        this.uptime = perfManager.createLongCounter("sun.os.hrt.ticks", PerfUnit.TICKS);
        this.startedThreads = perfManager.createLongCounter("java.threads.started", PerfUnit.EVENTS);
        this.liveThreads = perfManager.createLongVariable("java.threads.live", PerfUnit.NONE);
        this.peakThreads = perfManager.createLongCounter("java.threads.livePeak", PerfUnit.NONE);
        this.daemonThreads = perfManager.createLongVariable("java.threads.daemon", PerfUnit.NONE);
        this.processCPUTimeCounter = perfManager.createLongCounter("com.oracle.svm.processCPUTime", PerfUnit.TICKS);
    }

    @Override
    public void allocate() {
        this.osMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
            this.javaCommand.allocate(SystemCounters.getJavaCommand());
            this.vmArgs.allocate(SystemCounters.getVmArgs());
        }
        this.vmFlags.allocate("");
        this.frequency.allocate(TimeUnit.SECONDS.toNanos(1L));
        this.loadedClasses.allocate(SystemCounters.numberOfLoadedClasses());
        this.processors.allocate(SystemCounters.getAvailableProcessors());
        this.tempDir.allocate(System.getProperty("java.io.tmpdir"));
        this.javaVersion.allocate(System.getProperty("java.version"));
        this.vmName.allocate(System.getProperty("java.vm.name"));
        this.vmVendor.allocate(System.getProperty("java.vm.vendor"));
        this.vmVersion.allocate(System.getProperty("java.vm.version"));
        this.osArch.allocate(System.getProperty("os.arch"));
        this.osName.allocate(System.getProperty("os.name"));
        this.userDir.allocate(System.getProperty("user.dir"));
        this.userName.allocate(System.getProperty("user.name"));
        this.gcInProgress.allocate();
        this.uptime.allocate();
        this.startedThreads.allocate();
        this.liveThreads.allocate();
        this.peakThreads.allocate();
        this.daemonThreads.allocate();
        this.processCPUTimeCounter.allocate();
        this.initDoneTime.allocate(System.currentTimeMillis());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void vmOperationChanged(VMOperation operation) {
        boolean gc = operation != null && operation.isGC();
        this.gcInProgress.setValue(gc ? 1L : 0L);
    }

    @Override
    public void update() {
        PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
        this.uptime.setValue(perfManager.elapsedTicks());
        this.startedThreads.setValue(this.threadMXBean.getTotalStartedThreadCount());
        this.liveThreads.setValue(this.threadMXBean.getThreadCount());
        this.peakThreads.setValue(this.threadMXBean.getPeakThreadCount());
        this.daemonThreads.setValue(this.threadMXBean.getDaemonThreadCount());
        this.processCPUTimeCounter.setValue(this.getProcessCpuTime());
    }

    private static int numberOfLoadedClasses() {
        return Heap.getHeap().getClassCount();
    }

    private long getProcessCpuTime() {
        return this.osMXBean.getProcessCpuTime();
    }

    private static long getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static String getJavaCommand() {
        JavaMainWrapper.JavaMainSupport support = (JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class);
        return support.getJavaCommand();
    }

    private static String getVmArgs() {
        JavaMainWrapper.JavaMainSupport support = (JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class);
        StringBuilder vmArgs = new StringBuilder();
        for (String arg : support.getInputArguments()) {
            vmArgs.append(arg).append(' ');
        }
        return vmArgs.toString().trim();
    }
}

