/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

@AutomaticallyRegisteredImageSingleton(value={UniqueShortNameProvider.class}, onlyWith={UseDefault.class})
public class UniqueShortNameProviderDefaultImpl
implements UniqueShortNameProvider {
    @Override
    public String uniqueShortName(ClassLoader loader, ResolvedJavaType declaringClass, String methodName, Signature methodSignature, boolean isConstructor) {
        String loaderName = SubstrateUtil.classLoaderNameAndId(loader);
        StringBuilder sb = new StringBuilder(loaderName);
        sb.append(declaringClass.toClassName()).append(".").append(methodName).append("(");
        for (int i = 0; i < methodSignature.getParameterCount(false); ++i) {
            sb.append(methodSignature.getParameterType(i, null).toClassName()).append(",");
        }
        sb.append(')');
        if (!isConstructor) {
            sb.append(methodSignature.getReturnType(null).toClassName());
        }
        return SubstrateUtil.stripPackage(declaringClass.toJavaName()) + "_" + (isConstructor ? "constructor" : methodName) + "_" + SubstrateUtil.digest(sb.toString());
    }

    @Override
    public String uniqueShortName(Member m) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(m.getDeclaringClass().getName()).append(".");
        if (m instanceof Constructor) {
            fullName.append("<init>");
        } else {
            fullName.append(m.getName());
        }
        if (m instanceof Executable) {
            fullName.append("(");
            for (Class<?> c : ((Executable)m).getParameterTypes()) {
                fullName.append(c.getName()).append(",");
            }
            fullName.append(')');
            if (m instanceof Method) {
                fullName.append(((Method)m).getReturnType().getName());
            }
        }
        return SubstrateUtil.stripPackage(m.getDeclaringClass().getTypeName()) + "_" + (m instanceof Constructor ? "constructor" : m.getName()) + "_" + SubstrateUtil.digest(fullName.toString());
    }

    @Override
    public String uniqueShortLoaderName(ClassLoader classLoader) {
        return SubstrateUtil.classLoaderNameAndId(classLoader);
    }

    public static class UseDefault
    implements BooleanSupplier {
        public static boolean useDefaultProvider() {
            return !OS.LINUX.isCurrent() || SubstrateOptions.GenerateDebugInfo.getValue() <= 0;
        }

        @Override
        public boolean getAsBoolean() {
            return UseDefault.useDefaultProvider();
        }
    }
}

