/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CInterfaceReadNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.VaListNextArgNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.code.EntryPointCallStubMethod;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.jni.JNIJavaCallWrappers;
import com.oracle.svm.jni.hosted.JNIGraphKit;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIValue;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

public class JNIJavaCallWrapperMethod
extends EntryPointCallStubMethod {
    private final NativeLibraries nativeLibs;
    private final Executable reflectMethod;
    private final CallVariant callVariant;
    private final boolean nonVirtual;
    private static final Constructor<InstantiationException> INSTANTIATION_EXCEPTION_CONSTRUCTOR = ReflectionUtil.lookupConstructor(InstantiationException.class, (Class[])new Class[0]);

    protected JNIJavaCallWrapperMethod(Executable reflectMethod, CallVariant callVariant, boolean nonVirtual, MetaAccessProvider metaAccess, NativeLibraries nativeLibs) {
        super(JNIJavaCallWrapperMethod.createName(reflectMethod, callVariant, nonVirtual), metaAccess.lookupJavaType(JNIJavaCallWrappers.class), JNIJavaCallWrapperMethod.createSignature(reflectMethod, callVariant, nonVirtual, metaAccess), JNIJavaCallWrappers.getConstantPool(metaAccess));
        assert (!nonVirtual || !Modifier.isStatic(reflectMethod.getModifiers()));
        this.reflectMethod = reflectMethod;
        this.nativeLibs = nativeLibs;
        this.callVariant = callVariant;
        this.nonVirtual = nonVirtual;
    }

    private static String createName(Executable reflectMethod, CallVariant callVariant, boolean nonVirtual) {
        return "jniInvoke_" + callVariant.name() + (nonVirtual ? "_Nonvirtual" : "") + "_" + SubstrateUtil.uniqueShortName(reflectMethod);
    }

    private static SimpleSignature createSignature(Executable reflectMethod, CallVariant callVariant, boolean nonVirtual, MetaAccessProvider metaAccess) {
        ResolvedJavaType objectHandle = metaAccess.lookupJavaType(JNIObjectHandle.class);
        ArrayList<JavaType> args = new ArrayList<JavaType>();
        args.add((JavaType)metaAccess.lookupJavaType(JNIEnvironment.class));
        args.add((JavaType)objectHandle);
        if (nonVirtual) {
            args.add((JavaType)objectHandle);
        }
        args.add((JavaType)metaAccess.lookupJavaType(JNIMethodId.class));
        ResolvedJavaMethod targetMethod = metaAccess.lookupJavaMethod(reflectMethod);
        Signature targetSignature = targetMethod.getSignature();
        if (callVariant == CallVariant.VARARGS) {
            for (JavaType targetArg : targetSignature.toParameterTypes(null)) {
                JavaKind kind = targetArg.getJavaKind();
                if (kind.isObject()) {
                    args.add((JavaType)objectHandle);
                    continue;
                }
                if (kind == JavaKind.Float) {
                    args.add((JavaType)metaAccess.lookupJavaType(JavaKind.Double.toJavaClass()));
                    continue;
                }
                args.add((JavaType)metaAccess.lookupJavaType(kind.getStackKind().toJavaClass()));
            }
        } else if (callVariant == CallVariant.ARRAY) {
            args.add((JavaType)metaAccess.lookupJavaType(JNIValue.class));
        } else if (callVariant == CallVariant.VA_LIST) {
            args.add((JavaType)metaAccess.lookupJavaType(WordBase.class));
        } else {
            throw VMError.shouldNotReachHere();
        }
        JavaType returnType = targetSignature.getReturnType(null);
        if (returnType.getJavaKind().isObject() || targetMethod.isConstructor()) {
            returnType = objectHandle;
        }
        return new SimpleSignature(args, returnType);
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        JavaKind returnKind;
        ValueNode returnValue;
        CallTargetNode.InvokeKind invokeKind;
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method);
        FrameStateBuilder state = new FrameStateBuilder(null, method, kit.getGraph());
        state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
        JavaKind vmThreadKind = metaAccess.lookupJavaType(JNIEnvironment.class).getJavaKind();
        ValueNode vmThread = kit.loadLocal(0, vmThreadKind);
        kit.append((ValueNode)CEntryPointEnterNode.enter(vmThread));
        ResolvedJavaMethod invokeMethod = providers.getMetaAccess().lookupJavaMethod(this.reflectMethod);
        Signature invokeSignature = invokeMethod.getSignature();
        List<Pair<ValueNode, ResolvedJavaType>> argsWithTypes = this.loadAndUnboxArguments(kit, providers, invokeSignature);
        InvokeWithExceptionNode unboxedReceiver = null;
        if (invokeMethod.hasReceiver()) {
            int javaIndex = metaAccess.lookupJavaType(JNIEnvironment.class).getJavaKind().getSlotCount();
            JavaKind handleKind = metaAccess.lookupJavaType(JNIObjectHandle.class).getJavaKind();
            ValueNode handle = kit.loadLocal(javaIndex, handleKind);
            unboxedReceiver = kit.unboxHandle(handle);
        }
        ArrayList<EndNode> illegalTypeEnds = new ArrayList<EndNode>();
        int argIndex = invokeMethod.hasReceiver() ? 1 : 0;
        ValueNode[] args = new ValueNode[argIndex + argsWithTypes.size()];
        for (Pair<ValueNode, ResolvedJavaType> argsWithType : argsWithTypes) {
            ValueNode value = (ValueNode)argsWithType.getLeft();
            ResolvedJavaType type = (ResolvedJavaType)argsWithType.getRight();
            if (!type.isPrimitive() && !type.isJavaLangObject()) {
                value = JNIJavaCallWrapperMethod.typeChecked(kit, value, type, illegalTypeEnds, false);
            }
            args[argIndex++] = value;
        }
        CallTargetNode.InvokeKind invokeKind2 = invokeMethod.isStatic() ? CallTargetNode.InvokeKind.Static : (invokeKind = this.nonVirtual || invokeMethod.isConstructor() ? CallTargetNode.InvokeKind.Special : CallTargetNode.InvokeKind.Virtual);
        if (!invokeMethod.hasReceiver()) {
            returnValue = this.createMethodCall(kit, invokeMethod, invokeKind, state, args);
        } else if (invokeMethod.isConstructor()) {
            ResolvedJavaType receiverClass = invokeMethod.getDeclaringClass();
            Constant hub = providers.getConstantReflection().asObjectHub(receiverClass);
            ConstantNode hubNode = kit.createConstant(hub, JavaKind.Object);
            ObjectEqualsNode isNewObjectCall = (ObjectEqualsNode)kit.unique((FloatingNode)new ObjectEqualsNode((ValueNode)unboxedReceiver, (ValueNode)hubNode));
            kit.startIf((LogicNode)isNewObjectCall, BranchProbabilityNode.FAST_PATH_PROFILE);
            kit.thenPart();
            ValueNode createdObjectOrNull = invokeMethod.getDeclaringClass().isAbstract() ? JNIJavaCallWrapperMethod.throwInstantiationException(metaAccess, kit, state) : JNIJavaCallWrapperMethod.createNewObjectCall(metaAccess, kit, invokeMethod, state, args);
            kit.elsePart();
            args[0] = JNIJavaCallWrapperMethod.typeChecked(kit, (ValueNode)unboxedReceiver, invokeMethod.getDeclaringClass(), illegalTypeEnds, true);
            ValueNode unboxedReceiverOrNull = this.createMethodCall(kit, invokeMethod, invokeKind, state, args);
            AbstractMergeNode merge = kit.endIf();
            merge.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)merge));
            returnValue = kit.unique((FloatingNode)new ValuePhiNode(StampFactory.object(), merge, new ValueNode[]{createdObjectOrNull, unboxedReceiverOrNull}));
        } else {
            args[0] = JNIJavaCallWrapperMethod.typeChecked(kit, (ValueNode)unboxedReceiver, invokeMethod.getDeclaringClass(), illegalTypeEnds, true);
            returnValue = this.createMethodCall(kit, invokeMethod, invokeKind, state, args);
        }
        JavaKind javaKind = returnKind = returnValue != null ? returnValue.getStackKind() : JavaKind.Void;
        if (!illegalTypeEnds.isEmpty()) {
            BytecodeExceptionNode exception;
            BeginNode afterSuccess = (BeginNode)kit.append((ValueNode)new BeginNode());
            if (illegalTypeEnds.size() == 1) {
                BeginNode illegalTypeBegin = (BeginNode)kit.append((ValueNode)new BeginNode());
                illegalTypeBegin.replaceAtPredecessor(null);
                EndNode end = (EndNode)illegalTypeEnds.get(0);
                exception = (BytecodeExceptionNode)end.predecessor();
                end.replaceAtPredecessor((Node)illegalTypeBegin);
                end.safeDelete();
            } else {
                MergeNode illegalTypesMerge = (MergeNode)kit.append((ValueNode)new MergeNode());
                ValuePhiNode phi = (ValuePhiNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(StampFactory.object(), (AbstractMergeNode)illegalTypesMerge));
                for (EndNode end : illegalTypeEnds) {
                    illegalTypesMerge.addForwardEnd(end);
                    phi.addInput((ValueNode)((BytecodeExceptionNode)end.predecessor()));
                }
                illegalTypesMerge.setStateAfter(state.create(kit.bci(), (StateSplit)illegalTypesMerge));
                phi.inferStamp();
                exception = phi;
            }
            kit.setPendingException((ValueNode)exception);
            BeginNode afterIllegalType = (BeginNode)kit.append((ValueNode)new BeginNode());
            MergeNode returnMerge = (MergeNode)kit.append((ValueNode)new MergeNode());
            EndNode afterSuccessEnd = (EndNode)kit.add((ValueNode)new EndNode());
            afterSuccess.setNext((FixedNode)afterSuccessEnd);
            returnMerge.addForwardEnd(afterSuccessEnd);
            EndNode afterIllegalTypeEnd = (EndNode)kit.add((ValueNode)new EndNode());
            afterIllegalType.setNext((FixedNode)afterIllegalTypeEnd);
            returnMerge.addForwardEnd(afterIllegalTypeEnd);
            if (returnValue != null) {
                FloatingNode typeMismatchResult = kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)returnValue.getStackKind()));
                ValueNode[] inputs = new ValueNode[]{returnValue, typeMismatchResult};
                returnValue = (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(returnValue.stamp(NodeView.DEFAULT), (AbstractMergeNode)returnMerge, inputs));
                state.push(returnKind, returnValue);
                returnMerge.setStateAfter(state.create(kit.bci(), (StateSplit)returnMerge));
                state.pop(returnKind);
            } else {
                returnMerge.setStateAfter(state.create(kit.bci(), (StateSplit)returnMerge));
            }
            kit.appendStateSplitProxy(state);
        }
        if (returnKind.isObject()) {
            returnValue = kit.boxObjectInLocalHandle(returnValue);
        }
        CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave);
        kit.append((ValueNode)leave);
        kit.createReturn(returnValue, returnKind);
        return kit.finalizeGraph();
    }

    private static ValueNode createNewObjectCall(UniverseMetaAccess metaAccess, JNIGraphKit kit, ResolvedJavaMethod constructor, FrameStateBuilder state, ValueNode ... argsWithReceiver) {
        assert (constructor.isConstructor()) : "Cannot create a NewObject call to the non-constructor method " + constructor;
        ResolvedJavaMethod factoryMethod = FactoryMethodSupport.singleton().lookup(metaAccess, constructor, false);
        int bci = kit.bci();
        ValueNode[] argsWithoutReceiver = Arrays.copyOfRange(argsWithReceiver, 1, argsWithReceiver.length);
        InvokeWithExceptionNode createdObject = JNIJavaCallWrapperMethod.startInvokeWithRetainedException(kit, factoryMethod, CallTargetNode.InvokeKind.Static, state, bci, argsWithoutReceiver);
        AbstractMergeNode merge = kit.endInvokeWithException();
        merge.setStateAfter(state.create(bci, (StateSplit)merge));
        Stamp objectStamp = StampFactory.forDeclaredType(null, (JavaType)constructor.getDeclaringClass(), (boolean)true).getTrustedStamp();
        FloatingNode exceptionValue = kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
        return (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(objectStamp, merge, new ValueNode[]{createdObject, exceptionValue}));
    }

    private static ValueNode throwInstantiationException(UniverseMetaAccess metaAccess, JNIGraphKit kit, FrameStateBuilder state) {
        ResolvedJavaMethod throwMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod(INSTANTIATION_EXCEPTION_CONSTRUCTOR), true);
        int bci = kit.bci();
        kit.startInvokeWithException(throwMethod, CallTargetNode.InvokeKind.Static, state, bci, new ValueNode[0]);
        kit.noExceptionPart();
        kit.append((ValueNode)new LoweredDeadEndNode());
        kit.exceptionPart();
        kit.setPendingException((ValueNode)kit.exceptionObject());
        kit.endInvokeWithException();
        return kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
    }

    protected ValueNode createMethodCall(JNIGraphKit kit, ResolvedJavaMethod invokeMethod, CallTargetNode.InvokeKind invokeKind, FrameStateBuilder state, ValueNode ... args) {
        int bci = kit.bci();
        InvokeWithExceptionNode invoke = JNIJavaCallWrapperMethod.startInvokeWithRetainedException(kit, invokeMethod, invokeKind, state, bci, args);
        AbstractMergeNode invokeMerge = kit.endInvokeWithException();
        if (invoke.getStackKind() == JavaKind.Void && !invokeMethod.isConstructor()) {
            invokeMerge.setStateAfter(state.create(bci, (StateSplit)invokeMerge));
            return null;
        }
        InvokeWithExceptionNode successValue = invokeMethod.isConstructor() ? args[0] : invoke;
        FloatingNode exceptionValue = kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)successValue.getStackKind()));
        ValueNode[] inputs = new ValueNode[]{successValue, exceptionValue};
        ValueNode returnValue = (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(successValue.stamp(NodeView.DEFAULT), invokeMerge, inputs));
        JavaKind returnKind = returnValue.getStackKind();
        state.push(returnKind, returnValue);
        invokeMerge.setStateAfter(state.create(bci, (StateSplit)invokeMerge));
        state.pop(returnKind);
        return returnValue;
    }

    protected static InvokeWithExceptionNode startInvokeWithRetainedException(JNIGraphKit kit, ResolvedJavaMethod invokeMethod, CallTargetNode.InvokeKind kind, FrameStateBuilder state, int bci, ValueNode ... args) {
        InvokeWithExceptionNode formerPendingException = kit.getAndClearPendingException();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(invokeMethod, kind, state, bci, args);
        kit.noExceptionPart();
        kit.setPendingException((ValueNode)formerPendingException);
        kit.exceptionPart();
        ExceptionObjectNode exceptionObject = kit.exceptionObject();
        kit.setPendingException((ValueNode)exceptionObject);
        return invoke;
    }

    private static PiNode typeChecked(JNIGraphKit kit, ValueNode uncheckedValue, ResolvedJavaType type, List<EndNode> illegalTypeEnds, boolean isReceiver) {
        ValueNode value = uncheckedValue;
        if (isReceiver && !StampTool.isPointerNonNull((ValueNode)value)) {
            IfNode ifNode = kit.startIf((LogicNode)kit.unique((FloatingNode)IsNullNode.create((ValueNode)value)), BranchProbabilityNode.SLOW_PATH_PROFILE);
            kit.thenPart();
            kit.append((ValueNode)kit.createBytecodeExceptionObjectNode(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, false, new ValueNode[0]));
            illegalTypeEnds.add((EndNode)kit.append((ValueNode)new EndNode()));
            kit.endIf();
            Stamp nonNullStamp = value.stamp(NodeView.DEFAULT).improveWith(StampFactory.objectNonNull());
            value = kit.append((ValueNode)new PiNode(value, nonNullStamp, (ValueNode)ifNode.falseSuccessor()));
        }
        TypeReference typeRef = TypeReference.createTrusted((Assumptions)kit.getAssumptions(), (ResolvedJavaType)type);
        LogicNode instanceOf = (LogicNode)kit.append((ValueNode)InstanceOfNode.createAllowNull((TypeReference)typeRef, (ValueNode)value, null, null));
        IfNode ifNode = kit.startIf(instanceOf, BranchProbabilityNode.FAST_PATH_PROFILE);
        kit.elsePart();
        ConstantNode typeNode = kit.createConstant((Constant)kit.getConstantReflection().asJavaClass(type), JavaKind.Object);
        kit.createBytecodeExceptionObjectNode(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, false, new ValueNode[]{value, typeNode});
        illegalTypeEnds.add((EndNode)kit.append((ValueNode)new EndNode()));
        kit.endIf();
        Stamp checkedStamp = value.stamp(NodeView.DEFAULT).improveWith((Stamp)StampFactory.objectNonNull((TypeReference)typeRef));
        return (PiNode)kit.unique((FloatingNode)new PiNode(value, checkedStamp, (ValueNode)ifNode.trueSuccessor()));
    }

    private List<Pair<ValueNode, ResolvedJavaType>> loadAndUnboxArguments(JNIGraphKit kit, HostedProviders providers, Signature invokeSignature) {
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        ArrayList<Pair<ValueNode, ResolvedJavaType>> args = new ArrayList<Pair<ValueNode, ResolvedJavaType>>();
        int javaIndex = this.argumentsJavaIndex(metaAccess);
        int count = invokeSignature.getParameterCount(false);
        if (Platform.includedIn(Platform.DARWIN_AARCH64.class) && (this.callVariant == CallVariant.VARARGS || this.callVariant == CallVariant.VA_LIST) || Platform.includedIn(Platform.WINDOWS.class) && this.callVariant == CallVariant.VA_LIST || this.callVariant == CallVariant.ARRAY) {
            ResolvedJavaType elementType = metaAccess.lookupJavaType(JNIValue.class);
            int elementSize = SizeOf.get(JNIValue.class);
            ValueNode array = this.callVariant == CallVariant.VARARGS ? kit.append((ValueNode)new ReadCallerStackPointerNode()) : kit.loadLocal(javaIndex, elementType.getJavaKind());
            for (int i = 0; i < count; ++i) {
                JavaKind readKind;
                ResolvedJavaType type = (ResolvedJavaType)invokeSignature.getParameterType(i, null);
                JavaKind kind = type.getJavaKind();
                JavaKind javaKind = readKind = this.callVariant == CallVariant.ARRAY ? kind : kind.getStackKind();
                if (readKind == JavaKind.Float && (this.callVariant == CallVariant.VARARGS || this.callVariant == CallVariant.VA_LIST)) {
                    readKind = JavaKind.Double;
                }
                StructFieldInfo fieldInfo = this.getJNIValueOffsetOf(elementType, readKind);
                int offset = i * elementSize + fieldInfo.getOffsetInfo().getProperty();
                JavaKind wordKind = providers.getWordTypes().getWordKind();
                ConstantNode offsetConstant = kit.createConstant((Constant)JavaConstant.forIntegerKind((JavaKind)wordKind, (long)offset), wordKind);
                OffsetAddressNode address = (OffsetAddressNode)kit.unique((FloatingNode)new OffsetAddressNode(array, (ValueNode)offsetConstant));
                LocationIdentity locationIdentity = fieldInfo.getLocationIdentity();
                if (locationIdentity == null) {
                    locationIdentity = LocationIdentity.any();
                }
                Stamp readStamp = JNIJavaCallWrapperMethod.getNarrowStamp(providers, readKind);
                ValueNode value = kit.append((ValueNode)new CInterfaceReadNode((AddressNode)address, locationIdentity, readStamp, OnHeapMemoryAccess.BarrierType.NONE, "args[" + i + "]"));
                if (kind == JavaKind.Float && (this.callVariant == CallVariant.VARARGS || this.callVariant == CallVariant.VA_LIST)) {
                    value = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.D2F, value));
                } else if (kind.isObject()) {
                    value = kit.unboxHandle(value);
                } else if (kind == JavaKind.Boolean) {
                    value = JNIJavaCallWrapperMethod.convertToBoolean(kit, value);
                } else if (kind != kind.getStackKind() && this.callVariant == CallVariant.ARRAY) {
                    value = JNIJavaCallWrapperMethod.maskSubWordValue(kit, value, kind);
                }
                args.add((Pair<ValueNode, ResolvedJavaType>)Pair.create((Object)value, (Object)type));
            }
        } else if (this.callVariant == CallVariant.VARARGS) {
            for (int i = 0; i < count; ++i) {
                ResolvedJavaType type = (ResolvedJavaType)invokeSignature.getParameterType(i, null);
                JavaKind kind = type.getJavaKind();
                JavaKind loadKind = kind;
                if (loadKind == JavaKind.Float) {
                    loadKind = JavaKind.Double;
                }
                ValueNode value = kit.loadLocal(javaIndex, loadKind);
                if (kind == JavaKind.Float) {
                    value = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.D2F, value));
                } else if (kind.isObject()) {
                    value = kit.unboxHandle(value);
                } else if (kind == JavaKind.Boolean) {
                    value = JNIJavaCallWrapperMethod.convertToBoolean(kit, value);
                }
                args.add((Pair<ValueNode, ResolvedJavaType>)Pair.create((Object)value, (Object)type));
                javaIndex += loadKind.getSlotCount();
            }
        } else if (this.callVariant == CallVariant.VA_LIST) {
            ValueNode valist = kit.loadLocal(javaIndex, metaAccess.lookupJavaType(WordBase.class).getJavaKind());
            for (int i = 0; i < count; ++i) {
                ResolvedJavaType type = (ResolvedJavaType)invokeSignature.getParameterType(i, null);
                JavaKind kind = type.getJavaKind();
                JavaKind loadKind = kind.getStackKind();
                if (loadKind.isObject()) {
                    loadKind = providers.getWordTypes().getWordKind();
                }
                ValueNode value = kit.append((ValueNode)new VaListNextArgNode(loadKind, valist));
                if (kind.isObject()) {
                    value = kit.unboxHandle(value);
                } else if (kind == JavaKind.Boolean) {
                    value = JNIJavaCallWrapperMethod.convertToBoolean(kit, value);
                }
                args.add((Pair<ValueNode, ResolvedJavaType>)Pair.create((Object)value, (Object)type));
            }
        } else {
            throw VMError.unsupportedFeature("Call variant: " + this.callVariant);
        }
        return args;
    }

    private int argumentsJavaIndex(MetaAccessProvider metaAccess) {
        return metaAccess.lookupJavaType(JNIEnvironment.class).getJavaKind().getSlotCount() + metaAccess.lookupJavaType(JNIObjectHandle.class).getJavaKind().getSlotCount() + (this.nonVirtual ? metaAccess.lookupJavaType(JNIObjectHandle.class).getJavaKind().getSlotCount() : 0) + metaAccess.lookupJavaType(JNIMethodId.class).getJavaKind().getSlotCount();
    }

    private static ValueNode convertToBoolean(JNIGraphKit kit, ValueNode value) {
        ValueNode maskedValue = JNIJavaCallWrapperMethod.maskSubWordValue(kit, value, JavaKind.Boolean);
        LogicNode isZero = IntegerEqualsNode.create((ValueNode)maskedValue, (ValueNode)ConstantNode.forInt((int)0), (NodeView)NodeView.DEFAULT);
        return kit.append(ConditionalNode.create((LogicNode)isZero, (ValueNode)ConstantNode.forBoolean((boolean)false), (ValueNode)ConstantNode.forBoolean((boolean)true), (NodeView)NodeView.DEFAULT));
    }

    private static ValueNode maskSubWordValue(JNIGraphKit kit, ValueNode value, JavaKind kind) {
        assert (kind != kind.getStackKind());
        ValueNode narrow = kit.append(NarrowNode.create((ValueNode)value, (int)(kind.getByteCount() * 8), (NodeView)NodeView.DEFAULT));
        if (kind.isUnsigned()) {
            return kit.append(ZeroExtendNode.create((ValueNode)narrow, (int)32, (NodeView)NodeView.DEFAULT));
        }
        return kit.append(SignExtendNode.create((ValueNode)narrow, (int)32, (NodeView)NodeView.DEFAULT));
    }

    private static Stamp getNarrowStamp(HostedProviders providers, JavaKind kind) {
        if (kind != kind.getStackKind()) {
            return StampFactory.forInteger((int)(kind.getByteCount() * 8));
        }
        if (kind.isObject()) {
            ResolvedJavaType objectHandle = providers.getMetaAccess().lookupJavaType(JNIObjectHandle.class);
            return providers.getWordTypes().getWordStamp(objectHandle);
        }
        return StampFactory.forKind((JavaKind)kind);
    }

    private StructFieldInfo getJNIValueOffsetOf(ResolvedJavaType jniValueType, JavaKind kind) {
        String name = String.valueOf(kind.isObject() ? (char)'l' : Character.toLowerCase(kind.getTypeChar()));
        StructInfo structInfo = (StructInfo)this.nativeLibs.findElementInfo((AnnotatedElement)jniValueType);
        for (ElementInfo elementInfo : structInfo.getChildren()) {
            StructFieldInfo fieldInfo;
            if (!(elementInfo instanceof StructFieldInfo) || !name.equals((fieldInfo = (StructFieldInfo)elementInfo).getName())) continue;
            return fieldInfo;
        }
        throw VMError.shouldNotReachHere();
    }

    public static enum CallVariant {
        VARARGS,
        ARRAY,
        VA_LIST;

    }

    public static class Factory {
        public JNIJavaCallWrapperMethod create(Executable reflectMethod, CallVariant callVariant, boolean nonVirtual, MetaAccessProvider metaAccess, NativeLibraries nativeLibs) {
            return new JNIJavaCallWrapperMethod(reflectMethod, callVariant, nonVirtual, metaAccess, nativeLibs);
        }
    }
}

