/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.substitute.ComputedValue;
import com.oracle.svm.util.AnnotationWrapper;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public class ComputedValueField
implements ReadableJavaField,
OriginalFieldProvider,
ComputedValue,
AnnotationWrapper {
    private static final EnumSet<RecomputeFieldValue.Kind> offsetComputationKinds = EnumSet.of(RecomputeFieldValue.Kind.FieldOffset, RecomputeFieldValue.Kind.TranslateFieldOffset, RecomputeFieldValue.Kind.AtomicFieldUpdaterOffset);
    private final ResolvedJavaField original;
    private final ResolvedJavaField annotated;
    private final RecomputeFieldValue.Kind kind;
    private final Class<?> targetClass;
    private final Field targetField;
    private final RecomputeFieldValue.CustomFieldValueProvider customValueProvider;
    private final boolean isFinal;
    private final boolean disableCaching;
    private final boolean isValueAvailableBeforeAnalysis;
    private final boolean isValueAvailableOnlyAfterAnalysis;
    private final boolean isValueAvailableOnlyAfterCompilation;
    private final Class<?>[] customTypes;
    private final boolean computedValueCanBeNull;
    private JavaConstant constantValue;
    private final EconomicMap<JavaConstant, JavaConstant> valueCache;
    private JavaConstant valueCacheNullKey;
    private final ReentrantReadWriteLock valueCacheLock = new ReentrantReadWriteLock();

    public ComputedValueField(ResolvedJavaField original, ResolvedJavaField annotated, RecomputeFieldValue.Kind kind, Class<?> targetClass, String targetName, boolean isFinal) {
        this(original, annotated, kind, targetClass, targetName, isFinal, false);
    }

    public ComputedValueField(ResolvedJavaField original, ResolvedJavaField annotated, RecomputeFieldValue.Kind kind, Class<?> targetClass, String targetName, boolean isFinal, boolean disableCaching) {
        assert (original != null);
        assert (targetClass != null);
        this.original = original;
        this.annotated = annotated;
        this.kind = kind;
        this.targetClass = targetClass;
        this.isFinal = isFinal;
        this.disableCaching = disableCaching;
        boolean customValueAvailableBeforeAnalysis = true;
        boolean customValueAvailableOnlyAfterAnalysis = false;
        boolean customValueAvailableOnlyAfterCompilation = false;
        boolean canBeNull = false;
        Class[] customProviderTypes = null;
        RecomputeFieldValue.CustomFieldValueProvider customProvider = null;
        Field f = null;
        switch (kind) {
            case Reset: {
                this.constantValue = JavaConstant.defaultForKind((JavaKind)this.getJavaKind());
                break;
            }
            case FieldOffset: {
                try {
                    f = targetClass.getDeclaredField(targetName);
                    break;
                }
                catch (NoSuchFieldException e) {
                    throw VMError.shouldNotReachHere("could not find target field " + targetClass.getName() + "." + targetName + " for alias " + annotated.format("%H.%n"));
                }
            }
            case Custom: {
                try {
                    Constructor<?>[] constructors = targetClass.getDeclaredConstructors();
                    if (constructors.length != 1) {
                        throw UserError.abort("The custom field value computer class %s has more than one constructor", targetClass.getName());
                    }
                    Constructor<?> constructor = constructors[0];
                    Object[] constructorArgs = new Object[constructor.getParameterCount()];
                    for (int i = 0; i < constructorArgs.length; ++i) {
                        constructorArgs[i] = ComputedValueField.configurationValue(constructor.getParameterTypes()[i]);
                    }
                    constructor.setAccessible(true);
                    customProvider = (RecomputeFieldValue.CustomFieldValueProvider)constructor.newInstance(constructorArgs);
                    RecomputeFieldValue.ValueAvailability valueAvailability = customProvider.valueAvailability();
                    customValueAvailableBeforeAnalysis = valueAvailability == RecomputeFieldValue.ValueAvailability.BeforeAnalysis;
                    customValueAvailableOnlyAfterAnalysis = valueAvailability == RecomputeFieldValue.ValueAvailability.AfterAnalysis;
                    customValueAvailableOnlyAfterCompilation = valueAvailability == RecomputeFieldValue.ValueAvailability.AfterCompilation;
                    Class<?>[] types = customProvider.types();
                    if (types == null) break;
                    ArrayList nonNullTypes = new ArrayList();
                    for (Class<?> clazz : types) {
                        if (clazz == null) {
                            canBeNull = true;
                            continue;
                        }
                        nonNullTypes.add(clazz);
                    }
                    customProviderTypes = nonNullTypes.toArray(new Class[0]);
                    break;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                    throw VMError.shouldNotReachHere("Error creating custom field value computer for alias " + annotated.format("%H.%n"), ex);
                }
            }
        }
        boolean isOffsetField = ComputedValueField.isOffsetRecomputation(kind);
        VMError.guarantee(!isFinal || !isOffsetField);
        this.isValueAvailableBeforeAnalysis = customValueAvailableBeforeAnalysis && !isOffsetField;
        this.isValueAvailableOnlyAfterAnalysis = customValueAvailableOnlyAfterAnalysis || isOffsetField;
        this.isValueAvailableOnlyAfterCompilation = customValueAvailableOnlyAfterCompilation;
        this.customTypes = customProviderTypes;
        this.computedValueCanBeNull = canBeNull;
        this.targetField = f;
        this.customValueProvider = customProvider;
        this.valueCache = EconomicMap.create();
    }

    public static boolean isOffsetRecomputation(RecomputeFieldValue.Kind kind) {
        return offsetComputationKinds.contains((Object)kind);
    }

    @Override
    public boolean isValueAvailableBeforeAnalysis() {
        return this.isValueAvailableBeforeAnalysis;
    }

    @Override
    public boolean isValueAvailable() {
        return this.constantValue != null || this.isValueAvailableBeforeAnalysis() || this.isValueAvailableOnlyAfterAnalysis && BuildPhaseProvider.isAnalysisFinished() || this.isValueAvailableOnlyAfterCompilation && BuildPhaseProvider.isCompilationFinished();
    }

    public ResolvedJavaField getAnnotated() {
        return this.annotated;
    }

    public Class<?>[] getCustomTypes() {
        return this.customTypes;
    }

    public boolean getComputedValueCanBeNull() {
        return this.computedValueCanBeNull;
    }

    @Override
    public Field getTargetField() {
        return this.targetField;
    }

    @Override
    public RecomputeFieldValue.Kind getRecomputeValueKind() {
        return this.kind;
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaType getType() {
        return this.original.getType();
    }

    public int getModifiers() {
        int result = this.original.getModifiers();
        result = this.isFinal ? (result |= 0x10) : (result &= 0xFFFFFFEF);
        return result;
    }

    public int getOffset() {
        return this.original.getOffset();
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public void processAnalysis(AnalysisMetaAccess aMetaAccess) {
        switch (this.kind) {
            case FieldOffset: {
                AnalysisField target = aMetaAccess.lookupJavaField(this.targetField);
                target.registerAsAccessed();
            }
        }
    }

    private JavaConstant asConstant(int value) {
        switch (this.getJavaKind()) {
            case Int: {
                return JavaConstant.forInt((int)value);
            }
            case Long: {
                return JavaConstant.forLong((long)value);
            }
        }
        throw VMError.shouldNotReachHere();
    }

    public void processSubstrate(HostedMetaAccess metaAccess) {
        switch (this.kind) {
            case FieldOffset: {
                this.constantValue = this.asConstant(metaAccess.lookupJavaField(this.targetField).getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaConstant readValue(MetaAccessProvider metaAccess, JavaConstant receiver) {
        if (this.constantValue != null) {
            return this.constantValue;
        }
        switch (this.kind) {
            case None: 
            case Manual: {
                return ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver);
            }
            case FromAlias: {
                assert (Modifier.isStatic(this.annotated.getModifiers())) : "Cannot use " + this.kind + " on non-static alias " + this.annotated.format("%H.%n");
                this.annotated.getDeclaringClass().initialize();
                this.constantValue = ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.annotated, null);
                return this.constantValue;
            }
            case ArrayBaseOffset: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
            case ArrayIndexScale: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayIndexScale(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
            case ArrayIndexShift: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayIndexShift(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
        }
        ReentrantReadWriteLock.ReadLock readLock = this.valueCacheLock.readLock();
        try {
            readLock.lock();
            JavaConstant result = this.getCached(receiver);
            if (result != null) {
                JavaConstant javaConstant = result;
                return javaConstant;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.valueCacheLock.writeLock();
        try {
            writeLock.lock();
            JavaConstant result = this.getCached(receiver);
            if (result != null) {
                JavaConstant javaConstant = result;
                return javaConstant;
            }
            result = this.computeValue(metaAccess, receiver);
            this.putCached(receiver, result);
            JavaConstant javaConstant = result;
            return javaConstant;
        }
        finally {
            writeLock.unlock();
        }
    }

    private JavaConstant computeValue(MetaAccessProvider metaAccess, JavaConstant receiver) {
        JavaConstant result;
        assert (this.isValueAvailable()) : "Field " + this.format("%H.%n") + " value not available for reading.";
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        switch (this.kind) {
            case NewInstanceWhenNotNull: {
                Object originalValue = this.fetchOriginalValue(metaAccess, receiver, originalSnippetReflection);
                result = originalValue == null ? originalSnippetReflection.forObject(null) : this.createNewInstance(originalSnippetReflection);
                break;
            }
            case NewInstance: {
                result = this.createNewInstance(originalSnippetReflection);
                break;
            }
            case AtomicFieldUpdaterOffset: {
                result = this.computeAtomicFieldUpdaterOffset(metaAccess, receiver);
                break;
            }
            case TranslateFieldOffset: {
                result = this.translateFieldOffset(metaAccess, receiver, this.targetClass);
                break;
            }
            case Custom: {
                Object newValue;
                Object receiverValue;
                Object object = receiverValue = receiver == null ? null : originalSnippetReflection.asObject(Object.class, receiver);
                if (this.customValueProvider instanceof RecomputeFieldValue.CustomFieldValueComputer) {
                    newValue = ((RecomputeFieldValue.CustomFieldValueComputer)this.customValueProvider).compute(metaAccess, this.original, this.annotated, receiverValue);
                } else if (this.customValueProvider instanceof RecomputeFieldValue.CustomFieldValueTransformer) {
                    Object originalValue = this.fetchOriginalValue(metaAccess, receiver, originalSnippetReflection);
                    newValue = ((RecomputeFieldValue.CustomFieldValueTransformer)this.customValueProvider).transform(metaAccess, this.original, this.annotated, receiverValue, originalValue);
                } else {
                    throw UserError.abort("The custom field value computer class %s does not implement %s or %s", this.targetClass.getName(), RecomputeFieldValue.CustomFieldValueComputer.class.getSimpleName(), RecomputeFieldValue.CustomFieldValueTransformer.class.getSimpleName());
                }
                this.checkValue(newValue);
                result = originalSnippetReflection.forBoxed(this.annotated.getJavaKind(), newValue);
                assert (result.getJavaKind() == this.annotated.getJavaKind());
                break;
            }
            default: {
                throw VMError.shouldNotReachHere("Field recomputation of kind " + this.kind + " for " + this.fieldFormat() + " not yet supported");
            }
        }
        return result;
    }

    private void checkValue(Object newValue) {
        if (this.customTypes != null) {
            if (newValue == null) {
                if (!this.computedValueCanBeNull) {
                    throw VMError.shouldNotReachHere("Computed value for " + this.fieldFormat() + " should not be null.");
                }
            } else {
                boolean primitive = ((ResolvedJavaType)this.original.getType()).isPrimitive();
                Class<?> actualType = primitive ? ComputedValueField.toUnboxedClass(newValue.getClass()) : newValue.getClass();
                for (Class<?> customType : this.customTypes) {
                    if (!customType.isAssignableFrom(actualType)) continue;
                    return;
                }
                VMError.shouldNotReachHere("Unexpected class " + actualType + " for " + this.fieldFormat() + ". Expected types :" + Arrays.toString(this.customTypes) + ".");
            }
        }
    }

    private static Class<?> toUnboxedClass(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        return clazz;
    }

    private String fieldFormat() {
        return "field " + this.original.format("%H.%n") + (String)(this.annotated != null ? " specified by alias " + this.annotated.format("%H.%n") : "");
    }

    private JavaConstant createNewInstance(SnippetReflectionProvider originalSnippetReflection) {
        JavaConstant result;
        try {
            result = originalSnippetReflection.forObject(ReflectionUtil.newInstance(this.targetClass));
        }
        catch (ReflectionUtil.ReflectionUtilError ex) {
            throw VMError.shouldNotReachHere("Error performing field recomputation for alias " + this.annotated.format("%H.%n"), ex.getCause());
        }
        return result;
    }

    private Object fetchOriginalValue(MetaAccessProvider metaAccess, JavaConstant receiver, SnippetReflectionProvider originalSnippetReflection) {
        JavaConstant originalValueConstant = ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver);
        Object originalValue = originalValueConstant.getJavaKind().isPrimitive() ? originalValueConstant.asBoxedPrimitive() : originalSnippetReflection.asObject(Object.class, originalValueConstant);
        return originalValue;
    }

    private void putCached(JavaConstant receiver, JavaConstant result) {
        if (this.disableCaching) {
            return;
        }
        if (receiver == null) {
            this.valueCacheNullKey = result;
        } else {
            this.valueCache.put((Object)receiver, (Object)result);
        }
    }

    private JavaConstant getCached(JavaConstant receiver) {
        if (receiver == null) {
            return this.valueCacheNullKey;
        }
        return (JavaConstant)this.valueCache.get((Object)receiver);
    }

    @Override
    public boolean allowConstantFolding() {
        return this.getDeclaringClass().isInitialized() && this.isFinal;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        if (this.original.isFinal()) {
            return true;
        }
        return ReadableJavaField.injectFinalForRuntimeCompilation(this.original);
    }

    private static Object configurationValue(Class<?> clazz) {
        throw VMError.shouldNotReachHere("Parameter type not supported yet: " + clazz.getName());
    }

    private JavaConstant translateFieldOffset(MetaAccessProvider metaAccess, JavaConstant receiver, Class<?> tclass) {
        long searchOffset = ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver).asLong();
        for (Field f : tclass.getDeclaredFields()) {
            long fieldOffset;
            if (Modifier.isStatic(f.getModifiers()) || (fieldOffset = Unsafe.getUnsafe().objectFieldOffset(f)) != searchOffset) continue;
            HostedField sf = (HostedField)metaAccess.lookupJavaField(f);
            VMError.guarantee(sf.isAccessed() && sf.getLocation() > 0, "Field not marked as accessed: " + sf.format("%H.%n"));
            return JavaConstant.forLong((long)sf.getLocation());
        }
        throw VMError.shouldNotReachHere("unknown field offset class: " + tclass + ", offset = " + searchOffset);
    }

    private JavaConstant computeAtomicFieldUpdaterOffset(MetaAccessProvider metaAccess, JavaConstant receiver) {
        assert (!Modifier.isStatic(this.original.getModifiers()));
        assert (receiver.isNonNull());
        ResolvedJavaField tclassField = ComputedValueField.findField(this.original.getDeclaringClass(), "tclass");
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        Class tclass = (Class)originalSnippetReflection.asObject(Class.class, ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), tclassField, receiver));
        return this.translateFieldOffset(metaAccess, receiver, tclass);
    }

    private static ResolvedJavaField findField(ResolvedJavaType declaringClass, String name) {
        for (ResolvedJavaField field : declaringClass.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Field not found: " + declaringClass.toJavaName(true) + "." + name);
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public AnnotatedElement getAnnotationRoot() {
        return this.original;
    }

    public boolean isCompatible(ResolvedJavaField o) {
        if (this.equals(o)) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputedValueField that = (ComputedValueField)o;
        return this.isFinal == that.isFinal && this.disableCaching == that.disableCaching && this.original.equals(that.original) && this.kind == that.kind && Objects.equals(this.targetClass, that.targetClass) && Objects.equals(this.targetField, that.targetField) && Objects.equals(this.constantValue, that.constantValue);
    }

    public String toString() {
        return "RecomputeValueField<original " + this.original.toString() + ", kind " + this.kind + ">";
    }

    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaField)this.original);
    }
}

