/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.code.InstantReferenceAdjuster;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.code.HostedImageHeapConstantPatch;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.NativeImageHeapWriter;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.InternalRuntimeReflectionSupport;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class NativeImageCodeCache {
    protected final NativeImageHeap imageHeap;
    private final Map<HostedMethod, CompilationResult> compilations;
    private final List<Pair<HostedMethod, CompilationResult>> orderedCompilations;
    protected final Platform targetPlatform;
    private final DataSection dataSection;
    private final Map<Constant, String> constantReasons = new HashMap<Constant, String>();

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilationResultMap, NativeImageHeap imageHeap) {
        this(compilationResultMap, imageHeap, (Platform)ImageSingletons.lookup(Platform.class));
    }

    public void purge() {
        this.compilations.clear();
        this.orderedCompilations.clear();
    }

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap, Platform targetPlatform) {
        this.compilations = compilations;
        this.imageHeap = imageHeap;
        this.dataSection = new DataSection();
        this.targetPlatform = targetPlatform;
        this.orderedCompilations = this.computeCompilationOrder(compilations);
    }

    public abstract int getCodeCacheSize();

    public abstract int getCodeAreaSize();

    public Pair<HostedMethod, CompilationResult> getFirstCompilation() {
        return this.orderedCompilations.get(0);
    }

    public Pair<HostedMethod, CompilationResult> getLastCompilation() {
        return this.orderedCompilations.get(this.orderedCompilations.size() - 1);
    }

    protected List<Pair<HostedMethod, CompilationResult>> computeCompilationOrder(Map<HostedMethod, CompilationResult> compilationMap) {
        return compilationMap.entrySet().stream().map(e -> Pair.create((Object)((HostedMethod)e.getKey()), (Object)((CompilationResult)e.getValue()))).collect(Collectors.toList());
    }

    public List<Pair<HostedMethod, CompilationResult>> getOrderedCompilations() {
        return this.orderedCompilations;
    }

    public abstract int codeSizeFor(HostedMethod var1);

    protected CompilationResult compilationResultFor(HostedMethod method) {
        return this.compilations.get(method);
    }

    public abstract void layoutMethods(DebugContext var1, String var2, BigBang var3, ForkJoinPool var4);

    public void layoutConstants() {
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            SubstrateObjectConstant constant;
            CompilationResult compilation = (CompilationResult)pair.getRight();
            for (DataSection.Data data : compilation.getDataSection()) {
                if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
                constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
                this.constantReasons.put(constant, compilation.getName());
            }
            this.dataSection.addAll(compilation.getDataSection());
            for (DataPatch patch : compilation.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                constant = ((ConstantReference)patch.reference).getConstant();
                this.constantReasons.put(constant, compilation.getName());
            }
        }
        this.dataSection.close(HostedOptionValues.singleton());
    }

    public void addConstantsToHeap() {
        for (DataSection.Data data : this.dataSection) {
            if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
            SubstrateObjectConstant constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
            this.addConstantToHeap(constant, "data section");
        }
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            CompilationResult compilationResult = (CompilationResult)pair.getRight();
            for (DataPatch patch : compilationResult.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                this.addConstantToHeap((Constant)((ConstantReference)patch.reference).getConstant(), compilationResult.getName());
            }
            for (CompilationResult.CodeAnnotation codeAnnotation : compilationResult.getCodeAnnotations()) {
                if (!(codeAnnotation instanceof HostedImageHeapConstantPatch)) continue;
                this.addConstantToHeap(((HostedImageHeapConstantPatch)codeAnnotation).constant, compilationResult.getName());
            }
        }
    }

    private void addConstantToHeap(Constant constant, Object reason) {
        if (constant instanceof SubstrateMethodPointerConstant) {
            return;
        }
        Object obj = SubstrateObjectConstant.asObject(constant);
        if (!this.imageHeap.getMetaAccess().lookupJavaType((Class)obj.getClass()).getWrapped().isInstantiated()) {
            throw VMError.shouldNotReachHere("Non-instantiated type referenced by a compiled method: " + obj.getClass().getName() + "." + (String)(reason != null ? " Method: " + reason : ""));
        }
        this.imageHeap.addObject(obj, false, reason != null ? reason : this.constantReasons.get(constant));
    }

    protected int getConstantsSize() {
        return this.dataSection.getSectionSize();
    }

    public int getAlignedConstantsSize() {
        return ConfigurationValues.getObjectLayout().alignUp(this.getConstantsSize());
    }

    public void buildRuntimeMetadata(CFunctionPointer firstMethod, UnsignedWord codeSize) {
        String name;
        HostedType declaringType;
        HostedFrameInfoCustomization frameInfoCustomization = new HostedFrameInfoCustomization();
        CodeInfoEncoder.Encoders encoders = new CodeInfoEncoder.Encoders();
        CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(frameInfoCustomization, encoders);
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)pair.getLeft();
            CompilationResult compilation = (CompilationResult)pair.getRight();
            codeInfoEncoder.addMethod(method, compilation, method.getCodeAddressOffset(), this.codeSizeFor(method));
        }
        ReflectionMetadataEncoder reflectionMetadataEncoder = ((ReflectionMetadataEncoderFactory)ImageSingletons.lookup(ReflectionMetadataEncoderFactory.class)).create(encoders);
        InternalRuntimeReflectionSupport reflectionSupport = (InternalRuntimeReflectionSupport)ImageSingletons.lookup(InternalRuntimeReflectionSupport.class);
        HostedUniverse hUniverse = this.imageHeap.getUniverse();
        HostedMetaAccess hMetaAccess = this.imageHeap.getMetaAccess();
        Map<Class<?>, Set<Class<?>>> innerClasses = reflectionSupport.getReflectionInnerClasses();
        Set<?> heapDynamicHubs = reflectionSupport.getHeapDynamicHubs();
        for (HostedType type : hUniverse.getTypes()) {
            if (!type.getWrapped().isReachable() || !heapDynamicHubs.contains(type.getHub())) continue;
            Class[] typeInnerClasses = innerClasses.getOrDefault(type.getJavaClass(), Collections.emptySet()).toArray(new Class[0]);
            reflectionMetadataEncoder.addClassMetadata((MetaAccessProvider)hMetaAccess, type, typeInnerClasses);
        }
        HashSet<HostedField> includedFields = new HashSet<HostedField>();
        HashSet<HostedMethod> includedMethods = new HashSet<HostedMethod>();
        Set<Field> configurationFields = reflectionSupport.getReflectionFields();
        Set<Executable> configurationExecutables = reflectionSupport.getReflectionExecutables();
        for (AccessibleObject accessibleObject : reflectionSupport.getHeapReflectionObjects()) {
            HostedMethod hostedMethod;
            if (accessibleObject instanceof Field) {
                HostedField hostedField = hMetaAccess.lookupJavaField((Field)accessibleObject);
                if (includedFields.contains(hostedField)) continue;
                reflectionMetadataEncoder.addHeapAccessibleObjectMetadata((MetaAccessProvider)hMetaAccess, (WrappedElement)hostedField, accessibleObject, configurationFields.contains(accessibleObject));
                includedFields.add(hostedField);
                continue;
            }
            if (!(accessibleObject instanceof Executable) || includedMethods.contains(hostedMethod = hMetaAccess.lookupJavaMethod((Executable)accessibleObject))) continue;
            reflectionMetadataEncoder.addHeapAccessibleObjectMetadata((MetaAccessProvider)hMetaAccess, (WrappedElement)hostedMethod, accessibleObject, configurationExecutables.contains(accessibleObject));
            includedMethods.add(hostedMethod);
        }
        for (Field field : configurationFields) {
            HostedField field2 = hMetaAccess.lookupJavaField(field);
            if (includedFields.contains(field2)) continue;
            reflectionMetadataEncoder.addReflectionFieldMetadata((MetaAccessProvider)hMetaAccess, field2, field);
            includedFields.add(field2);
        }
        for (Executable executable : configurationExecutables) {
            HostedMethod method = hMetaAccess.lookupJavaMethod(executable);
            if (includedMethods.contains(method)) continue;
            Object accessor = reflectionSupport.getAccessor(executable);
            reflectionMetadataEncoder.addReflectionExecutableMetadata((MetaAccessProvider)hMetaAccess, method, executable, accessor);
            includedMethods.add(method);
        }
        for (AccessibleObject accessibleObject : reflectionSupport.getHidingReflectionFields()) {
            AnalysisField hidingField = (AnalysisField)accessibleObject;
            HostedField hostedField = hUniverse.optionalLookup((JavaField)hidingField);
            if (hostedField != null && includedFields.contains(hostedField)) continue;
            declaringType = hUniverse.lookup((JavaType)hidingField.getDeclaringClass());
            name = hidingField.getName();
            HostedType type = hUniverse.lookup((JavaType)hidingField.getType());
            int modifiers = hidingField.getModifiers();
            reflectionMetadataEncoder.addHidingFieldMetadata(hidingField, declaringType, name, type, modifiers);
            if (hostedField == null) continue;
            includedFields.add(hostedField);
        }
        for (AccessibleObject accessibleObject : reflectionSupport.getHidingReflectionMethods()) {
            AnalysisMethod hidingMethod = (AnalysisMethod)accessibleObject;
            HostedMethod hostedMethod = hUniverse.optionalLookup((JavaMethod)hidingMethod);
            if (hostedMethod != null && includedMethods.contains(hostedMethod)) continue;
            declaringType = hUniverse.lookup((JavaType)hidingMethod.getDeclaringClass());
            name = hidingMethod.getName();
            JavaType[] analysisParameterTypes = hidingMethod.getSignature().toParameterTypes(null);
            HostedType[] parameterTypes = new HostedType[analysisParameterTypes.length];
            for (int i = 0; i < analysisParameterTypes.length; ++i) {
                parameterTypes[i] = hUniverse.lookup(analysisParameterTypes[i]);
            }
            int modifiers = hidingMethod.getModifiers();
            HostedType returnType = hUniverse.lookup(hidingMethod.getSignature().getReturnType(null));
            reflectionMetadataEncoder.addHidingMethodMetadata(hidingMethod, declaringType, name, parameterTypes, modifiers, returnType);
            if (hostedMethod == null) continue;
            includedMethods.add(hostedMethod);
        }
        if (SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            for (HostedField hostedField : hUniverse.getFields()) {
                if (!hostedField.isAccessed() || includedFields.contains(hostedField)) continue;
                reflectionMetadataEncoder.addReachableFieldMetadata(hostedField);
            }
            for (HostedMethod hostedMethod : hUniverse.getMethods()) {
                if (!hostedMethod.getWrapped().isReachable() || hostedMethod.getWrapped().isIntrinsicMethod() || includedMethods.contains(hostedMethod)) continue;
                reflectionMetadataEncoder.addReachableExecutableMetadata(hostedMethod);
            }
        }
        if (NativeImageOptions.PrintMethodHistogram.getValue().booleanValue()) {
            System.out.println("encoded deopt entry points                 ; " + frameInfoCustomization.numDeoptEntryPoints);
            System.out.println("encoded during call entry points           ; " + frameInfoCustomization.numDuringCallEntryPoints);
        }
        ImageCodeInfo.HostedImageCodeInfo imageCodeInfo = CodeInfoTable.getImageCodeCache().getHostedImageCodeInfo();
        codeInfoEncoder.encodeAllAndInstall(imageCodeInfo, new InstantReferenceAdjuster());
        reflectionMetadataEncoder.encodeAllAndInstall();
        imageCodeInfo.setCodeStart((CodePointer)firstMethod);
        imageCodeInfo.setCodeSize(codeSize);
        imageCodeInfo.setDataOffset(codeSize);
        imageCodeInfo.setDataSize((UnsignedWord)WordFactory.zero());
        imageCodeInfo.setCodeAndDataMemorySize(codeSize);
        if (CodeInfoEncoder.Options.CodeInfoEncoderCounters.getValue().booleanValue()) {
            System.out.println("****Start Code Info Encoder Counters****");
            for (Counter counter : ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).group.getCounters()) {
                System.out.println(counter.getName() + " ; " + counter.getValue());
            }
            System.out.println("****End Code Info Encoder Counters****");
        }
        if (Options.VerifyDeoptimizationEntryPoints.getValue().booleanValue()) {
            this.verifyDeoptEntries(imageCodeInfo);
        }
        assert (this.verifyMethods(codeInfoEncoder, imageCodeInfo));
    }

    private void verifyDeoptEntries(CodeInfo codeInfo) {
        boolean hasError = false;
        ArrayList<Map.Entry<AnalysisMethod, Map<Long, CompilationInfoSupport.DeoptSourceFrameInfo>>> deoptEntries = new ArrayList<Map.Entry<AnalysisMethod, Map<Long, CompilationInfoSupport.DeoptSourceFrameInfo>>>(CompilationInfoSupport.singleton().getDeoptEntries().entrySet());
        deoptEntries.sort((e1, e2) -> ((AnalysisMethod)e1.getKey()).format("%H.%n(%p)").compareTo(((AnalysisMethod)e2.getKey()).format("%H.%n(%p)")));
        for (Map.Entry entry : deoptEntries) {
            HostedMethod method = this.imageHeap.getUniverse().lookup((JavaMethod)entry.getKey());
            ArrayList sourceFrameInfos = new ArrayList(((Map)entry.getValue()).entrySet());
            sourceFrameInfos.sort(Comparator.comparingLong(Map.Entry::getKey));
            for (Map.Entry entry2 : sourceFrameInfos) {
                hasError |= NativeImageCodeCache.verifyDeoptEntry(codeInfo, method, entry2);
            }
        }
        if (hasError) {
            VMError.shouldNotReachHere("Verification of deoptimization entry points failed");
        }
    }

    private static boolean verifyDeoptEntry(CodeInfo codeInfo, HostedMethod method, Map.Entry<Long, CompilationInfoSupport.DeoptSourceFrameInfo> sourceFrameInfo) {
        int deoptOffsetInImage = method.getDeoptOffsetInImage();
        long encodedBci = sourceFrameInfo.getKey();
        if (deoptOffsetInImage <= 0) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point method not compiled");
        }
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        long relativeIP = CodeInfoAccess.lookupDeoptimizationEntrypoint(codeInfo, deoptOffsetInImage, encodedBci, result);
        if (relativeIP < 0L) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point not found");
        }
        FrameInfoQueryResult targetFrame = result.getFrameInfo();
        if (targetFrame == null || !targetFrame.isDeoptEntry() || targetFrame.getEncodedBci() != encodedBci) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point found, but wrong property");
        }
        if (!targetFrame.duringCall()) {
            boolean hasExceptionHandler;
            boolean bl = hasExceptionHandler = result.getExceptionOffset() != 0L;
            if (!targetFrame.rethrowException() && !hasExceptionHandler) {
                return NativeImageCodeCache.error(method, encodedBci, "no exception handler registered for deopt entry");
            }
            if (targetFrame.rethrowException() && hasExceptionHandler) {
                return NativeImageCodeCache.error(method, encodedBci, "exception handler registered for rethrowException");
            }
        }
        CompilationInfoSupport.DeoptSourceFrameInfo sourceFrame = sourceFrameInfo.getValue();
        FrameInfoQueryResult.ValueInfo[] targetValues = targetFrame.getValueInfos();
        List<JavaKind> sourceKinds = Arrays.asList(sourceFrame.expectedKinds);
        if (targetFrame.getNumLocals() != sourceFrame.numLocals || targetFrame.getNumStack() != sourceFrame.numStack || targetFrame.getNumLocks() != sourceFrame.numLocks) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Mismatch between number of expected values in target and source.\n");
            errorMessage.append(String.format("Target: locals-%d, stack-%d, locks-%d.\n", targetFrame.getNumLocals(), targetFrame.getNumStack(), targetFrame.getNumLocks()));
            NativeImageCodeCache.appendFrameInfo(errorMessage, true, Arrays.stream(targetValues).map(FrameInfoQueryResult.ValueInfo::getKind).collect(Collectors.toList()));
            errorMessage.append(String.format("Source: locals-%d, stack-%d, locks-%d.\n", sourceFrame.numLocals, sourceFrame.numStack, sourceFrame.numLocks));
            NativeImageCodeCache.appendFrameInfo(errorMessage, false, sourceKinds);
            return NativeImageCodeCache.error(method, encodedBci, errorMessage.toString());
        }
        boolean validTarget = true;
        for (int i = 0; i < targetValues.length; ++i) {
            JavaKind targetKind = targetValues[i].getKind();
            if (targetKind == JavaKind.Illegal || targetKind == sourceKinds.get(i)) continue;
            validTarget = false;
            break;
        }
        if (!validTarget) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Deoptimization source frame is not a superset of the target frame.\n");
            NativeImageCodeCache.appendFrameInfo(errorMessage, true, Arrays.stream(targetValues).map(FrameInfoQueryResult.ValueInfo::getKind).collect(Collectors.toList()));
            NativeImageCodeCache.appendFrameInfo(errorMessage, false, sourceKinds);
            return NativeImageCodeCache.error(method, encodedBci, errorMessage.toString());
        }
        return false;
    }

    private static void appendFrameInfo(StringBuilder builder, boolean isTarget, List<JavaKind> javaKinds) {
        builder.append(String.format("***%s Frame***\n", isTarget ? "Target" : "Source"));
        for (int i = 0; i < javaKinds.size(); ++i) {
            builder.append(String.format("index %d: %s\n", i, javaKinds.get(i)));
        }
    }

    private static boolean error(HostedMethod method, long encodedBci, String msg) {
        System.out.println(method.format("%H.%n(%p)") + ", encodedBci " + encodedBci + " (bci " + FrameInfoDecoder.readableBci(encodedBci) + "): " + msg);
        return true;
    }

    private boolean verifyMethods(CodeInfoEncoder codeInfoEncoder, CodeInfo codeInfo) {
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)pair.getLeft();
            CodeInfoEncoder.verifyMethod(method, (CompilationResult)pair.getRight(), method.getCodeAddressOffset(), this.codeSizeFor(method), codeInfo);
        }
        codeInfoEncoder.verifyFrameInfo(codeInfo);
        return true;
    }

    public abstract void patchMethods(DebugContext var1, RelocatableBuffer var2, ObjectFile var3);

    public abstract void writeCode(RelocatableBuffer var1);

    public void writeConstants(NativeImageHeapWriter writer, RelocatableBuffer buffer) {
        ByteBuffer bb = buffer.getByteBuffer();
        this.dataSection.buildDataSection(bb, (position, constant) -> writer.writeReference(buffer, position, SubstrateObjectConstant.asObject((Constant)constant), "VMConstant: " + constant));
    }

    public abstract NativeImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer var1, ObjectFile var2, NativeImageCodeCache var3);

    public Path[] getCCInputFiles(Path tempDirectory, String imageName) {
        return new Path[]{tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix())};
    }

    public abstract List<ObjectFile.Symbol> getSymbols(ObjectFile var1);

    public void printCompilationResults() {
        System.out.println("--- compiled methods");
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)pair.getLeft();
            CompilationResult result = (CompilationResult)pair.getRight();
            System.out.format("%8d %5d %s: frame %d\n", method.getCodeAddressOffset(), result.getTargetCodeSize(), method.format("%H.%n(%p)"), result.getTotalFrameSize());
        }
        System.out.println("--- vtables:");
        for (HostedType type : this.imageHeap.getUniverse().getTypes()) {
            for (int i = 0; i < type.getVTable().length; ++i) {
                CompilationResult comp;
                HostedMethod method = type.getVTable()[i];
                if (method == null || (comp = this.compilationResultFor(type.getVTable()[i])) == null) continue;
                System.out.format("%d %s @ %d: %s = 0x%x\n", type.getTypeID(), type.toJavaName(false), i, method.format("%r %n(%p)"), method.getCodeAddressOffset());
            }
        }
    }

    public static interface ReflectionMetadataEncoderFactory {
        public ReflectionMetadataEncoder create(CodeInfoEncoder.Encoders var1);
    }

    public static interface ReflectionMetadataEncoder {
        public void addClassMetadata(MetaAccessProvider var1, HostedType var2, Class<?>[] var3);

        public void addReflectionFieldMetadata(MetaAccessProvider var1, HostedField var2, Field var3);

        public void addReflectionExecutableMetadata(MetaAccessProvider var1, HostedMethod var2, Executable var3, Object var4);

        public void addHeapAccessibleObjectMetadata(MetaAccessProvider var1, WrappedElement var2, AccessibleObject var3, boolean var4);

        public void addHidingFieldMetadata(AnalysisField var1, HostedType var2, String var3, HostedType var4, int var5);

        public void addHidingMethodMetadata(AnalysisMethod var1, HostedType var2, String var3, HostedType[] var4, int var5, HostedType var6);

        public void addReachableFieldMetadata(HostedField var1);

        public void addReachableExecutableMetadata(HostedMethod var1);

        public void encodeAllAndInstall();

        public byte[] getAnnotationsEncoding(AccessibleObject var1);

        public byte[] getParameterAnnotationsEncoding(Executable var1);

        public byte[] getAnnotationDefaultEncoding(Method var1);

        public byte[] getTypeAnnotationsEncoding(AccessibleObject var1);

        public byte[] getReflectParametersEncoding(Executable var1);
    }

    private static class HostedFrameInfoCustomization
    extends FrameInfoEncoder.SourceFieldsFromMethod {
        int numDeoptEntryPoints;
        int numDuringCallEntryPoints;

        private HostedFrameInfoCustomization() {
        }

        @Override
        protected Class<?> getDeclaringJavaClass(ResolvedJavaMethod method) {
            HostedType type = (HostedType)method.getDeclaringClass();
            assert (type.getWrapped().isReachable()) : "Declaring class not marked as used, therefore the DynamicHub is not initialized properly: " + method.format("%H.%n(%p)");
            return type.getJavaClass();
        }

        @Override
        protected boolean storeDeoptTargetMethod() {
            return false;
        }

        @Override
        protected boolean includeLocalValues(ResolvedJavaMethod method, Infopoint infopoint) {
            CompilationInfo compilationInfo = ((HostedMethod)method).compilationInfo;
            BytecodeFrame topFrame = infopoint.debugInfo.frame();
            if (this.isDeoptEntry(method, infopoint)) {
                if (infopoint instanceof DeoptEntryInfopoint) {
                    ++this.numDeoptEntryPoints;
                } else if (infopoint instanceof Call) {
                    ++this.numDuringCallEntryPoints;
                } else {
                    throw VMError.shouldNotReachHere();
                }
                return true;
            }
            BytecodeFrame rootFrame = topFrame;
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + topFrame;
                ++this.numDeoptEntryPoints;
                return true;
            }
            if (isDeoptEntry && topFrame.duringCall) {
                assert (infopoint instanceof Call);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + topFrame;
                ++this.numDuringCallEntryPoints;
                return true;
            }
            for (BytecodeFrame frame = topFrame; frame != null; frame = frame.caller()) {
                if (!CompilationInfoSupport.singleton().isFrameInformationRequired(frame.getMethod())) continue;
                return true;
            }
            return compilationInfo.canDeoptForTesting();
        }

        @Override
        protected boolean isDeoptEntry(ResolvedJavaMethod method, Infopoint infopoint) {
            BytecodeFrame topFrame;
            CompilationInfo compilationInfo = ((HostedMethod)method).compilationInfo;
            BytecodeFrame rootFrame = topFrame = infopoint.debugInfo.frame();
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + topFrame;
                return true;
            }
            if (isDeoptEntry && topFrame.duringCall) {
                assert (infopoint instanceof Call);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + topFrame;
                return true;
            }
            return false;
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> VerifyDeoptimizationEntryPoints = new HostedOptionKey<Boolean>(false);
    }
}

