/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.CConst;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.c.CHeader;
import com.oracle.svm.core.c.CTypedef;
import com.oracle.svm.core.c.CUnsigned;
import com.oracle.svm.core.c.function.GraalIsolateHeader;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CSourceCodeWriter;
import com.oracle.svm.hosted.code.CEntryPointCallStubMethod;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.HeapHistogram;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageDebugInfoProvider;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.NativeImageHeapWriter;
import com.oracle.svm.hosted.image.ObjectGroupHistogram;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.image.sources.SourceManager;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.util.ReflectionUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public abstract class NativeImage
extends AbstractImage {
    public static final long RWDATA_CGLOBALS_PARTITION_OFFSET = 0L;
    private final ObjectFile objectFile;
    private final int wordSize;
    private final Set<HostedMethod> uniqueEntryPoints = new HashSet<HostedMethod>();
    private long imageHeapSize = -1L;
    private ObjectFile.Section textSection;
    private ObjectFile.Section roDataSection;
    private ObjectFile.Section rwDataSection;
    private ObjectFile.Section heapSection;

    public NativeImage(AbstractImage.NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader imageClassLoader) {
        super(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, imageClassLoader);
        this.uniqueEntryPoints.addAll(entryPoints);
        int pageSize = SubstrateOptions.getPageSize();
        this.objectFile = ObjectFile.getNativeObjectFile((int)pageSize);
        this.objectFile.setByteOrder(ConfigurationValues.getTarget().arch.getByteOrder());
        this.wordSize = FrameAccess.wordSize();
        assert (this.objectFile.getWordSizeInBytes() == this.wordSize);
    }

    @Override
    public ObjectFile.Section getTextSection() {
        assert (this.textSection != null);
        return this.textSection;
    }

    @Override
    public abstract String[] makeLaunchCommand(AbstractImage.NativeImageKind var1, String var2, Path var3, Path var4, Method var5);

    protected final void write(DebugContext context, Path outputFile) {
        try {
            Path outFileParent = outputFile.normalize().getParent();
            if (outFileParent != null) {
                Files.createDirectories(outFileParent, new FileAttribute[0]);
            }
            try (FileChannel channel = FileChannel.open(outputFile, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                this.objectFile.withDebugContext(context, "ObjectFile.write", () -> this.objectFile.write(channel));
            }
        }
        catch (Exception ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        this.resultingImageSize = (int)outputFile.toFile().length();
        this.debugInfoSize = 0;
        String debugIdentifier = OS.getCurrent() == OS.DARWIN ? "__debug" : ".debug";
        for (ObjectFile.Element e : this.objectFile.getElements()) {
            if (!e.getName().contains(debugIdentifier)) continue;
            this.debugInfoSize += e.getMemSize(this.objectFile.getDecisionsByElement());
        }
        if (NativeImageOptions.PrintImageElementSizes.getValue().booleanValue()) {
            for (ObjectFile.Element e : this.objectFile.getElements()) {
                System.out.printf("PrintImageElementSizes:  size: %15d  name: %s\n", e.getMemSize(this.objectFile.getDecisionsByElement()), e.getElementName());
            }
        }
    }

    void writeHeaderFiles(Path outputDir, String imageName, boolean dynamic) {
        Map hostedMethods = this.uniqueEntryPoints.stream().filter(this::shouldWriteHeader).map(m -> Pair.create(NativeImage.cHeader(m), (Object)m)).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        hostedMethods.forEach((headerClass, methods) -> {
            methods.sort(NativeImage::sortMethodsByFileNameAndPosition);
            CHeader.Header header = headerClass == CHeader.Header.class ? NativeImage.defaultCHeaderAnnotation(imageName) : NativeImage.instantiateCHeader(headerClass);
            this.writeHeaderFile(outputDir, header, (List<HostedMethod>)methods, dynamic);
        });
    }

    private void writeHeaderFile(Path outDir, CHeader.Header header, List<HostedMethod> methods, boolean dynamic) {
        CSourceCodeWriter writer = new CSourceCodeWriter(outDir);
        String imageHeaderGuard = "__" + header.name().toUpperCase().replaceAll("[^A-Z0-9]", "_") + "_H";
        String dynamicSuffix = dynamic ? "_dynamic.h" : ".h";
        writer.appendln("#ifndef " + imageHeaderGuard);
        writer.appendln("#define " + imageHeaderGuard);
        writer.appendln();
        writer.writeCStandardHeaders();
        List<String> dependencies = header.dependsOn().stream().map(NativeImage::instantiateCHeader).map(depHeader -> "<" + depHeader.name() + dynamicSuffix + ">").collect(Collectors.toList());
        writer.includeFiles(dependencies);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(baos);
        header.writePreamble(printWriter);
        printWriter.flush();
        for (String line : baos.toString().split("\\r?\\n")) {
            writer.appendln(line);
        }
        if (methods.size() > 0) {
            writer.appendln();
            writer.appendln("#if defined(__cplusplus)");
            writer.appendln("extern \"C\" {");
            writer.appendln("#endif");
            writer.appendln();
            methods.forEach(m -> this.writeMethodHeader((HostedMethod)m, writer, dynamic));
            writer.appendln("#if defined(__cplusplus)");
            writer.appendln("}");
            writer.appendln("#endif");
        }
        writer.appendln("#endif");
        Path headerFile = writer.writeFile(header.name() + dynamicSuffix);
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.HEADER, headerFile);
    }

    private static Class<? extends CHeader.Header> cHeader(HostedMethod entryPointStub) {
        AnalysisMethod entryPoint = CEntryPointCallStubSupport.singleton().getMethodForStub((CEntryPointCallStubMethod)entryPointStub.wrapped.wrapped);
        CHeader methodAnnotation = (CHeader)entryPoint.getDeclaredAnnotation(CHeader.class);
        if (methodAnnotation != null) {
            return methodAnnotation.value();
        }
        for (AnalysisType enclosingType = entryPoint.getDeclaringClass(); enclosingType != null; enclosingType = enclosingType.getEnclosingType()) {
            CHeader enclosing = (CHeader)enclosingType.getDeclaredAnnotation(CHeader.class);
            if (enclosing == null) continue;
            return enclosing.value();
        }
        return CHeader.Header.class;
    }

    private static CHeader.Header instantiateCHeader(Class<? extends CHeader.Header> header) {
        try {
            return (CHeader.Header)ReflectionUtil.newInstance(header);
        }
        catch (ReflectionUtil.ReflectionUtilError ex) {
            throw UserError.abort(ex.getCause(), "CHeader %s cannot be instantiated. Please make sure that it has a nullary constructor and is not abstract.", header.getName());
        }
    }

    private static CHeader.Header defaultCHeaderAnnotation(final String defaultHeaderName) {
        return new CHeader.Header(){

            @Override
            public String name() {
                return defaultHeaderName;
            }

            @Override
            public List<Class<? extends CHeader.Header>> dependsOn() {
                return Collections.singletonList(GraalIsolateHeader.class);
            }
        };
    }

    private static int sortMethodsByFileNameAndPosition(HostedMethod stub1, HostedMethod stub2) {
        ResolvedJavaMethod rm1 = CEntryPointCallStubSupport.singleton().getMethodForStub((CEntryPointCallStubMethod)((CEntryPointCallStubMethod)stub1.wrapped.wrapped)).wrapped;
        ResolvedJavaMethod rm2 = CEntryPointCallStubSupport.singleton().getMethodForStub((CEntryPointCallStubMethod)((CEntryPointCallStubMethod)stub2.wrapped.wrapped)).wrapped;
        int fileComparison = rm1.getDeclaringClass().getSourceFileName().compareTo(rm2.getDeclaringClass().getSourceFileName());
        if (fileComparison != 0) {
            return fileComparison;
        }
        int rm1Line = rm1.getLineNumberTable() != null ? rm1.getLineNumberTable().getLineNumber(0) : -1;
        int rm2Line = rm2.getLineNumberTable() != null ? rm2.getLineNumberTable().getLineNumber(0) : -1;
        return rm1Line - rm2Line;
    }

    private void writeMethodHeader(HostedMethod m, CSourceCodeWriter writer, boolean dynamic) {
        assert (Modifier.isStatic(m.getModifiers())) : "Published methods that go into the header must be static.";
        CEntryPointData cEntryPointData = (CEntryPointData)m.getWrapped().getEntryPointData();
        String docComment = cEntryPointData.getDocumentation();
        if (docComment != null && !docComment.isEmpty()) {
            writer.appendln("/*");
            Arrays.stream(docComment.split("\n")).forEach(l -> writer.appendln(" * " + l));
            writer.appendln(" */");
        }
        if (dynamic) {
            writer.append("typedef ");
        }
        AnnotatedType annotatedReturnType = this.getAnnotatedReturnType(m);
        writer.append(CSourceCodeWriter.toCTypeName(m, (ResolvedJavaType)m.getSignature().getReturnType((ResolvedJavaType)m.getDeclaringClass()), Optional.ofNullable(annotatedReturnType.getAnnotation(CTypedef.class)).map(CTypedef::name), false, annotatedReturnType.isAnnotationPresent(CUnsigned.class), (MetaAccessProvider)this.metaAccess, this.nativeLibs));
        writer.append(" ");
        String symbolName = cEntryPointData.getSymbolName();
        assert (!symbolName.isEmpty());
        if (dynamic) {
            writer.append("(*").append(symbolName).append("_fn_t)");
        } else {
            writer.append(symbolName);
        }
        writer.append("(");
        String sep = "";
        AnnotatedType[] annotatedParameterTypes = this.getAnnotatedParameterTypes(m);
        ResolvedJavaMethod.Parameter[] parameters = m.getParameters();
        assert (parameters != null);
        for (int i = 0; i < m.getSignature().getParameterCount(false); ++i) {
            writer.append(sep);
            sep = ", ";
            writer.append(CSourceCodeWriter.toCTypeName(m, (ResolvedJavaType)m.getSignature().getParameterType(i, (ResolvedJavaType)m.getDeclaringClass()), Optional.ofNullable(annotatedParameterTypes[i].getAnnotation(CTypedef.class)).map(CTypedef::name), annotatedParameterTypes[i].isAnnotationPresent(CConst.class), annotatedParameterTypes[i].isAnnotationPresent(CUnsigned.class), (MetaAccessProvider)this.metaAccess, this.nativeLibs));
            if (!parameters[i].isNamePresent()) continue;
            writer.append(" ");
            writer.append(parameters[i].getName());
        }
        writer.appendln(");");
        writer.appendln();
    }

    private AnnotatedType getAnnotatedReturnType(HostedMethod hostedMethod) {
        return this.getMethod(hostedMethod).getAnnotatedReturnType();
    }

    private AnnotatedType[] getAnnotatedParameterTypes(HostedMethod hostedMethod) {
        return this.getMethod(hostedMethod).getAnnotatedParameterTypes();
    }

    private Method getMethod(HostedMethod hostedMethod) {
        Method method;
        AnalysisMethod entryPoint = CEntryPointCallStubSupport.singleton().getMethodForStub((CEntryPointCallStubMethod)hostedMethod.wrapped.wrapped);
        try {
            method = entryPoint.getDeclaringClass().getJavaClass().getDeclaredMethod(entryPoint.getName(), MethodType.fromMethodDescriptorString(entryPoint.getSignature().toMethodDescriptor(), this.imageClassLoader).parameterArray());
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
        return method;
    }

    private boolean shouldWriteHeader(HostedMethod method) {
        Object data = method.getWrapped().getEntryPointData();
        return data instanceof CEntryPointData && ((CEntryPointData)data).getPublishAs() == CEntryPoint.Publish.SymbolAndHeader;
    }

    private ObjectFile.Symbol defineDataSymbol(String name, ObjectFile.Element section, long position) {
        return this.objectFile.createDefinedSymbol(name, section, position, this.wordSize, false, SubstrateOptions.InternalSymbolsAreGlobal.getValue().booleanValue());
    }

    private ObjectFile.Symbol defineRelocationForSymbol(String name, long position) {
        ObjectFile.Symbol symbol = null;
        if (this.objectFile.getSymbolTable().getSymbol(name) == null) {
            symbol = this.objectFile.createUndefinedSymbol(name, 0, true);
        }
        ObjectFile.ProgbitsSectionImpl baseSectionImpl = (ObjectFile.ProgbitsSectionImpl)this.rwDataSection.getImpl();
        int offsetInSection = Math.toIntExact(0L + position);
        baseSectionImpl.markRelocationSite(offsetInSection, this.wordSize == 8 ? ObjectFile.RelocationKind.DIRECT_8 : ObjectFile.RelocationKind.DIRECT_4, name, 0L);
        return symbol;
    }

    @Override
    public void build(String imageName, DebugContext debug) {
        try (DebugContext.Scope buildScope = debug.scope((Object)"NativeImage.build");){
            CGlobalDataFeature cGlobals = CGlobalDataFeature.singleton();
            long roSectionSize = this.codeCache.getAlignedConstantsSize();
            long rwSectionSize = ConfigurationValues.getObjectLayout().alignUp(cGlobals.getSize());
            ImageHeapLayoutInfo heapLayout = this.heap.getLayouter().layout(this.heap, this.objectFile.getPageSize());
            assert (!this.hasDuplicatedObjects(this.heap.getObjects())) : "heap.getObjects() must not contain any duplicates";
            this.imageHeapSize = heapLayout.getImageHeapSize();
            int textSectionSize = this.codeCache.getCodeCacheSize();
            RelocatableBuffer textBuffer = new RelocatableBuffer(textSectionSize, this.objectFile.getByteOrder());
            NativeTextSectionImpl textImpl = NativeTextSectionImpl.factory(textBuffer, this.objectFile, this.codeCache);
            this.textSection = this.objectFile.newProgbitsSection(SectionName.TEXT.getFormatDependentName(this.objectFile.getFormat()), this.objectFile.getPageSize(), false, true, (ObjectFile.ProgbitsSectionImpl)textImpl);
            boolean writable = SubstrateOptions.ForceNoROSectionRelocations.getValue();
            RelocatableBuffer roDataBuffer = new RelocatableBuffer(roSectionSize, this.objectFile.getByteOrder());
            BasicProgbitsSectionImpl roDataImpl = new BasicProgbitsSectionImpl(roDataBuffer.getBackingArray());
            this.roDataSection = this.objectFile.newProgbitsSection(SectionName.RODATA.getFormatDependentName(this.objectFile.getFormat()), this.objectFile.getPageSize(), writable, false, (ObjectFile.ProgbitsSectionImpl)roDataImpl);
            RelocatableBuffer rwDataBuffer = new RelocatableBuffer(rwSectionSize, this.objectFile.getByteOrder());
            BasicProgbitsSectionImpl rwDataImpl = new BasicProgbitsSectionImpl(rwDataBuffer.getBackingArray());
            this.rwDataSection = this.objectFile.newProgbitsSection(SectionName.DATA.getFormatDependentName(this.objectFile.getFormat()), this.objectFile.getPageSize(), true, false, (ObjectFile.ProgbitsSectionImpl)rwDataImpl);
            this.objectFile.createDefinedSymbol(this.textSection.getName(), (ObjectFile.Element)this.textSection, 0L, 0, false, false);
            this.objectFile.createDefinedSymbol("__svm_text_end", (ObjectFile.Element)this.textSection, (long)textSectionSize, 0, false, SubstrateOptions.InternalSymbolsAreGlobal.getValue().booleanValue());
            this.objectFile.createDefinedSymbol(this.roDataSection.getName(), (ObjectFile.Element)this.roDataSection, 0L, 0, false, false);
            this.objectFile.createDefinedSymbol(this.rwDataSection.getName(), (ObjectFile.Element)this.rwDataSection, 0L, 0, false, false);
            NativeImageHeapWriter writer = new NativeImageHeapWriter(this.heap, heapLayout);
            textImpl.writeTextSection(debug, this.textSection, this.entryPoints);
            this.codeCache.writeConstants(writer, roDataBuffer);
            cGlobals.writeData(rwDataBuffer, (offset, symbolName, isGlobalSymbol) -> this.objectFile.createDefinedSymbol(symbolName, (ObjectFile.Element)this.rwDataSection, (long)offset + 0L, this.wordSize, false, isGlobalSymbol || SubstrateOptions.InternalSymbolsAreGlobal.getValue() != false), (offset, symbolName, isGlobalSymbol) -> this.defineRelocationForSymbol(symbolName, offset));
            this.defineDataSymbol("__svm_cglobaldata_base", (ObjectFile.Element)this.rwDataSection, 0L);
            if ((Integer)SubstrateOptions.GenerateDebugInfo.getValue(HostedOptionValues.singleton()) > 0) {
                Timer timer = TimerCollection.singleton().get(TimerCollection.Registry.DEBUG_INFO);
                try (Timer.StopTimer t = timer.start();){
                    ImageSingletons.add(SourceManager.class, (Object)new SourceManager());
                    NativeImageDebugInfoProvider provider = new NativeImageDebugInfoProvider(debug, this.codeCache, this.heap, this.metaAccess);
                    this.objectFile.installDebugInfo((DebugInfoProvider)provider);
                }
                ProgressReporter.singleton().setDebugInfoTimer(timer);
            }
            int alignment = this.objectFile.getPageSize();
            RelocatableBuffer heapSectionBuffer = new RelocatableBuffer(this.imageHeapSize, this.objectFile.getByteOrder());
            BasicProgbitsSectionImpl heapSectionImpl = new BasicProgbitsSectionImpl(heapSectionBuffer.getBackingArray());
            this.heapSection = this.objectFile.newProgbitsSection(SectionName.SVM_HEAP.getFormatDependentName(this.objectFile.getFormat()), alignment, writable, false, (ObjectFile.ProgbitsSectionImpl)heapSectionImpl);
            this.objectFile.createDefinedSymbol(this.heapSection.getName(), (ObjectFile.Element)this.heapSection, 0L, 0, false, false);
            long offsetOfARelocatablePointer = writer.writeHeap(debug, heapSectionBuffer);
            assert (!SubstrateOptions.SpawnIsolates.getValue().booleanValue() || heapSectionBuffer.getByteBuffer().getLong((int)offsetOfARelocatablePointer) == 0L);
            this.defineDataSymbol("__svm_heap_begin", (ObjectFile.Element)this.heapSection, 0L);
            this.defineDataSymbol("__svm_heap_end", (ObjectFile.Element)this.heapSection, this.imageHeapSize);
            this.defineDataSymbol("__svm_heap_relocatable_begin", (ObjectFile.Element)this.heapSection, heapLayout.getReadOnlyRelocatableOffset());
            this.defineDataSymbol("__svm_heap_relocatable_end", (ObjectFile.Element)this.heapSection, heapLayout.getReadOnlyRelocatableOffset() + heapLayout.getReadOnlyRelocatableSize());
            this.defineDataSymbol("__svm_a_relocatable_pointer", (ObjectFile.Element)this.heapSection, offsetOfARelocatablePointer);
            this.defineDataSymbol("__svm_heap_writable_begin", (ObjectFile.Element)this.heapSection, heapLayout.getWritableOffset());
            this.defineDataSymbol("__svm_heap_writable_end", (ObjectFile.Element)this.heapSection, heapLayout.getWritableOffset() + heapLayout.getWritableSize());
            this.markRelocationSitesFromBuffer(textBuffer, (ObjectFile.ProgbitsSectionImpl)textImpl);
            this.markRelocationSitesFromBuffer(roDataBuffer, (ObjectFile.ProgbitsSectionImpl)roDataImpl);
            this.markRelocationSitesFromBuffer(rwDataBuffer, (ObjectFile.ProgbitsSectionImpl)rwDataImpl);
            this.markRelocationSitesFromBuffer(heapSectionBuffer, (ObjectFile.ProgbitsSectionImpl)heapSectionImpl);
            this.printHeapStatistics(this.heap.getLayouter().getPartitions());
        }
    }

    private boolean hasDuplicatedObjects(Collection<NativeImageHeap.ObjectInfo> objects) {
        Set deduplicated = Collections.newSetFromMap(new IdentityHashMap());
        for (NativeImageHeap.ObjectInfo info : objects) {
            deduplicated.add(info);
        }
        return deduplicated.size() != this.heap.getObjectCount();
    }

    private void markRelocationSitesFromBuffer(RelocatableBuffer buffer, ObjectFile.ProgbitsSectionImpl sectionImpl) {
        for (Map.Entry<Integer, RelocatableBuffer.Info> entry : buffer.getSortedRelocations()) {
            int offset = entry.getKey();
            RelocatableBuffer.Info info = entry.getValue();
            assert (ConfigurationValues.getTarget().arch instanceof AArch64 || NativeImage.checkEmbeddedOffset(sectionImpl, offset, info));
            if (info.getTargetObject() instanceof CFunctionPointer) {
                this.markFunctionRelocationSite(sectionImpl, offset, info);
                continue;
            }
            if (sectionImpl.getElement() == this.textSection) {
                this.markDataRelocationSiteFromText(buffer, sectionImpl, offset, info);
                continue;
            }
            Object targetObject = info.getTargetObject();
            NativeImageHeap.ObjectInfo targetObjectInfo = this.heap.getObjectInfo(targetObject);
            this.markDataRelocationSite(sectionImpl, offset, info, targetObjectInfo);
        }
    }

    private static boolean checkEmbeddedOffset(ObjectFile.ProgbitsSectionImpl sectionImpl, int offset, RelocatableBuffer.Info info) {
        ByteBuffer dataBuf = ByteBuffer.wrap(sectionImpl.getContent()).order(sectionImpl.getElement().getOwner().getByteOrder());
        if (info.getRelocationSize() == 8) {
            long value = dataBuf.getLong(offset);
            assert (value == 0L || value == -2401018187971961171L) : String.format("unexpected embedded offset: 0x%x, info: %s", value, info);
        } else if (info.getRelocationSize() == 4) {
            int value = dataBuf.getInt(offset);
            assert (value == 0 || value == -559030611) : "unexpected embedded offset";
        } else {
            VMError.shouldNotReachHere("unsupported relocation size: " + info.getRelocationSize());
        }
        return true;
    }

    private void markFunctionRelocationSite(ObjectFile.ProgbitsSectionImpl sectionImpl, int offset, RelocatableBuffer.Info info) {
        HostedMethod target;
        assert (info.getTargetObject() instanceof CFunctionPointer) : "Wrong type for FunctionPointer relocation: " + info.getTargetObject().toString();
        MethodPointer methodPointer = (MethodPointer)info.getTargetObject();
        ResolvedJavaMethod method = methodPointer.getMethod();
        HostedMethod hostedMethod = target = method instanceof HostedMethod ? (HostedMethod)method : this.heap.getUniverse().lookup((JavaMethod)method);
        if (!target.isCompiled()) {
            target = this.metaAccess.lookupJavaMethod(InvalidMethodPointerHandler.METHOD_POINTER_NOT_COMPILED_HANDLER_METHOD);
        }
        Architecture arch = ConfigurationValues.getTarget().arch;
        assert (arch instanceof AArch64 || ObjectFile.RelocationKind.getDirect((int)arch.getWordSize()) == info.getRelocationKind());
        sectionImpl.markRelocationSite(offset, info.getRelocationKind(), NativeImage.localSymbolNameForMethod(target), 0L);
    }

    private static boolean isAddendAligned(Architecture arch, long addend, ObjectFile.RelocationKind kind) {
        if (arch instanceof AMD64) {
            return true;
        }
        switch (kind) {
            case AARCH64_R_AARCH64_LDST16_ABS_LO12_NC: {
                return (addend & 1L) == 0L;
            }
            case AARCH64_R_AARCH64_LDST32_ABS_LO12_NC: {
                return (addend & 3L) == 0L;
            }
            case AARCH64_R_AARCH64_LDST64_ABS_LO12_NC: {
                return (addend & 7L) == 0L;
            }
            case AARCH64_R_AARCH64_LDST128_ABS_LO12_NC: {
                return (addend & 0xFL) == 0L;
            }
        }
        return true;
    }

    private void markDataRelocationSite(ObjectFile.ProgbitsSectionImpl sectionImpl, int offset, RelocatableBuffer.Info info, NativeImageHeap.ObjectInfo targetObjectInfo) {
        assert (ConfigurationValues.getTarget().arch instanceof AArch64 || info.getRelocationSize() == 4 || info.getRelocationSize() == 8) : "AMD64 Data relocation size should be 4 or 8 bytes.";
        assert (targetObjectInfo != null);
        String targetSectionName = this.heapSection.getName();
        long address = targetObjectInfo.getAddress();
        long relocationAddend = address + info.getAddend();
        sectionImpl.markRelocationSite(offset, info.getRelocationKind(), targetSectionName, relocationAddend);
    }

    private void markDataRelocationSiteFromText(RelocatableBuffer buffer, ObjectFile.ProgbitsSectionImpl sectionImpl, int offset, RelocatableBuffer.Info info) {
        Architecture arch = ConfigurationValues.getTarget().arch;
        assert (arch instanceof AArch64 || info.getRelocationSize() == 4 || info.getRelocationSize() == 8) : "AMD64 Data relocation size should be 4 or 8 bytes. Got size: " + info.getRelocationSize();
        Object target = info.getTargetObject();
        if (target instanceof DataSectionReference) {
            long addend = (long)((DataSectionReference)target).getOffset() - info.getAddend();
            assert (NativeImage.isAddendAligned(arch, addend, info.getRelocationKind())) : "improper addend alignment";
            sectionImpl.markRelocationSite(offset, info.getRelocationKind(), this.roDataSection.getName(), addend);
        } else if (target instanceof CGlobalDataReference) {
            CGlobalDataReference ref = (CGlobalDataReference)((Object)target);
            CGlobalDataInfo dataInfo = ref.getDataInfo();
            CGlobalDataImpl<?> data = dataInfo.getData();
            long addend = 0L + (long)dataInfo.getOffset() - info.getAddend();
            assert (NativeImage.isAddendAligned(arch, addend, info.getRelocationKind())) : "improper addend alignment";
            sectionImpl.markRelocationSite(offset, info.getRelocationKind(), this.rwDataSection.getName(), addend);
            if (dataInfo.isSymbolReference()) {
                if (this.objectFile.getSymbolTable().getSymbol(data.symbolName) == null) {
                    this.objectFile.createUndefinedSymbol(data.symbolName, 0, true);
                }
                ObjectFile.ProgbitsSectionImpl baseSectionImpl = (ObjectFile.ProgbitsSectionImpl)this.rwDataSection.getImpl();
                int offsetInSection = Math.toIntExact(0L + (long)dataInfo.getOffset());
                baseSectionImpl.markRelocationSite(offsetInSection, ObjectFile.RelocationKind.getDirect((int)this.wordSize), data.symbolName, 0L);
            }
        } else if (target instanceof ConstantReference) {
            Object object = SubstrateObjectConstant.asObject((Constant)((ConstantReference)target).getConstant());
            long address = this.heap.getObjectInfo(object).getAddress();
            int encShift = ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).getShift();
            long targetValue = address >>> encShift;
            assert (targetValue << encShift == address) : "Reference compression shift discards non-zero bits: " + Long.toHexString(address);
            ByteBuffer bufferBytes = buffer.getByteBuffer();
            if (arch instanceof AMD64) {
                assert (info.getRelocationKind() == ObjectFile.RelocationKind.DIRECT_4 || info.getRelocationKind() == ObjectFile.RelocationKind.DIRECT_8);
                if (info.getRelocationSize() == 8) {
                    bufferBytes.putLong(offset, targetValue);
                } else if (info.getRelocationSize() == 4) {
                    bufferBytes.putInt(offset, NumUtil.safeToInt((long)targetValue));
                } else {
                    new Exception().printStackTrace();
                    VMError.shouldNotReachHere("Unsupported object reference size: " + info.getRelocationSize());
                }
            } else if (arch instanceof AArch64) {
                int patchValue = 0;
                switch (info.getRelocationKind()) {
                    case AARCH64_R_MOVW_UABS_G0: 
                    case AARCH64_R_MOVW_UABS_G0_NC: {
                        patchValue = (int)targetValue & 0xFFFF;
                        break;
                    }
                    case AARCH64_R_MOVW_UABS_G1: 
                    case AARCH64_R_MOVW_UABS_G1_NC: {
                        patchValue = (int)(targetValue >> 16) & 0xFFFF;
                        break;
                    }
                    case AARCH64_R_MOVW_UABS_G2: 
                    case AARCH64_R_MOVW_UABS_G2_NC: {
                        patchValue = (int)(targetValue >> 32) & 0xFFFF;
                        break;
                    }
                    case AARCH64_R_MOVW_UABS_G3: {
                        patchValue = (int)(targetValue >> 48) & 0xFFFF;
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere("Unsupported AArch64 relocation kind: " + info.getRelocationKind());
                    }
                }
                switch (info.getRelocationKind()) {
                    case AARCH64_R_MOVW_UABS_G0: {
                        assert ((targetValue & 0xFFFFFFFFFFFF0000L) == 0L) : "value to patch does not fit";
                        break;
                    }
                    case AARCH64_R_MOVW_UABS_G1: {
                        assert ((targetValue & 0xFFFFFFFF00000000L) == 0L) : "value to patch does not fit";
                        break;
                    }
                    case AARCH64_R_MOVW_UABS_G2: {
                        assert ((targetValue & 0xFFFF000000000000L) == 0L) : "value to patch does not fit";
                        break;
                    }
                }
                int originalInst = bufferBytes.getInt(offset);
                int newInst = AArch64Assembler.PatcherUtil.patchMov((int)originalInst, (int)patchValue);
                bufferBytes.putInt(offset, newInst);
            }
        } else {
            throw VMError.shouldNotReachHere("Unsupported target object for relocation in text section");
        }
    }

    public static String localSymbolNameForMethod(ResolvedJavaMethod sm) {
        return SubstrateOptions.ImageSymbolsPrefix.getValue() + (sm instanceof HostedMethod ? ((HostedMethod)sm).getUniqueShortName() : SubstrateUtil.uniqueShortName(sm));
    }

    public static String globalSymbolNameForMethod(Method m) {
        return SubstrateUtil.mangleName(SubstrateUtil.uniqueShortName(m));
    }

    public static String globalSymbolNameForMethod(ResolvedJavaMethod sm) {
        return SubstrateUtil.mangleName(sm instanceof HostedMethod ? ((HostedMethod)sm).getUniqueShortName() : SubstrateUtil.uniqueShortName(sm));
    }

    @Override
    public long getImageHeapSize() {
        assert (this.imageHeapSize > -1L) : "imageHeapSize accessed before set";
        return this.imageHeapSize;
    }

    @Override
    public ObjectFile getOrCreateDebugObjectFile() {
        assert (this.objectFile != null);
        return this.objectFile;
    }

    private void printHeapStatistics(ImageHeapPartition[] partitions) {
        if (NativeImageOptions.PrintHeapHistogram.getValue().booleanValue()) {
            ObjectGroupHistogram.print(this.heap);
            this.printHistogram(partitions);
        }
        if (NativeImageOptions.PrintImageHeapPartitionSizes.getValue().booleanValue()) {
            NativeImage.printSizes(partitions);
        }
    }

    private void printHistogram(ImageHeapPartition[] partitions) {
        for (ImageHeapPartition partition : partitions) {
            NativeImage.printHistogram(partition, this.heap.getObjects());
        }
    }

    private static void printSizes(ImageHeapPartition[] partitions) {
        for (ImageHeapPartition partition : partitions) {
            NativeImage.printSize(partition);
        }
    }

    private static void printHistogram(ImageHeapPartition partition, Iterable<NativeImageHeap.ObjectInfo> objects) {
        HeapHistogram histogram = new HeapHistogram();
        HashSet<NativeImageHeap.ObjectInfo> uniqueObjectInfo = new HashSet<NativeImageHeap.ObjectInfo>();
        long uniqueCount = 0L;
        long uniqueSize = 0L;
        long canonicalizedCount = 0L;
        long canonicalizedSize = 0L;
        for (NativeImageHeap.ObjectInfo info : objects) {
            if (partition != info.getPartition()) continue;
            if (uniqueObjectInfo.add(info)) {
                histogram.add(info, info.getSize());
                ++uniqueCount;
                uniqueSize += info.getSize();
                continue;
            }
            ++canonicalizedCount;
            canonicalizedSize += info.getSize();
        }
        long nonuniqueCount = uniqueCount + canonicalizedCount;
        long nonuniqueSize = uniqueSize + canonicalizedSize;
        assert (partition.getSize() >= nonuniqueSize) : "the total size can contain some overhead";
        double countPercent = 100.0 * ((double)uniqueCount / (double)nonuniqueCount);
        double sizePercent = 100.0 * ((double)uniqueSize / (double)nonuniqueSize);
        double sizeOverheadPercent = 100.0 * (1.0 - (double)partition.getSize() / (double)nonuniqueSize);
        histogram.printHeadings(String.format("=== Partition: %s   count: %d / %d = %.1f%%  object size: %d / %d = %.1f%%  total size: %d (%.1f%% overhead) ===", partition.getName(), uniqueCount, nonuniqueCount, countPercent, uniqueSize, nonuniqueSize, sizePercent, partition.getSize(), sizeOverheadPercent));
        histogram.print();
    }

    private static void printSize(ImageHeapPartition partition) {
        System.out.printf("PrintImageHeapPartitionSizes:  partition: %s  size: %d%n", partition.getName(), partition.getSize());
    }

    public static abstract class NativeTextSectionImpl
    extends BasicProgbitsSectionImpl {
        protected final RelocatableBuffer textBuffer;
        protected final ObjectFile objectFile;
        protected final NativeImageCodeCache codeCache;

        public static NativeTextSectionImpl factory(RelocatableBuffer relocatableBuffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
            return codeCache.getTextSectionImpl(relocatableBuffer, objectFile, codeCache);
        }

        private ObjectFile.Element getRodataSection() {
            return this.getElement().getOwner().elementForName(SectionName.RODATA.getFormatDependentName(this.getElement().getOwner().getFormat()));
        }

        public Set<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet deps = ObjectFile.minimalDependencies(decisions, (ObjectFile.Element)this.getElement());
            LayoutDecision ourContent = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.CONTENT);
            LayoutDecision ourVaddr = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.VADDR);
            LayoutDecision rodataVaddr = decisions.get(this.getRodataSection()).getDecision(LayoutDecision.Kind.VADDR);
            deps.add(BuildDependency.createOrGet((LayoutDecision)ourContent, (LayoutDecision)ourVaddr));
            deps.add(BuildDependency.createOrGet((LayoutDecision)ourContent, (LayoutDecision)rodataVaddr));
            return deps;
        }

        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            return this.getContent();
        }

        protected abstract void defineMethodSymbol(String var1, boolean var2, ObjectFile.Element var3, HostedMethod var4, CompilationResult var5);

        protected void writeTextSection(DebugContext debug, ObjectFile.Section textSection, List<HostedMethod> entryPoints) {
            try (Indent indent = debug.logAndIndent("TextImpl.writeTextSection");){
                HashMap<String, HostedMethod> methodsBySignature = new HashMap<String, HostedMethod>();
                for (Pair<HostedMethod, CompilationResult> pair : this.codeCache.getOrderedCompilations()) {
                    String symName = NativeImage.localSymbolNameForMethod((ResolvedJavaMethod)pair.getLeft());
                    String signatureString = ((HostedMethod)pair.getLeft()).getUniqueShortName();
                    HostedMethod existing = (HostedMethod)methodsBySignature.get(signatureString);
                    HostedMethod current = (HostedMethod)pair.getLeft();
                    if (existing != null) {
                        ResolvedJavaType currentReturnType;
                        ResolvedJavaType existingReturnType = existing.getSignature().getReturnType(null).resolve((ResolvedJavaType)existing.getDeclaringClass());
                        if (existingReturnType.isAssignableFrom(currentReturnType = current.getSignature().getReturnType(null).resolve((ResolvedJavaType)current.getDeclaringClass()))) {
                            HostedMethod replaced = methodsBySignature.put(signatureString, current);
                            assert (replaced.equals(existing));
                        }
                    } else {
                        methodsBySignature.put(signatureString, current);
                    }
                    this.defineMethodSymbol(symName, false, (ObjectFile.Element)textSection, current, (CompilationResult)pair.getRight());
                }
                for (Map.Entry entry : methodsBySignature.entrySet()) {
                    int entryPointIndex;
                    CEntryPointData cEntryData;
                    HostedMethod method = (HostedMethod)entry.getValue();
                    Object data = method.getWrapped().getEntryPointData();
                    CEntryPointData cEntryPointData = cEntryData = data instanceof CEntryPointData ? (CEntryPointData)data : null;
                    if (cEntryData != null && cEntryData.getPublishAs() == CEntryPoint.Publish.NotPublished || (entryPointIndex = entryPoints.indexOf(method)) == -1) continue;
                    String mangledSignature = SubstrateUtil.mangleName((String)entry.getKey());
                    assert (mangledSignature.equals(NativeImage.globalSymbolNameForMethod(method)));
                    this.defineMethodSymbol(mangledSignature, true, (ObjectFile.Element)textSection, method, null);
                    if (cEntryData == null) continue;
                    assert (!cEntryData.getSymbolName().isEmpty());
                    this.defineMethodSymbol(cEntryData.getSymbolName(), true, (ObjectFile.Element)textSection, method, this.codeCache.compilationResultFor(method));
                }
                assert (!this.textBuffer.hasRelocations());
                this.codeCache.patchMethods(debug, this.textBuffer, this.objectFile);
                this.codeCache.writeCode(this.textBuffer);
            }
        }

        protected NativeTextSectionImpl(RelocatableBuffer relocatableBuffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
            super(relocatableBuffer.getBackingArray());
            this.textBuffer = relocatableBuffer;
            this.objectFile = objectFile;
            this.codeCache = codeCache;
        }
    }
}

