/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.annotate.DeoptTest;
import com.oracle.svm.core.graal.nodes.DeoptEntryBeginNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.NewPodInstanceNode;
import com.oracle.svm.core.graal.nodes.TestDeoptimizeNode;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;

final class PodFactorySubstitutionMethod
extends CustomSubstitutionMethod {
    PodFactorySubstitutionMethod(ResolvedJavaMethod original) {
        super(original);
    }

    @Override
    public boolean allowRuntimeCompilation() {
        return true;
    }

    @Override
    public int getModifiers() {
        return super.getModifiers() & 0xFFFFFEFF;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        boolean trackNodeSourcePosition = purpose == GraphProvider.Purpose.ANALYSIS;
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, trackNodeSourcePosition);
        boolean isDeoptTarget = method instanceof SharedMethod && ((SharedMethod)method).isDeoptTarget();
        ResolvedJavaType factoryType = method.getDeclaringClass();
        Pod.RuntimeSupport.PodFactory annotation = (Pod.RuntimeSupport.PodFactory)factoryType.getAnnotation(Pod.RuntimeSupport.PodFactory.class);
        ResolvedJavaType podConcreteType = kit.getMetaAccess().lookupJavaType(annotation.podClass());
        ResolvedJavaMethod targetCtor = null;
        for (ResolvedJavaMethod ctor : podConcreteType.getSuperclass().getDeclaredConstructors()) {
            if (!PodFactorySubstitutionMethod.parameterTypesMatch(method, ctor)) continue;
            targetCtor = ctor;
            break;
        }
        GraalError.guarantee((targetCtor != null ? 1 : 0) != 0, (String)"Matching constructor not found: %s", (Object)this.getSignature());
        int instanceLocal = kit.getFrameState().localsSize() - 1;
        int nextDeoptIndex = PodFactorySubstitutionMethod.startMethod(kit, isDeoptTarget, 0);
        PodFactorySubstitutionMethod.instantiatePod(kit, providers, factoryType, podConcreteType, instanceLocal);
        if (this.isAnnotationPresent(DeoptTest.class)) {
            kit.append((ValueNode)new TestDeoptimizeNode());
        }
        nextDeoptIndex = PodFactorySubstitutionMethod.invokeConstructor(kit, method, isDeoptTarget, nextDeoptIndex, targetCtor, instanceLocal);
        kit.createReturn(kit.loadLocal(instanceLocal, JavaKind.Object), JavaKind.Object);
        return kit.finalizeGraph();
    }

    private static int startMethod(HostedGraphKit kit, boolean isDeoptTarget, int nextDeoptIndex) {
        if (!isDeoptTarget) {
            return nextDeoptIndex;
        }
        FrameState initialState = kit.getGraph().start().stateAfter();
        return PodFactorySubstitutionMethod.appendDeoptWithExceptionUnwind(kit, initialState, initialState.bci, nextDeoptIndex);
    }

    private static void instantiatePod(HostedGraphKit kit, HostedProviders providers, ResolvedJavaType factoryType, ResolvedJavaType podConcreteType, int instanceLocal) {
        ResolvedJavaType podType = kit.getMetaAccess().lookupJavaType(Pod.class);
        ValueNode receiver = kit.loadLocal(0, JavaKind.Object);
        ValueNode pod = PodFactorySubstitutionMethod.loadNonNullField(kit, receiver, PodFactorySubstitutionMethod.findField(factoryType, "pod"));
        LoadFieldNode arrayLength = kit.createLoadField(pod, PodFactorySubstitutionMethod.findField(podType, "arrayLength"));
        ValueNode refMap = PodFactorySubstitutionMethod.loadNonNullField(kit, pod, PodFactorySubstitutionMethod.findField(podType, "referenceMap"));
        ConstantNode hub = kit.createConstant(providers.getConstantReflection().asObjectHub(podConcreteType), JavaKind.Object);
        ValueNode instance = kit.append((ValueNode)new NewPodInstanceNode(podConcreteType, (ValueNode)hub, (ValueNode)arrayLength, refMap));
        kit.storeLocal(instanceLocal, JavaKind.Object, instance);
    }

    private static ValueNode loadNonNullField(HostedGraphKit kit, ValueNode object, ResolvedJavaField field) {
        return kit.append(PiNode.create((ValueNode)kit.createLoadField(object, field), (Stamp)StampFactory.objectNonNull()));
    }

    private static int invokeConstructor(HostedGraphKit kit, ResolvedJavaMethod method, boolean isDeoptTarget, int nextDeoptIndex, ResolvedJavaMethod targetCtor, int instanceLocal) {
        ValueNode instance = kit.loadLocal(instanceLocal, JavaKind.Object);
        ValueNode[] originalArgs = kit.loadArguments(method.toParameterTypes()).toArray(ValueNode.EMPTY_ARRAY);
        ValueNode[] invokeArgs = Arrays.copyOf(originalArgs, originalArgs.length);
        invokeArgs[0] = instance;
        return PodFactorySubstitutionMethod.invokeWithDeoptAndExceptionUnwind(kit, isDeoptTarget, nextDeoptIndex, targetCtor, CallTargetNode.InvokeKind.Special, invokeArgs);
    }

    private static int invokeWithDeoptAndExceptionUnwind(HostedGraphKit kit, boolean isDeoptTarget, int initialNextDeoptIndex, ResolvedJavaMethod target, CallTargetNode.InvokeKind invokeKind, ValueNode ... args) {
        int bci = kit.bci();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(target, invokeKind, kit.getFrameState(), bci, args);
        invoke.setNodeSourcePosition(NodeSourcePosition.placeholder((ResolvedJavaMethod)kit.getGraph().method(), (int)bci));
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        if (!isDeoptTarget) {
            kit.append((ValueNode)new UnwindNode((ValueNode)exception));
            kit.endInvokeWithException();
            return initialNextDeoptIndex;
        }
        int nextDeoptIndex = initialNextDeoptIndex;
        DeoptEntryNode exceptionDeopt = (DeoptEntryNode)kit.add((ValueNode)new DeoptEntryNode());
        exceptionDeopt.setStateAfter(exception.stateAfter().duplicate());
        DeoptEntryBeginNode exceptionDeoptBegin = (DeoptEntryBeginNode)kit.add((ValueNode)new DeoptEntryBeginNode());
        int exceptionDeoptIndex = nextDeoptIndex++;
        ValueNode exceptionProxy = PodFactorySubstitutionMethod.createDeoptProxy(kit, exceptionDeoptIndex, (FixedNode)exceptionDeopt, (ValueNode)exception);
        UnwindNode unwind = (UnwindNode)kit.append((ValueNode)new UnwindNode(exceptionProxy));
        exception.setNext((FixedNode)exceptionDeopt);
        exceptionDeopt.setNext(exceptionDeoptBegin);
        exceptionDeoptBegin.setNext((FixedNode)unwind);
        UnreachableBeginNode exceptionDeoptExceptionEdge = (UnreachableBeginNode)kit.add((ValueNode)new UnreachableBeginNode());
        exceptionDeoptExceptionEdge.setNext((FixedNode)kit.add((ValueNode)new LoweredDeadEndNode()));
        exceptionDeopt.setExceptionEdge((AbstractBeginNode)exceptionDeoptExceptionEdge);
        kit.noExceptionPart();
        nextDeoptIndex = PodFactorySubstitutionMethod.appendDeoptWithExceptionUnwind(kit, invoke.stateAfter(), invoke.stateAfter().bci, nextDeoptIndex);
        kit.endInvokeWithException();
        return nextDeoptIndex;
    }

    private static int appendDeoptWithExceptionUnwind(HostedGraphKit kit, FrameState state, int exceptionBci, int nextDeoptIndex) {
        DeoptEntryNode entry = (DeoptEntryNode)kit.add((ValueNode)new DeoptEntryNode());
        entry.setStateAfter(state.duplicate());
        DeoptEntryBeginNode begin = (DeoptEntryBeginNode)kit.append((ValueNode)new DeoptEntryBeginNode());
        ((FixedWithNextNode)begin.predecessor()).setNext((FixedNode)entry);
        entry.setNext(begin);
        ExceptionObjectNode exception = (ExceptionObjectNode)kit.add((ValueNode)new ExceptionObjectNode(kit.getMetaAccess()));
        entry.setExceptionEdge((AbstractBeginNode)exception);
        FrameStateBuilder exState = kit.getFrameState().copy();
        exState.clearStack();
        exState.push(JavaKind.Object, (ValueNode)exception);
        exState.setRethrowException(true);
        exception.setStateAfter(exState.create(exceptionBci, (StateSplit)exception));
        exception.setNext((FixedNode)kit.add((ValueNode)new UnwindNode((ValueNode)exception)));
        kit.getFrameState().insertProxies(value -> PodFactorySubstitutionMethod.createDeoptProxy(kit, nextDeoptIndex, (FixedNode)entry, value));
        return nextDeoptIndex + 1;
    }

    private static ValueNode createDeoptProxy(HostedGraphKit kit, int nextDeoptIndex, FixedNode deoptTarget, ValueNode value) {
        return (ValueNode)kit.getGraph().addOrUniqueWithInputs((Node)DeoptProxyNode.create(value, (ValueNode)deoptTarget, nextDeoptIndex));
    }

    private static boolean parameterTypesMatch(ResolvedJavaMethod method, ResolvedJavaMethod ctor) {
        int paramsCount = method.getSignature().getParameterCount(false);
        if (paramsCount != ctor.getSignature().getParameterCount(false)) {
            return false;
        }
        for (int i = 0; i < paramsCount; ++i) {
            if (ctor.getSignature().getParameterType(i, ctor.getDeclaringClass()).equals(method.getSignature().getParameterType(i, method.getDeclaringClass()))) continue;
            return false;
        }
        return true;
    }

    private static ResolvedJavaField findField(ResolvedJavaType type, String name) {
        for (ResolvedJavaField field : type.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw GraalError.shouldNotReachHere((String)("Required field " + name + " not found in " + type));
    }
}

