/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.annotate.Hybrid;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedType;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public class HybridLayoutSupport {
    @Fold
    public static HybridLayoutSupport singleton() {
        return (HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class);
    }

    public boolean isHybrid(ResolvedJavaType clazz) {
        return clazz.isAnnotationPresent(Hybrid.class);
    }

    public boolean isHybridField(HostedField field) {
        return field.getAnnotation(Hybrid.Array.class) != null || field.getAnnotation(Hybrid.TypeIDSlots.class) != null;
    }

    public boolean canHybridFieldsBeDuplicated(HostedType clazz) {
        assert (this.isHybrid(clazz)) : "Can only be called on hybrid types";
        return ((Hybrid)clazz.getAnnotation(Hybrid.class)).canHybridFieldsBeDuplicated();
    }

    public boolean canInstantiateAsInstance(HostedType clazz) {
        assert (this.isHybrid(clazz)) : "Can only be called on hybrid types";
        return false;
    }

    protected HybridInfo inspectHybrid(HostedInstanceClass hybridClass, MetaAccessProvider metaAccess) {
        HostedType arrayType;
        boolean arrayTypeIsSet;
        Hybrid annotation = (Hybrid)hybridClass.getAnnotation(Hybrid.class);
        assert (annotation != null);
        assert (Modifier.isFinal(hybridClass.getModifiers()));
        HostedField foundArrayField = null;
        HostedField foundTypeIDSlotsField = null;
        for (HostedField field : hybridClass.getInstanceFields(true)) {
            if (field.getAnnotation(Hybrid.Array.class) != null) {
                assert (foundArrayField == null) : "must have at most one hybrid array field";
                foundArrayField = field;
            }
            if (field.getAnnotation(Hybrid.TypeIDSlots.class) == null) continue;
            assert (foundTypeIDSlotsField == null) : "must have at most one typeid slot field";
            assert (field.getType().isArray());
            foundTypeIDSlotsField = field;
        }
        boolean bl = arrayTypeIsSet = annotation.componentType() != Void.TYPE;
        if (foundArrayField != null) {
            arrayType = foundArrayField.getType();
            assert (!arrayTypeIsSet || arrayType.equals(metaAccess.lookupJavaType(annotation.componentType()).getArrayClass())) : "@Hybrid.componentType must match the type of a @Hybrid.Array field when both are present";
        } else {
            assert (arrayTypeIsSet) : "@Hybrid.componentType must be set when no @Hybrid.Array field is present (if present, ensure it is reachable)";
            arrayType = (HostedArrayClass)metaAccess.lookupJavaType(annotation.componentType()).getArrayClass();
        }
        assert (arrayType.isArray());
        return new HybridInfo(arrayType, foundArrayField, foundTypeIDSlotsField);
    }

    public static class HybridInfo {
        public final HostedType arrayType;
        public final HostedField arrayField;
        public final HostedField typeIDSlotsField;

        public HybridInfo(HostedType arrayType, HostedField arrayField, HostedField typeIDSlotsField) {
            this.arrayType = arrayType;
            this.arrayField = arrayField;
            this.typeIDSlotsField = typeIDSlotsField;
        }
    }
}

