/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedDirectCallTrampolineSupport;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.function.Consumer;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;

public class AMD64HostedTrampolineSupport
implements HostedDirectCallTrampolineSupport {
    @Override
    public boolean mayNeedTrampolines() {
        return SubstrateOptions.UseDirectCallTrampolinesALot.getValue();
    }

    @Override
    public int getMaxCallDistance() {
        if (SubstrateOptions.UseDirectCallTrampolinesALot.getValue().booleanValue()) {
            return NumUtil.getNbitNumberInt((int)10);
        }
        throw VMError.shouldNotReachHere("AMD64 currently does not need direct call trampolines");
    }

    @Override
    public int getTrampolineSize() {
        if (SubstrateOptions.UseDirectCallTrampolinesALot.getValue().booleanValue()) {
            return 9;
        }
        throw VMError.shouldNotReachHere("AMD64 currently does not need direct call trampolines");
    }

    @Override
    public int getTrampolineAlignment() {
        if (SubstrateOptions.UseDirectCallTrampolinesALot.getValue().booleanValue()) {
            return 16;
        }
        throw VMError.shouldNotReachHere("AMD64 currently does not need direct call trampolines");
    }

    @Override
    public byte[] createTrampoline(TargetDescription td, HostedMethod target, int trampolineStart) {
        if (!SubstrateOptions.UseDirectCallTrampolinesALot.getValue().booleanValue()) {
            throw VMError.shouldNotReachHere("AMD64 currently does not need direct call trampolines");
        }
        AMD64MacroAssembler masm = new AMD64MacroAssembler(td);
        CompilationResult compilationResult = new CompilationResult("trampoline");
        Consumer<Assembler.CodeAnnotation> consumer = PatchConsumerFactory.HostedPatchConsumerFactory.factory().newConsumer(compilationResult);
        masm.setCodePatchingAnnotationConsumer(consumer);
        masm.cmpl(AMD64.r8, AMD64.r8);
        int jccOffset = masm.position();
        masm.jcc(AMD64Assembler.ConditionFlag.Equal);
        byte[] code = masm.close(true);
        VMError.guarantee(compilationResult.getCodeAnnotations().size() == 1);
        HostedPatcher patcher = (HostedPatcher)compilationResult.getCodeAnnotations().get(0);
        int relativeAddress = target.getCodeAddressOffset() - (trampolineStart + jccOffset);
        patcher.patch(trampolineStart, relativeAddress, code);
        return code;
    }
}

