/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Reference;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;

class MovSequenceHostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64MacroAssembler.MovSequenceAnnotation annotation;

    MovSequenceHostedPatcher(AArch64MacroAssembler.MovSequenceAnnotation annotation) {
        super(annotation.instructionPosition);
        this.annotation = annotation;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        int siteOffset = compStart + this.annotation.instructionPosition;
        if (ref instanceof DataSectionReference || ref instanceof CGlobalDataReference || ref instanceof ConstantReference) {
            if (ref instanceof ConstantReference) assert (!(((ConstantReference)ref).getConstant() instanceof SubstrateMethodPointerConstant));
            int lastMovIndex = -1;
            AArch64MacroAssembler.MovSequenceAnnotation.MovAction[] includeSet = this.annotation.includeSet;
            block5: for (int i = 0; i < includeSet.length; ++i) {
                switch (includeSet[i]) {
                    case USED: {
                        lastMovIndex = i;
                        continue block5;
                    }
                    case SKIPPED: {
                        continue block5;
                    }
                    case NEGATED: {
                        throw VMError.shouldNotReachHere("Negated mov action isn't handled by relocation currently.");
                    }
                }
            }
            ObjectFile.RelocationKind[] relocations = new ObjectFile.RelocationKind[]{ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G0, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G1, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G2, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G3};
            ObjectFile.RelocationKind[] noCheckRelocations = new ObjectFile.RelocationKind[]{ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G0_NC, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G1_NC, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G2_NC};
            for (int i = 0; i < includeSet.length; ++i) {
                if (includeSet[i] == AArch64MacroAssembler.MovSequenceAnnotation.MovAction.SKIPPED) continue;
                if (i == lastMovIndex) {
                    relocs.addRelocationWithoutAddend(siteOffset, relocations[i], ref);
                } else {
                    relocs.addRelocationWithoutAddend(siteOffset, noCheckRelocations[i], ref);
                }
                siteOffset += 4;
            }
        } else {
            throw VMError.shouldNotReachHere("Unknown type of reference in code");
        }
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int compStart, int relative, byte[] code) {
        throw VMError.shouldNotReachHere();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

