/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.svm.hosted.code.UninterruptibleAnnotationChecker;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

public final class CompilationGraph {
    private final EncodedGraph encodedGraph;
    private final int nodeCount;
    private final Set<InvokeInfo> invokeInfos;
    private final Set<AllocationInfo> allocationInfos;

    private CompilationGraph(EncodedGraph encodedGraph, int nodeCount, Set<InvokeInfo> invokeInfos, Set<AllocationInfo> allocationInfos) {
        this.encodedGraph = encodedGraph;
        this.nodeCount = nodeCount;
        this.invokeInfos = invokeInfos;
        this.allocationInfos = allocationInfos;
    }

    static CompilationGraph encode(StructuredGraph graph) {
        HashSet invokeInfos = new HashSet();
        HashSet allocationInfos = new HashSet();
        for (Node n : graph.getNodes()) {
            if (n instanceof MethodCallTargetNode) {
                MethodCallTargetNode node = (MethodCallTargetNode)n;
                invokeInfos.add(new InvokeInfo(node.invokeKind(), (HostedMethod)node.targetMethod(), (HostedMethod)node.invoke().stateAfter().getMethod(), node.getNodeSourcePosition()));
            }
            if (!UninterruptibleAnnotationChecker.isAllocationNode(n)) continue;
            allocationInfos.add(new AllocationInfo(n.getNodeSourcePosition()));
        }
        return new CompilationGraph(GraphEncoder.encodeSingleGraph((StructuredGraph)graph, (Architecture)AnalysisParsedGraph.HOST_ARCHITECTURE), graph.getNodeCount(), invokeInfos.isEmpty() ? Collections.emptySet() : invokeInfos, allocationInfos.isEmpty() ? Collections.emptySet() : allocationInfos);
    }

    public EncodedGraph getEncodedGraph() {
        return this.encodedGraph;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public Set<InvokeInfo> getInvokeInfos() {
        return this.invokeInfos;
    }

    public Set<AllocationInfo> getAllocationInfos() {
        return this.allocationInfos;
    }

    public static class AllocationInfo {
        private final NodeSourcePosition nodeSourcePosition;

        AllocationInfo(NodeSourcePosition nodeSourcePosition) {
            this.nodeSourcePosition = nodeSourcePosition;
        }

        public NodeSourcePosition getNodeSourcePosition() {
            return this.nodeSourcePosition;
        }
    }

    public static class InvokeInfo {
        private final CallTargetNode.InvokeKind invokeKind;
        private final HostedMethod targetMethod;
        private final HostedMethod directCaller;
        private final NodeSourcePosition nodeSourcePosition;

        InvokeInfo(CallTargetNode.InvokeKind invokeKind, HostedMethod targetMethod, HostedMethod directCaller, NodeSourcePosition nodeSourcePosition) {
            this.invokeKind = invokeKind;
            this.targetMethod = targetMethod;
            this.directCaller = directCaller;
            this.nodeSourcePosition = nodeSourcePosition;
        }

        public CallTargetNode.InvokeKind getInvokeKind() {
            return this.invokeKind;
        }

        public HostedMethod getTargetMethod() {
            return this.targetMethod;
        }

        public HostedMethod getDirectCaller() {
            return this.directCaller;
        }

        public NodeSourcePosition getNodeSourcePosition() {
            return this.nodeSourcePosition;
        }
    }
}

