/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.InternalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class FeatureHandler {
    private final ArrayList<Feature> featureInstances = new ArrayList();
    private final HashSet<Class<?>> registeredFeatures = new HashSet();

    public void forEachFeature(Consumer<Feature> consumer) {
        for (Feature feature : this.featureInstances) {
            consumer.accept(feature);
        }
    }

    public void forEachGraalFeature(Consumer<InternalFeature> consumer) {
        for (Feature feature : this.featureInstances) {
            if (!(feature instanceof InternalFeature)) continue;
            consumer.accept((InternalFeature)feature);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerFeatures(ImageClassLoader loader, DebugContext debug) {
        FeatureImpl.IsInConfigurationAccessImpl access = new FeatureImpl.IsInConfigurationAccessImpl(this, loader, debug);
        LinkedHashSet automaticFeatures = new LinkedHashSet(loader.findAnnotatedClasses(AutomaticFeature.class, true));
        HashMap<Class, void> specificAutomaticFeatures = new HashMap<Class, void>();
        Iterator<Object> iterator = automaticFeatures.iterator();
        while (iterator.hasNext()) {
            void var8_8;
            Class automaticFeature;
            Class clazz = automaticFeature = (Class)iterator.next();
            boolean foundMostSpecific = false;
            do {
                List featureSubclasses = loader.findSubclasses(var8_8, true);
                featureSubclasses.remove(var8_8);
                featureSubclasses.removeIf(o -> !automaticFeatures.contains(o));
                if (featureSubclasses.isEmpty()) {
                    foundMostSpecific = true;
                    continue;
                }
                if (featureSubclasses.size() > 1) {
                    String candidates = featureSubclasses.stream().map(Class::getName).collect(Collectors.joining(" "));
                    VMError.shouldNotReachHere("Ambiguous @AutomaticFeature extension. Conflicting candidates: " + candidates);
                }
                Class clazz2 = featureSubclasses.get(0);
            } while (!foundMostSpecific);
            if (var8_8 == automaticFeature) continue;
            specificAutomaticFeatures.put(automaticFeature, var8_8);
        }
        for (Class specific : specificAutomaticFeatures.values()) {
            automaticFeatures.remove(specific);
        }
        Function<Class<?>, Class<?>> specificClassProvider = specificAutomaticFeatures::get;
        for (Class clazz : automaticFeatures) {
            this.registerFeature(clazz, specificClassProvider, access);
        }
        for (String string : Options.userEnabledFeatures()) {
            try {
                this.registerFeature(Class.forName(string, true, loader.getClassLoader()), specificClassProvider, access);
            }
            catch (ClassNotFoundException e) {
                throw UserError.abort("Feature %s class not found on the classpath. Ensure that the name is correct and that the class is on the classpath.", string);
            }
        }
        if (NativeImageOptions.PrintFeatures.getValue().booleanValue()) {
            ReportUtils.report((String)"feature information", (String)SubstrateOptions.reportsPath(), (String)"feature_info", (String)"csv", out -> {
                out.println("Feature, Required Features");
                for (Feature featureInstance : this.featureInstances) {
                    out.print(featureInstance.getClass().getTypeName());
                    String requiredFeaturesString = featureInstance.getRequiredFeatures().stream().map(Class::getTypeName).collect(Collectors.joining(" ", "[", "]"));
                    out.print(", ");
                    out.println(requiredFeaturesString);
                }
            });
        }
    }

    private void registerFeature(Class<?> baseFeatureClass, Function<Class<?>, Class<?>> specificClassProvider, FeatureImpl.IsInConfigurationAccessImpl access) {
        Feature feature;
        if (!Feature.class.isAssignableFrom(baseFeatureClass)) {
            throw UserError.abort("Class does not implement %s: %s", Feature.class.getName(), baseFeatureClass.getName());
        }
        if (this.registeredFeatures.contains(baseFeatureClass)) {
            return;
        }
        this.registeredFeatures.add(baseFeatureClass);
        Class<?> specificClass = specificClassProvider.apply(baseFeatureClass);
        Class<?> featureClass = specificClass != null ? specificClass : baseFeatureClass;
        try {
            feature = (Feature)ReflectionUtil.newInstance(featureClass);
        }
        catch (ReflectionUtil.ReflectionUtilError ex) {
            throw UserError.abort(ex.getCause(), "Error instantiating Feature class %s. Ensure the class is not abstract and has a no-argument constructor.", featureClass.getTypeName());
        }
        if (!feature.isInConfiguration((Feature.IsInConfigurationAccess)access)) {
            return;
        }
        ImageSingletons.add(baseFeatureClass, (Object)feature);
        for (Class requiredFeatureClass : feature.getRequiredFeatures()) {
            this.registerFeature(requiredFeatureClass, specificClassProvider, access);
        }
        this.featureInstances.add(feature);
    }

    public List<Feature> getUserSpecificFeatures() {
        ClassLoaderSupport classLoaderSupport = (ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class);
        List<String> userEnabledFeatures = Options.userEnabledFeatures();
        return this.featureInstances.stream().filter(f -> !(f instanceof InternalFeature && ((InternalFeature)f).isHidden() || !classLoaderSupport.isNativeImageClassLoader(f.getClass().getClassLoader()) && !userEnabledFeatures.contains(f.getClass().getName()))).collect(Collectors.toList());
    }

    public static class Options {
        @APIOption(name={"features"})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> Features = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());

        private static List<String> userEnabledFeatures() {
            return OptionUtils.flatten(",", Features.getValue());
        }
    }
}

