/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.aarch64.AArch64CPUFeatureAccess;
import com.oracle.svm.core.aarch64.AArch64LibCHelper;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.CPUFeatureAccessFeatureBase;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.AARCH64.class})
class AArch64CPUFeatureAccessFeature
extends CPUFeatureAccessFeatureBase
implements Feature {
    AArch64CPUFeatureAccessFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        SubstrateTargetDescription targetDescription = (SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class));
        AArch64 arch = (AArch64)targetDescription.arch;
        EnumSet buildtimeCPUFeatures = arch.getFeatures();
        this.initializeCPUFeatureAccessData((Enum<T>[])AArch64.CPUFeature.values(), buildtimeCPUFeatures, AArch64LibCHelper.CPUFeatures.class, (FeatureImpl.BeforeAnalysisAccessImpl)arg);
    }

    @Override
    protected AArch64CPUFeatureAccess createCPUFeatureAccessSingleton(EnumSet<?> buildtimeCPUFeatures, int[] offsets, byte[] errorMessageBytes, byte[] buildtimeFeatureMaskBytes) {
        return new AArch64CPUFeatureAccess(buildtimeCPUFeatures, offsets, errorMessageBytes, buildtimeFeatureMaskBytes);
    }
}

