/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.windows.headers.ErrHandlingAPI;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class WindowsRegisterDumper
implements RegisterDumper {
    @Override
    public void dumpRegisters(Log log, RegisterDumper.Context context, boolean printLocationInfo, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        WindowsRegisterDumper.dumpRegisters(log, (ErrHandlingAPI.CONTEXT)context, printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
    }

    private static void dumpRegisters(Log log, ErrHandlingAPI.CONTEXT context, boolean printLocationInfo, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        RegisterDumper.dumpReg(log, "RAX ", context.Rax(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RBX ", context.Rbx(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RCX ", context.Rcx(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RDX ", context.Rdx(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RBP ", context.Rbp(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RSI ", context.Rsi(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RDI ", context.Rdi(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RSP ", context.Rsp(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R8  ", context.R8(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R9  ", context.R9(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R10 ", context.R10(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R11 ", context.R11(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R12 ", context.R12(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R13 ", context.R13(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R14 ", context.R14(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R15 ", context.R15(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "EFL ", context.EFlags(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RIP ", context.Rip(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getHeapBase(RegisterDumper.Context context) {
        return WordFactory.pointer((long)((ErrHandlingAPI.CONTEXT)context).R14());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getThreadPointer(RegisterDumper.Context context) {
        return WordFactory.pointer((long)((ErrHandlingAPI.CONTEXT)context).R15());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getSP(RegisterDumper.Context context) {
        return WordFactory.pointer((long)((ErrHandlingAPI.CONTEXT)context).Rsp());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getIP(RegisterDumper.Context context) {
        return WordFactory.pointer((long)((ErrHandlingAPI.CONTEXT)context).Rip());
    }
}

