/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.thread.PlatformThreads;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ThreadGroupThreadsRecomputation
implements RecomputeFieldValue.CustomFieldValueComputer {
    ThreadGroupThreadsRecomputation() {
    }

    @Override
    public RecomputeFieldValue.ValueAvailability valueAvailability() {
        return RecomputeFieldValue.ValueAvailability.BeforeAnalysis;
    }

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        ThreadGroup group = (ThreadGroup)receiver;
        if (group == PlatformThreads.singleton().mainGroup) {
            return PlatformThreads.singleton().mainGroupThreadsArray;
        }
        return null;
    }
}

