/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.thread.JavaThreadsFeature;
import com.oracle.svm.core.thread.PlatformThreads;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ThreadGroupNUnstartedThreadsRecomputation
implements RecomputeFieldValue.CustomFieldValueComputer {
    ThreadGroupNUnstartedThreadsRecomputation() {
    }

    @Override
    public RecomputeFieldValue.ValueAvailability valueAvailability() {
        return RecomputeFieldValue.ValueAvailability.BeforeAnalysis;
    }

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        ThreadGroup group = (ThreadGroup)receiver;
        int result = 0;
        for (Thread thread : JavaThreadsFeature.singleton().reachableThreads.keySet()) {
            if (thread.getThreadGroup() != group || thread == PlatformThreads.singleton().mainThread) continue;
            ++result;
        }
        return result;
    }
}

