/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.reflect.ReflectionAccessorHolder;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import jdk.internal.reflect.MethodAccessor;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.LocationIdentity;

@InternalVMMethod
public final class SubstrateMethodAccessor
extends SubstrateAccessor
implements MethodAccessor {
    public static final int STATICALLY_BOUND = -1;
    public static final int OFFSET_NOT_YET_COMPUTED = -559087615;
    private final Class<?> receiverType;
    int vtableOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateMethodAccessor(Executable member, Class<?> receiverType, CFunctionPointer expandSignature, CFunctionPointer directTarget, int vtableOffset, DynamicHub initializeBeforeInvoke) {
        super(member, expandSignature, directTarget, initializeBeforeInvoke);
        this.receiverType = receiverType;
        this.vtableOffset = vtableOffset;
    }

    private void preInvoke(Object obj) {
        if (this.initializeBeforeInvoke != null) {
            EnsureClassInitializedNode.ensureClassInitialized(DynamicHub.toClass(this.initializeBeforeInvoke));
        }
        if (this.receiverType != null) {
            if (obj == null) {
                throw new NullPointerException();
            }
            if (!this.receiverType.isInstance(obj)) {
                throw new IllegalArgumentException("Receiver type " + obj.getClass().getTypeName() + " is not an instance of the declaring class " + this.receiverType.getTypeName());
            }
        }
    }

    @Override
    public Object invoke(Object obj, Object[] args) {
        this.preInvoke(obj);
        if (this.vtableOffset == -559087615) {
            throw VMError.shouldNotReachHere("Missed vtableOffset recomputation at image build time");
        }
        CFunctionPointer target = this.vtableOffset != -1 ? (CFunctionPointer)BarrieredAccess.readWord(obj.getClass(), (int)this.vtableOffset, (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION) : this.directTarget;
        return ((ReflectionAccessorHolder.MethodInvokeFunctionPointer)this.expandSignature).invoke(obj, args, target);
    }

    public Object invokeSpecial(Object obj, Object[] args) {
        this.preInvoke(obj);
        CFunctionPointer target = this.directTarget;
        if (target.isNull()) {
            throw new IllegalArgumentException("Cannot do invokespecial for an abstract method");
        }
        return ((ReflectionAccessorHolder.MethodInvokeFunctionPointer)this.expandSignature).invoke(obj, args, target);
    }
}

