/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.annotate.Uninterruptible;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public enum JfrFrameType {
    FRAME_AOT_COMPILED("AOT compiled"),
    FRAME_JIT_COMPILED("JIT compiled"),
    FRAME_NATIVE("Native");

    private final String text;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrFrameType(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getId() {
        return this.ordinal();
    }
}

