/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.management.SubstrateClassLoadingMXBean;
import com.oracle.svm.core.jdk.management.SubstrateCompilationMXBean;
import com.oracle.svm.core.jdk.management.SubstrateRuntimeMXBean;
import com.oracle.svm.core.jdk.management.SubstrateThreadMXBean;
import com.oracle.svm.core.jdk.management.Target_com_sun_management_internal_OperatingSystemImpl;
import com.oracle.svm.core.jdk.management.Target_sun_management_BaseOperatingSystemImpl;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.sun.management.ThreadMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import javax.management.StandardMBean;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

public final class ManagementSupport
implements ThreadListener {
    final Map<Class<?>, Object> platformManagedObjectsMap = new HashMap();
    final Set<PlatformManagedObject> platformManagedObjectsSet = Collections.newSetFromMap(new IdentityHashMap());
    private final SubstrateClassLoadingMXBean classLoadingMXBean = new SubstrateClassLoadingMXBean();
    private final SubstrateCompilationMXBean compilationMXBean = new SubstrateCompilationMXBean();
    private final SubstrateRuntimeMXBean runtimeMXBean = new SubstrateRuntimeMXBean();
    private final SubstrateThreadMXBean threadMXBean = new SubstrateThreadMXBean();
    private OperatingSystemMXBean osMXBean;
    MBeanServer platformMBeanServer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ManagementSupport() {
        this.addPlatformManagedObjectSingleton(ClassLoadingMXBean.class, this.classLoadingMXBean);
        this.addPlatformManagedObjectSingleton(CompilationMXBean.class, this.compilationMXBean);
        this.addPlatformManagedObjectSingleton(RuntimeMXBean.class, this.runtimeMXBean);
        this.addPlatformManagedObjectSingleton(ThreadMXBean.class, this.threadMXBean);
        this.addPlatformManagedObjectList(MemoryPoolMXBean.class, Collections.emptyList());
        this.addPlatformManagedObjectList(BufferPoolMXBean.class, Collections.emptyList());
        this.doAddPlatformManagedObjectSingleton(ManagementSupport.getOsMXBeanInterface(), this::getOsMXBean);
    }

    private static Class<?> getOsMXBeanInterface() {
        if (Platform.includedIn(InternalPlatform.PLATFORM_JNI.class)) {
            return Platform.includedIn(Platform.WINDOWS.class) ? com.sun.management.OperatingSystemMXBean.class : UnixOperatingSystemMXBean.class;
        }
        return OperatingSystemMXBean.class;
    }

    private synchronized OperatingSystemMXBean getOsMXBean() {
        if (this.osMXBean == null) {
            Object osMXBeanImpl = Platform.includedIn(InternalPlatform.PLATFORM_JNI.class) ? new Target_com_sun_management_internal_OperatingSystemImpl(null) : new Target_sun_management_BaseOperatingSystemImpl(null);
            this.osMXBean = SubstrateUtil.cast(osMXBeanImpl, OperatingSystemMXBean.class);
        }
        return this.osMXBean;
    }

    @Fold
    public static ManagementSupport getSingleton() {
        return (ManagementSupport)ImageSingletons.lookup(ManagementSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public <T extends PlatformManagedObject> void addPlatformManagedObjectSingleton(Class<T> clazz, T object) {
        if (!clazz.isInterface()) {
            throw UserError.abort("Key for registration of a PlatformManagedObject must be an interface", new Object[0]);
        }
        this.doAddPlatformManagedObjectSingleton(clazz, object);
    }

    private void doAddPlatformManagedObjectSingleton(Class<?> clazz, PlatformManagedObject object) {
        for (Class<?> superinterface : clazz.getInterfaces()) {
            if (superinterface == PlatformManagedObject.class || !PlatformManagedObject.class.isAssignableFrom(superinterface)) continue;
            this.doAddPlatformManagedObjectSingleton(superinterface, object);
        }
        Object existing = this.platformManagedObjectsMap.get(clazz);
        if (existing != null) {
            throw UserError.abort("PlatformManagedObject already registered: %s", clazz.getName());
        }
        this.platformManagedObjectsMap.put(clazz, object);
        this.platformManagedObjectsSet.add(object);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public <T extends PlatformManagedObject> void addPlatformManagedObjectList(Class<T> clazz, List<T> objects) {
        if (!clazz.isInterface()) {
            throw UserError.abort("Key for registration of a PlatformManagedObject must be an interface", new Object[0]);
        }
        this.doAddPlatformManagedObjectList(clazz, objects);
    }

    private void doAddPlatformManagedObjectList(Class<?> clazz, List<? extends PlatformManagedObject> objects) {
        for (Class<?> superinterface : clazz.getInterfaces()) {
            if (superinterface == PlatformManagedObject.class || !PlatformManagedObject.class.isAssignableFrom(superinterface)) continue;
            this.doAddPlatformManagedObjectList(superinterface, objects);
        }
        Object existing = this.platformManagedObjectsMap.get(clazz);
        if (existing instanceof PlatformManagedObject) {
            throw UserError.abort("PlatformManagedObject already registered as a singleton: %s", clazz.getName());
        }
        ArrayList<? extends PlatformManagedObject> newList = new ArrayList<PlatformManagedObject>();
        if (existing != null) {
            newList.addAll((List)existing);
        }
        newList.addAll(objects);
        newList.trimToSize();
        this.platformManagedObjectsMap.put(clazz, Collections.unmodifiableList(newList));
        this.platformManagedObjectsSet.addAll(objects);
    }

    public boolean isAllowedPlatformManagedObject(PlatformManagedObject object) {
        if (this.platformManagedObjectsSet.contains(object)) {
            return true;
        }
        for (Class<? extends PlatformManagedObject> interf : ManagementFactory.getPlatformManagementInterfaces()) {
            if (!interf.isInstance(object) || !ManagementFactory.getPlatformMXBeans(interf).contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void beforeThreadRun(IsolateThread isolateThread, Thread javaThread) {
        this.threadMXBean.noteThreadStart(javaThread);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void afterThreadExit(IsolateThread isolateThread, Thread javaThread) {
        this.threadMXBean.noteThreadFinish(javaThread);
    }

    synchronized MBeanServer getPlatformMBeanServer() {
        if (this.platformMBeanServer == null) {
            this.platformMBeanServer = MBeanServerFactory.createMBeanServer();
            for (PlatformManagedObject platformManagedObject : this.platformManagedObjectsSet) {
                ManagementSupport.addMXBean(this.platformMBeanServer, ManagementSupport.handleLazyPlatformManagedObjectSingleton(platformManagedObject));
            }
        }
        return this.platformMBeanServer;
    }

    private static void addMXBean(MBeanServer mbs, PlatformManagedObject pmo) {
        ObjectName oname = pmo.getObjectName();
        DynamicMBean dmbean = pmo instanceof DynamicMBean ? (DynamicMBean)DynamicMBean.class.cast(pmo) : (pmo instanceof NotificationEmitter ? new StandardEmitterMBean(pmo, null, true, (NotificationEmitter)((Object)pmo)) : new StandardMBean(pmo, null, true));
        try {
            mbs.registerMBean(dmbean, oname);
        }
        catch (JMException ex) {
            throw new RuntimeException(ex);
        }
    }

    Set<Class<?>> getPlatformManagementInterfaces() {
        return Collections.unmodifiableSet(this.platformManagedObjectsMap.keySet());
    }

    <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> mxbeanInterface) {
        Object result = this.platformManagedObjectsMap.get(mxbeanInterface);
        if (result == null) {
            throw new IllegalArgumentException(mxbeanInterface.getName() + " is not a platform management interface");
        }
        if (result instanceof List) {
            throw new IllegalArgumentException(mxbeanInterface.getName() + " can have more than one instance");
        }
        return (T)((PlatformManagedObject)mxbeanInterface.cast(ManagementSupport.handleLazyPlatformManagedObjectSingleton(result)));
    }

    <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> mxbeanInterface) {
        Object result = this.platformManagedObjectsMap.get(mxbeanInterface);
        if (result == null) {
            throw new IllegalArgumentException(mxbeanInterface.getName() + " is not a platform management interface");
        }
        if (result instanceof List) {
            return (List)result;
        }
        return Collections.singletonList((PlatformManagedObject)mxbeanInterface.cast(ManagementSupport.handleLazyPlatformManagedObjectSingleton(result)));
    }

    private static PlatformManagedObject handleLazyPlatformManagedObjectSingleton(Object object) {
        assert (object instanceof PlatformManagedObject);
        return object instanceof PlatformManagedObjectSupplier ? (PlatformManagedObject)((PlatformManagedObjectSupplier)object).get() : (PlatformManagedObject)object;
    }

    private static interface PlatformManagedObjectSupplier
    extends Supplier<PlatformManagedObject>,
    PlatformManagedObject {
        @Override
        default public ObjectName getObjectName() {
            throw VMError.shouldNotReachHere();
        }
    }
}

