/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.jdk.AccessControllerUtil;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.PrivilegedStack;
import com.oracle.svm.core.jdk.StackAccessControlContextVisitor;
import com.oracle.svm.core.jdk.Target_jdk_internal_reflect_Reflection;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.util.VMError;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

@TargetClass(value=AccessController.class)
final class Target_java_security_AccessController {
    Target_java_security_AccessController() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    public static <T> T doPrivileged(PrivilegedAction<T> action) throws Throwable {
        return Target_java_security_AccessController.executePrivileged(action, null, Target_jdk_internal_reflect_Reflection.getCallerClass());
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) throws Throwable {
        Class<?> caller = Target_jdk_internal_reflect_Reflection.getCallerClass();
        AccessControlContext acc = Target_java_security_AccessController.checkContext(context, caller);
        return Target_java_security_AccessController.executePrivileged(action, acc, caller);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws Throwable {
        Class<?> caller = Target_jdk_internal_reflect_Reflection.getCallerClass();
        return Target_java_security_AccessController.executePrivileged(action, null, caller);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context) throws Throwable {
        Class<?> caller = Target_jdk_internal_reflect_Reflection.getCallerClass();
        AccessControlContext acc = Target_java_security_AccessController.checkContext(context, caller);
        return Target_java_security_AccessController.executePrivileged(action, acc, caller);
    }

    @Substitute
    static AccessControlContext getStackAccessControlContext() {
        if (!CEntryPointSnippets.isIsolateInitialized()) {
            return null;
        }
        return StackAccessControlContextVisitor.getFromStack();
    }

    @Substitute
    static AccessControlContext getInheritedAccessControlContext() {
        return SubstrateUtil.cast((Object)Thread.currentThread(), Target_java_lang_Thread.class).inheritedAccessControlContext;
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static ProtectionDomain getProtectionDomain(Class<?> caller) {
        return caller.getProtectionDomain();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    static <T> T executePrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context, Class<?> caller) throws Throwable {
        if (action == null) {
            throw new NullPointerException("Null action");
        }
        PrivilegedStack.push(context, caller);
        try {
            T t = action.run();
            return t;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (JavaVersionUtil.JAVA_SPEC > 11) {
                throw ex;
            }
            throw new PrivilegedActionException(ex);
        }
        finally {
            PrivilegedStack.pop();
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    static <T> T executePrivileged(PrivilegedAction<T> action, AccessControlContext context, Class<?> caller) throws Throwable {
        if (action == null) {
            throw new NullPointerException("Null action");
        }
        PrivilegedStack.push(context, caller);
        try {
            T t = action.run();
            return t;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (JavaVersionUtil.JAVA_SPEC > 11) {
                throw ex;
            }
            throw new PrivilegedActionException(ex);
        }
        finally {
            PrivilegedStack.pop();
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    static AccessControlContext checkContext(AccessControlContext context, Class<?> caller) {
        if (context != null && context.equals(AccessControllerUtil.DISALLOWED_CONTEXT_MARKER)) {
            VMError.shouldNotReachHere("Non-allowed AccessControlContext that was replaced with a blank one at build time was invoked without being reinitialized at run time.\nThis might be an indicator of improper build time initialization, or of a non-compatible JDK version.\nIn order to fix this you can either:\n    * Annotate the offending context's field with @RecomputeFieldValue\n    * Implement a custom runtime accessor and annotate said field with @InjectAccessors\n    * If this context originates from the JDK, and it doesn't leak sensitive info, you can allow it in 'AccessControlContextReplacerFeature.duringSetup'");
        }
        if (System.getSecurityManager() != null) {
            throw VMError.unsupportedFeature("SecurityManager isn't supported");
        }
        return context;
    }
}

