/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.amd64;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.amd64.AMD64ArithmeticSnippets;
import com.oracle.svm.core.graal.snippets.amd64.AMD64NonSnippetLowerings;
import com.oracle.svm.core.graal.snippets.amd64.PosixAMD64VaListSnippets;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticFeature
@Platforms(value={Platform.AMD64.class})
class AMD64SnippetsFeature
implements InternalFeature {
    AMD64SnippetsFeature() {
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        Predicate<ResolvedJavaMethod> mustNotAllocatePredicate = null;
        if (hosted) {
            mustNotAllocatePredicate = method -> ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate((ResolvedJavaMethod)method);
        }
        AMD64ArithmeticSnippets.registerLowerings(options, providers, lowerings);
        AMD64NonSnippetLowerings.registerLowerings(runtimeConfig, mustNotAllocatePredicate, options, providers, lowerings);
        PosixAMD64VaListSnippets.registerLowerings(options, providers, lowerings);
    }
}

