/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class StackOverflowCheckImpl
implements StackOverflowCheck {
    public static final FastThreadLocalWord<UnsignedWord> stackBoundaryTL = (FastThreadLocalWord)FastThreadLocalFactory.createWord("StackOverflowCheckImpl.stackBoundaryTL").setMaxOffset(63);
    static final FastThreadLocalInt yellowZoneStateTL = FastThreadLocalFactory.createInt("StackOverflowCheckImpl.yellowZoneStateTL");
    static final int STATE_UNINITIALIZED = 0;
    static final int STATE_YELLOW_ENABLED = 1;
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_STACK_OVERFLOW_ERROR = SnippetRuntime.findForeignCall(StackOverflowCheckImpl.class, "throwCachedStackOverflowError", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_STACK_OVERFLOW_ERROR = SnippetRuntime.findForeignCall(StackOverflowCheckImpl.class, "throwNewStackOverflowError", true, new LocationIdentity[0]);
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{THROW_CACHED_STACK_OVERFLOW_ERROR, THROW_NEW_STACK_OVERFLOW_ERROR};

    @Override
    @Uninterruptible(reason="Called while thread is being attached to the VM, i.e., when the thread state is not yet set up.")
    public void initialize(IsolateThread thread) {
        StackOverflowCheck.OSSupport osSupport = (StackOverflowCheck.OSSupport)ImageSingletons.lookup(StackOverflowCheck.OSSupport.class);
        UnsignedWord stackBase = osSupport.lookupStackBase();
        UnsignedWord stackEnd = osSupport.lookupStackEnd();
        VMThreads.StackBase.set(thread, stackBase);
        VMThreads.StackEnd.set(thread, stackEnd);
        stackBoundaryTL.set(thread, stackEnd.add(StackOverflowCheck.Options.StackYellowZoneSize.getValue() + StackOverflowCheck.Options.StackRedZoneSize.getValue()));
        yellowZoneStateTL.set(thread, 1);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isWithinBounds(UnsignedWord address) {
        return stackBoundaryTL.get().belowOrEqual(address) && VMThreads.StackBase.get().aboveOrEqual(address);
    }

    @Override
    public int getState() {
        return yellowZoneStateTL.get();
    }

    @Override
    @Uninterruptible(reason="Atomically manipulating state of multiple thread local variables.")
    public void setState(int newState) {
        int oldState = yellowZoneStateTL.get();
        yellowZoneStateTL.set(newState);
        if (newState > oldState) {
            StackOverflowCheckImpl.onYellowZoneMadeAvailable(oldState, newState);
        } else if (newState < oldState) {
            StackOverflowCheckImpl.onYellowZoneProtected(oldState, newState);
        }
    }

    @Override
    @Uninterruptible(reason="Atomically manipulating state of multiple thread local variables.")
    public void makeYellowZoneAvailable() {
        int oldState = yellowZoneStateTL.get();
        int newState = oldState + 1;
        yellowZoneStateTL.set(newState);
        StackOverflowCheckImpl.onYellowZoneMadeAvailable(oldState, newState);
    }

    @Uninterruptible(reason="Atomically manipulating state of multiple thread local variables.")
    private static void onYellowZoneMadeAvailable(int oldState, int newState) {
        VMError.guarantee(newState > oldState && newState > 1, "StackOverflowCheckImpl.onYellowZoneMadeAvailable: Illegal state");
        if (oldState == 1) {
            ThreadingSupportImpl.pauseRecurringCallback("Recurring callbacks are considered user code and must not run in yellow zone");
            stackBoundaryTL.set(stackBoundaryTL.get().subtract(StackOverflowCheck.Options.StackYellowZoneSize.getValue().intValue()));
        }
        UnsignedWord stackBoundary = stackBoundaryTL.get();
        if (KnownIntrinsics.readStackPointer().belowOrEqual(stackBoundary)) {
            throw VMError.shouldNotReachHere("StackOverflowError: Enabling the yellow zone of the stack did not make any stack space available. Possible reasons for that: 1) A call from native code to Java code provided the wrong JNI environment or the wrong IsolateThread; 2) Frames of native code filled the stack, and now there is not even enough stack space left to throw a regular StackOverflowError; 3) An internal VM error occurred.");
        }
    }

    @Override
    public boolean isYellowZoneAvailable() {
        return yellowZoneStateTL.get() > 1;
    }

    @Override
    @Uninterruptible(reason="Atomically manipulating state of multiple thread local variables.")
    public void protectYellowZone() {
        int oldState = yellowZoneStateTL.get();
        int newState = oldState - 1;
        yellowZoneStateTL.set(newState);
        StackOverflowCheckImpl.onYellowZoneProtected(oldState, newState);
    }

    @Uninterruptible(reason="Atomically manipulating state of multiple thread local variables.")
    private static void onYellowZoneProtected(int oldState, int newState) {
        VMError.guarantee(newState < oldState && newState >= 1, "StackOverflowCheckImpl.onYellowZoneProtected: Illegal state");
        if (newState == 1) {
            ThreadingSupportImpl.resumeRecurringCallbackAtNextSafepoint();
            stackBoundaryTL.set(stackBoundaryTL.get().add(StackOverflowCheck.Options.StackYellowZoneSize.getValue().intValue()));
        }
    }

    @Override
    public int yellowAndRedZoneSize() {
        return StackOverflowCheck.Options.StackYellowZoneSize.getValue() + StackOverflowCheck.Options.StackRedZoneSize.getValue();
    }

    @Override
    @Uninterruptible(reason="Called by fatal error handling that is uninterruptible.")
    public void disableStackOverflowChecksForFatalError() {
        stackBoundaryTL.set(WordFactory.unsigned((int)1));
        yellowZoneStateTL.set(0x7EFEFEFE);
    }

    @Uninterruptible(reason="Atomically manipulating state of multiple thread local variables.")
    private static void updateStackOverflowBoundary(long requestedSize) {
        UnsignedWord stackEnd = ((StackOverflowCheck.OSSupport)ImageSingletons.lookup(StackOverflowCheck.OSSupport.class)).lookupStackEnd(WordFactory.unsigned((long)requestedSize));
        VMThreads.StackEnd.set(stackEnd);
        stackBoundaryTL.set(stackEnd.add(StackOverflowCheck.Options.StackYellowZoneSize.getValue() + StackOverflowCheck.Options.StackRedZoneSize.getValue()));
        yellowZoneStateTL.set(1);
    }

    @Override
    public void updateStackOverflowBoundary() {
        long threadSize = PlatformThreads.getRequestedStackSize(Thread.currentThread());
        if (threadSize != 0L) {
            StackOverflowCheckImpl.updateStackOverflowBoundary(threadSize);
        }
    }

    @Override
    public UnsignedWord getStackOverflowBoundary() {
        return stackBoundaryTL.get();
    }

    @Uninterruptible(reason="Must not have a stack overflow check: we are here because the stack overflow check failed.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedStackOverflowError() {
        VMError.guarantee(yellowZoneStateTL.get() != 0, "Stack boundary for the current thread not yet initialized. Only uninterruptible code with no stack overflow checks can run at this point.");
        throw ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR;
    }

    @Uninterruptible(reason="Must not have a stack overflow check: we are here because the stack overflow check failed.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewStackOverflowError() {
        StackOverflowError error;
        int state = yellowZoneStateTL.get();
        VMError.guarantee(state != 0, "Stack boundary for the current thread not yet initialized. Only uninterruptible code with no stack overflow checks can run at this point.");
        if (state > 1 || Heap.getHeap().isAllocationDisallowed()) {
            error = ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR;
        } else {
            try {
                StackOverflowCheck.singleton().makeYellowZoneAvailable();
                error = StackOverflowCheckImpl.newStackOverflowError();
            }
            finally {
                StackOverflowCheck.singleton().protectYellowZone();
            }
        }
        throw error;
    }

    @Uninterruptible(reason="Allow allocation now that yellow zone is available for new stack frames", calleeMustBe=false)
    @RestrictHeapAccess(reason="Allow allocation now that yellow zone is available for new stack frames", access=RestrictHeapAccess.Access.UNRESTRICTED)
    private static StackOverflowError newStackOverflowError() {
        return StackOverflowCheckImpl.newStackOverflowError0();
    }

    private static StackOverflowError newStackOverflowError0() {
        return new StackOverflowError();
    }

    public static boolean needStackOverflowCheck(SharedMethod method) {
        return !Uninterruptible.Utils.isUninterruptible((AnnotatedElement)((Object)method));
    }

    public static long computeDeoptFrameSize(StructuredGraph graph) {
        long deoptFrameSize = 0L;
        if (ImageInfo.inImageRuntimeCode()) {
            NodeMap deoptFrameSizeCache = new NodeMap((Graph)graph);
            for (FrameState state : graph.getNodes(FrameState.TYPE)) {
                deoptFrameSize = Math.max(deoptFrameSize, StackOverflowCheckImpl.computeDeoptFrameSize(state, (NodeMap<Long>)deoptFrameSizeCache));
            }
        }
        return deoptFrameSize;
    }

    private static long computeDeoptFrameSize(FrameState state, NodeMap<Long> deoptFrameSizeCache) {
        Long existing = (Long)deoptFrameSizeCache.get((Node)state);
        if (existing != null) {
            return existing;
        }
        long outerFrameSize = state.outerFrameState() == null ? 0L : StackOverflowCheckImpl.computeDeoptFrameSize(state.outerFrameState(), deoptFrameSizeCache);
        long myFrameSize = CodeInfoAccess.lookupTotalFrameSize(CodeInfoTable.getImageCodeInfo(), ((SharedMethod)state.getMethod()).getDeoptOffsetInImage());
        long result = outerFrameSize + myFrameSize;
        deoptFrameSizeCache.put((Node)state, (Object)result);
        return result;
    }
}

