/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JSONParserException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class SerializationConfigurationParser
extends ConfigurationParser {
    public static final String NAME_KEY = "name";
    public static final String CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY = "customTargetConstructorClass";
    private static final String SERIALIZATION_TYPES_KEY = "types";
    private static final String LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY = "lambdaCapturingTypes";
    private final RuntimeSerializationSupport serializationSupport;

    public SerializationConfigurationParser(RuntimeSerializationSupport serializationSupport, boolean strictConfiguration) {
        super(strictConfiguration);
        this.serializationSupport = serializationSupport;
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        if (json instanceof List) {
            this.parseOldConfiguration(SerializationConfigurationParser.asList(json, "first level of document must be an array of serialization lists"));
        } else if (json instanceof Map) {
            this.parseNewConfiguration(SerializationConfigurationParser.asMap(json, "first level of document must be a map of serialization types"));
        } else {
            throw new JSONParserException("first level of document must either be an array of serialization lists or a map of serialization types");
        }
    }

    private void parseOldConfiguration(List<Object> listOfSerializationConfigurationObjects) {
        this.parseSerializationTypes(SerializationConfigurationParser.asList(listOfSerializationConfigurationObjects, "second level of document must be serialization descriptor objects"), false);
    }

    private void parseNewConfiguration(Map<String, Object> listOfSerializationConfigurationObjects) {
        if (!listOfSerializationConfigurationObjects.containsKey(SERIALIZATION_TYPES_KEY) || !listOfSerializationConfigurationObjects.containsKey(LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY)) {
            throw new JSONParserException("second level of document must be arrays of serialization descriptor objects");
        }
        this.parseSerializationTypes(SerializationConfigurationParser.asList(listOfSerializationConfigurationObjects.get(SERIALIZATION_TYPES_KEY), "types must be an array of serialization descriptor objects"), false);
        this.parseSerializationTypes(SerializationConfigurationParser.asList(listOfSerializationConfigurationObjects.get(LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY), "lambdaCapturingTypes must be an array of serialization descriptor objects"), true);
    }

    private void parseSerializationTypes(List<Object> listOfSerializationTypes, boolean lambdaCapturingTypes) {
        for (Object serializationType : listOfSerializationTypes) {
            this.parseSerializationDescriptorObject(SerializationConfigurationParser.asMap(serializationType, "third level of document must be serialization descriptor objects"), lambdaCapturingTypes);
        }
    }

    private void parseSerializationDescriptorObject(Map<String, Object> data, boolean lambdaCapturingType) {
        if (lambdaCapturingType) {
            this.checkAttributes(data, "serialization descriptor object", Collections.singleton(NAME_KEY), Collections.singleton("condition"));
        } else {
            this.checkAttributes(data, "serialization descriptor object", Collections.singleton(NAME_KEY), Arrays.asList(CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY, "condition"));
        }
        ConfigurationCondition unresolvedCondition = this.parseCondition(data);
        String targetSerializationClass = SerializationConfigurationParser.asString(data.get(NAME_KEY));
        if (lambdaCapturingType) {
            this.serializationSupport.registerLambdaCapturingClass(unresolvedCondition, targetSerializationClass);
        } else {
            Object optionalCustomCtorValue = data.get(CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY);
            String customTargetConstructorClass = optionalCustomCtorValue != null ? SerializationConfigurationParser.asString(optionalCustomCtorValue) : null;
            this.serializationSupport.registerWithTargetConstructorClass(unresolvedCondition, targetSerializationClass, customTargetConstructorClass);
        }
    }
}

