/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoHistory;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.Counter;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class RuntimeCodeCache {
    private final Counter.Group counters = new Counter.Group(CodeInfoTable.Options.CodeCacheCounters, "RuntimeCodeInfo");
    private final Counter lookupMethodCount = new Counter(this.counters, "lookupMethod", "");
    private final Counter addMethodCount = new Counter(this.counters, "addMethod", "");
    private final Counter invalidateMethodCount = new Counter(this.counters, "invalidateMethod", "");
    private final CodeNotOnStackVerifier codeNotOnStackVerifier = new CodeNotOnStackVerifier();
    private static final int INITIAL_TABLE_SIZE = 100;
    private NonmovableArray<UntetheredCodeInfo> codeInfos;
    private int numCodeInfos;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeCodeCache() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void tearDown() {
        NonmovableArrays.releaseUnmanagedArray(this.codeInfos);
        this.codeInfos = NonmovableArrays.nullArray();
        this.numCodeInfos = 0;
        RuntimeCodeInfoMemory.singleton().tearDown();
    }

    @Uninterruptible(reason="codeInfos is accessed without holding a lock, so must not be interrupted by a safepoint that can add/remove code", callerMustBe=true)
    protected UntetheredCodeInfo lookupCodeInfo(CodePointer ip) {
        this.lookupMethodCount.inc();
        assert (this.verifyTable());
        if (this.numCodeInfos == 0) {
            return (UntetheredCodeInfo)WordFactory.nullPointer();
        }
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, ip);
        if (idx >= 0) {
            return NonmovableArrays.getWord(this.codeInfos, idx);
        }
        int insertionPoint = -idx - 1;
        if (insertionPoint == 0) {
            assert (((UnsignedWord)ip).belowThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, 0))));
            return (UntetheredCodeInfo)WordFactory.nullPointer();
        }
        UntetheredCodeInfo info = NonmovableArrays.getWord(this.codeInfos, insertionPoint - 1);
        assert (((UnsignedWord)ip).aboveThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info)));
        if (((UnsignedWord)ip).subtract((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info)).aboveOrEqual(UntetheredCodeInfoAccess.getCodeSize(info))) {
            return (UntetheredCodeInfo)WordFactory.nullPointer();
        }
        return info;
    }

    @Uninterruptible(reason="called from uninterruptible code")
    private static int binarySearch(NonmovableArray<UntetheredCodeInfo> a, int fromIndex, int toIndex, CodePointer key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CodePointer midVal = UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(a, mid));
            if (((UnsignedWord)midVal).belowThan((UnsignedWord)key)) {
                low = mid + 1;
                continue;
            }
            if (((UnsignedWord)midVal).aboveThan((UnsignedWord)key)) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void addMethod(CodeInfo info) {
        assert (VMOperation.isInProgressAtSafepoint());
        InstalledCodeObserverSupport.activateObservers(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        this.addMethod0(info);
        RuntimeCodeInfoHistory.singleton().logAdd(info);
    }

    @Uninterruptible(reason="Modifying code tables that are used by the GC")
    private void addMethod0(CodeInfo info) {
        this.addMethodCount.inc();
        assert (this.verifyTable());
        if (this.codeInfos.isNull() || this.numCodeInfos >= NonmovableArrays.lengthOf(this.codeInfos)) {
            this.enlargeTable();
            assert (this.verifyTable());
        }
        assert (this.numCodeInfos < NonmovableArrays.lengthOf(this.codeInfos));
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, CodeInfoAccess.getCodeStart(info));
        assert (idx < 0) : "must not find code already in table";
        int insertionPoint = -idx - 1;
        NonmovableArrays.arraycopy(this.codeInfos, insertionPoint, this.codeInfos, insertionPoint + 1, this.numCodeInfos - insertionPoint);
        ++this.numCodeInfos;
        NonmovableArrays.setWord(this.codeInfos, insertionPoint, info);
        assert (this.verifyTable());
    }

    @Uninterruptible(reason="Modifying code tables that are used by the GC")
    private void enlargeTable() {
        int newTableSize = this.numCodeInfos * 2;
        if (newTableSize < 100) {
            newTableSize = 100;
        }
        NonmovableArray newCodeInfos = NonmovableArrays.createWordArray(newTableSize);
        if (this.codeInfos.isNonNull()) {
            NonmovableArrays.arraycopy(this.codeInfos, 0, newCodeInfos, 0, NonmovableArrays.lengthOf(this.codeInfos));
            NonmovableArrays.releaseUnmanagedArray(this.codeInfos);
        }
        this.codeInfos = newCodeInfos;
    }

    protected void invalidateMethod(CodeInfo info) {
        assert (VMOperation.isInProgressAtSafepoint());
        this.prepareInvalidation(info);
        Deoptimizer.deoptimizeInRange(CodeInfoAccess.getCodeStart(info), CodeInfoAccess.getCodeEnd(info), false);
        this.finishInvalidation(info, true);
    }

    protected void invalidateNonStackMethod(CodeInfo info) {
        assert (VMOperation.isGCInProgress()) : "may only be called by the GC";
        this.prepareInvalidation(info);
        assert (this.codeNotOnStackVerifier.verify(info));
        this.finishInvalidation(info, false);
    }

    private void prepareInvalidation(CodeInfo info) {
        this.invalidateMethodCount.inc();
        assert (this.verifyTable());
        SubstrateInstalledCode installedCode = RuntimeCodeInfoAccess.getInstalledCode(info);
        if (installedCode != null) {
            assert (!installedCode.isAlive() || CodeInfoAccess.getCodeStart(info).rawValue() == installedCode.getAddress());
            installedCode.clearAddress();
        }
    }

    private void finishInvalidation(CodeInfo info, boolean notifyGC) {
        InstalledCodeObserverSupport.removeObservers(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        this.finishInvalidation0(info, notifyGC);
        RuntimeCodeInfoHistory.singleton().logInvalidate(info);
    }

    @Uninterruptible(reason="Modifying code tables that are used by the GC")
    private void finishInvalidation0(CodeInfo info, boolean notifyGC) {
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, CodeInfoAccess.getCodeStart(info));
        assert (idx >= 0) : "info must be in table";
        NonmovableArrays.arraycopy(this.codeInfos, idx + 1, this.codeInfos, idx, this.numCodeInfos - (idx + 1));
        --this.numCodeInfos;
        NonmovableArrays.setWord(this.codeInfos, this.numCodeInfos, (UntetheredCodeInfo)WordFactory.nullPointer());
        RuntimeCodeInfoAccess.freePartially(info, notifyGC);
        assert (this.verifyTable());
    }

    @Uninterruptible(reason="called from uninterruptible code")
    private boolean verifyTable() {
        int i;
        if (this.codeInfos.isNull()) {
            assert (this.numCodeInfos == 0) : "a1";
            return true;
        }
        assert (this.numCodeInfos <= NonmovableArrays.lengthOf(this.codeInfos)) : "a11";
        for (i = 0; i < this.numCodeInfos; ++i) {
            UntetheredCodeInfo info = NonmovableArrays.getWord(this.codeInfos, i);
            assert (info.isNonNull()) : "a20";
            assert (i == 0 || ((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, i - 1))).belowThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, i)))) : "a22";
            assert (i == 0 || ((UnsignedWord)UntetheredCodeInfoAccess.getCodeEnd(NonmovableArrays.getWord(this.codeInfos, i - 1))).belowOrEqual((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info))) : "a23";
        }
        for (i = this.numCodeInfos; i < NonmovableArrays.lengthOf(this.codeInfos); ++i) {
            assert (NonmovableArrays.getWord(this.codeInfos, i).isNull()) : "a31";
        }
        return true;
    }

    public static interface CodeInfoVisitor {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting code.")
        public <T extends CodeInfo> boolean visitCode(T var1);
    }

    private static final class CodeNotOnStackVerifier
    extends StackFrameVisitor {
        private CodeInfo codeInfoToCheck;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        CodeNotOnStackVerifier() {
        }

        @NeverInline(value="Starting a stack walk.")
        public boolean verify(CodeInfo info) {
            this.codeInfoToCheck = info;
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            JavaStackWalker.walkCurrentThread(sp, this);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread()) {
                        JavaStackWalker.walkThread(vmThread, this);
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
            return true;
        }

        @Override
        public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo currentCodeInfo, DeoptimizedFrame deoptimizedFrame) {
            assert (currentCodeInfo != this.codeInfoToCheck);
            return true;
        }
    }

    public static class Options {
        public static final RuntimeOptionKey<Boolean> TraceCodeCache = new RuntimeOptionKey<Boolean>(false, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Boolean> WriteableCodeCache = new RuntimeOptionKey<Boolean>(false, RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
    }
}

