/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.amd64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.AMD64.class})
public final class AMD64FrameAccess
extends FrameAccess {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer readReturnAddress(Pointer sourceSp) {
        return (CodePointer)sourceSp.readWord(-AMD64FrameAccess.returnAddressSize());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeReturnAddress(Pointer sourceSp, CodePointer newReturnAddress) {
        sourceSp.writeWord(-AMD64FrameAccess.returnAddressSize(), (WordBase)newReturnAddress);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer getReturnAddressLocation(Pointer sourceSp) {
        return sourceSp.subtract(AMD64FrameAccess.returnAddressSize());
    }

    @Override
    @Fold
    public int savedBasePointerSize() {
        if (SubstrateOptions.PreserveFramePointer.getValue().booleanValue()) {
            return AMD64FrameAccess.wordSize();
        }
        return 0;
    }

    @Override
    @Fold
    public int stackPointerAdjustmentOnCall() {
        return AMD64FrameAccess.wordSize();
    }
}

