/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public abstract class FrameAccess {
    @Fold
    public static FrameAccess singleton() {
        return (FrameAccess)ImageSingletons.lookup(FrameAccess.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract CodePointer readReturnAddress(Pointer var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract void writeReturnAddress(Pointer var1, CodePointer var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract Pointer getReturnAddressLocation(Pointer var1);

    @Fold
    public static int returnAddressSize() {
        Architecture arch = ConfigurationValues.getTarget().arch;
        if (arch instanceof AArch64) {
            return FrameAccess.wordSize();
        }
        return arch.getReturnAddressSize();
    }

    @Fold
    public abstract int stackPointerAdjustmentOnCall();

    public abstract int savedBasePointerSize();

    @Fold
    public static int wordSize() {
        return ConfigurationValues.getTarget().arch.getWordSize();
    }

    @Fold
    public static int uncompressedReferenceSize() {
        return FrameAccess.wordSize();
    }

    public static JavaKind getWordKind() {
        return ConfigurationValues.getTarget().wordJavaKind;
    }

    public static Stamp getWordStamp() {
        return StampFactory.forKind((JavaKind)ConfigurationValues.getTarget().wordJavaKind);
    }
}

