/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.BootModuleLayerSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.ResourcesFeature;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.module.Configuration;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolutionException;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ModuleLayerFeature
implements Feature {
    private Constructor<ModuleLayer> moduleLayerConstructor;
    private Field moduleLayerNameToModuleField;
    private Field moduleLayerParentsField;
    private ModuleLayerFeatureUtils moduleLayerFeatureUtils;

    public void duringSetup(Feature.DuringSetupAccess access) {
        FeatureImpl.DuringSetupAccessImpl accessImpl = (FeatureImpl.DuringSetupAccessImpl)access;
        this.moduleLayerConstructor = ReflectionUtil.lookupConstructor(ModuleLayer.class, (Class[])new Class[]{Configuration.class, List.class, Function.class});
        this.moduleLayerNameToModuleField = ReflectionUtil.lookupField(ModuleLayer.class, (String)"nameToModule");
        this.moduleLayerParentsField = ReflectionUtil.lookupField(ModuleLayer.class, (String)"parents");
        this.moduleLayerFeatureUtils = new ModuleLayerFeatureUtils(accessImpl.imageClassLoader);
        Set<String> baseModules = ModuleLayer.boot().modules().stream().map(Module::getName).collect(Collectors.toSet());
        ModuleLayer runtimeBootLayer = this.synthesizeRuntimeBootLayer(accessImpl.imageClassLoader, baseModules, Set.of());
        BootModuleLayerSupport.instance().setBootLayer(runtimeBootLayer);
        access.registerObjectReplacer(this::replaceHostedModules);
    }

    private Object replaceHostedModules(Object source) {
        if (source instanceof Module) {
            Module module = (Module)source;
            return this.moduleLayerFeatureUtils.getOrCreateRuntimeModuleForHostedModule(module, module.getDescriptor());
        }
        return source;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(BootModuleLayerSupport.class, (Object)new BootModuleLayerSupport());
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        FeatureImpl.AfterAnalysisAccessImpl accessImpl = (FeatureImpl.AfterAnalysisAccessImpl)access;
        AnalysisUniverse universe = accessImpl.getUniverse();
        Stream<Module> analysisReachableModules = universe.getTypes().stream().filter(t -> t.isReachable() && !t.isArray()).map(t -> t.getJavaClass().getModule()).distinct();
        Set<Module> analysisReachableNamedModules = analysisReachableModules.filter(Module::isNamed).collect(Collectors.toSet());
        HashSet<String> extraModules = new HashSet<String>();
        extraModules.addAll(((ResourcesFeature)ImageSingletons.lookup(ResourcesFeature.class)).includedResourcesModules);
        String explicitlyAddedModules = System.getProperty("org.graalvm.nativeimage.module.addmods", "");
        if (!explicitlyAddedModules.isEmpty()) {
            extraModules.addAll(Arrays.asList(SubstrateUtil.split(explicitlyAddedModules, ",")));
        }
        extraModules.forEach(moduleName -> {
            Optional<Module> module = accessImpl.imageClassLoader.findModule((String)moduleName);
            if (module.isEmpty()) {
                VMError.shouldNotReachHere("Explicitly required module " + moduleName + " is not available");
            }
            analysisReachableNamedModules.add(module.get());
        });
        Set<Module> analysisReachableSyntheticModules = analysisReachableNamedModules.stream().filter(ModuleLayerFeature::isModuleSynthetic).collect(Collectors.toSet());
        Set<String> allReachableModules = analysisReachableNamedModules.stream().flatMap(ModuleLayerFeature::extractRequiredModuleNames).collect(Collectors.toSet());
        ModuleLayer runtimeBootLayer = this.synthesizeRuntimeBootLayer(accessImpl.imageClassLoader, allReachableModules, analysisReachableSyntheticModules);
        BootModuleLayerSupport.instance().setBootLayer(runtimeBootLayer);
        this.replicateVisibilityModifications(runtimeBootLayer, accessImpl.imageClassLoader, analysisReachableNamedModules);
    }

    private static Stream<String> extractRequiredModuleNames(Module m) {
        Stream<String> requiredModules = m.getDescriptor().requires().stream().map(ModuleDescriptor.Requires::name);
        return Stream.concat(Stream.of(m.getName()), requiredModules);
    }

    private ModuleLayer synthesizeRuntimeBootLayer(ImageClassLoader cl, Set<String> reachableModules, Set<Module> syntheticModules) {
        NativeImageClassLoaderSupport classLoaderSupport = cl.classLoaderSupport;
        ModuleFinder beforeFinder = classLoaderSupport.modulepathModuleFinder;
        ModuleFinder afterFinder = classLoaderSupport.upgradeAndSystemModuleFinder;
        Configuration cf = ModuleLayerFeature.synthesizeRuntimeBootLayerConfiguration(beforeFinder, afterFinder, reachableModules);
        try {
            ModuleLayer runtimeBootLayer = this.moduleLayerConstructor.newInstance(cf, List.of(), null);
            Map<String, Module> nameToModule = this.moduleLayerFeatureUtils.synthesizeNameToModule(runtimeBootLayer);
            for (Module syntheticModule : syntheticModules) {
                Module runtimeSyntheticModule = this.moduleLayerFeatureUtils.getOrCreateRuntimeModuleForHostedModule(syntheticModule.getName(), syntheticModule.getDescriptor());
                nameToModule.putIfAbsent(runtimeSyntheticModule.getName(), runtimeSyntheticModule);
                this.moduleLayerFeatureUtils.patchModuleLayerField(runtimeSyntheticModule, runtimeBootLayer);
            }
            this.patchRuntimeBootLayer(runtimeBootLayer, nameToModule);
            return runtimeBootLayer;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw VMError.shouldNotReachHere("Failed to synthesize the runtime boot module layer.", ex);
        }
    }

    private void replicateVisibilityModifications(ModuleLayer runtimeBootLayer, ImageClassLoader cl, Set<Module> analysisReachableNamedModules) {
        List<Module> applicationModules = ModuleLayerFeature.findApplicationModules(runtimeBootLayer, cl.applicationModulePath());
        Map<String, HostedRuntimeModulePair> moduleLookupMap = analysisReachableNamedModules.stream().collect(Collectors.toMap(Module::getName, m -> new HostedRuntimeModulePair((Module)m, runtimeBootLayer)));
        moduleLookupMap.putIfAbsent("ALL-UNNAMED", HostedRuntimeModulePair.withReplicatedHostedModule(this.moduleLayerFeatureUtils.allUnnamedModule));
        moduleLookupMap.putIfAbsent("EVERYONE", HostedRuntimeModulePair.withReplicatedHostedModule(this.moduleLayerFeatureUtils.everyoneModule));
        Module builderModule = ModuleLayerFeature.class.getModule();
        assert (builderModule != null);
        try {
            for (Map.Entry<String, HostedRuntimeModulePair> e1 : moduleLookupMap.entrySet()) {
                Module hostedFrom = e1.getValue().hostedModule;
                if (!hostedFrom.isNamed()) continue;
                Module runtimeFrom = e1.getValue().runtimeModule;
                for (Map.Entry<String, HostedRuntimeModulePair> e2 : moduleLookupMap.entrySet()) {
                    Module hostedTo = e2.getValue().hostedModule;
                    if (hostedTo == hostedFrom) continue;
                    Module runtimeTo = e2.getValue().runtimeModule;
                    if (ModuleLayerFeature.isModuleSynthetic(hostedFrom) || hostedFrom.canRead(hostedTo)) {
                        this.moduleLayerFeatureUtils.addReads(runtimeFrom, runtimeTo);
                        if (hostedFrom == builderModule) {
                            for (Module appModule : applicationModules) {
                                this.moduleLayerFeatureUtils.addReads(appModule, runtimeTo);
                            }
                        }
                    }
                    for (String pn : runtimeFrom.getPackages()) {
                        if (ModuleLayerFeature.isModuleSynthetic(hostedFrom) || hostedFrom.isOpen(pn, hostedTo)) {
                            this.moduleLayerFeatureUtils.addOpens(runtimeFrom, pn, runtimeTo);
                            if (hostedTo == builderModule) {
                                for (Module appModule : applicationModules) {
                                    this.moduleLayerFeatureUtils.addOpens(runtimeFrom, pn, appModule);
                                }
                            }
                        }
                        if (!ModuleLayerFeature.isModuleSynthetic(hostedFrom) && !hostedFrom.isExported(pn, hostedTo)) continue;
                        this.moduleLayerFeatureUtils.addExports(runtimeFrom, pn, runtimeTo);
                        if (hostedTo != builderModule) continue;
                        for (Module appModule : applicationModules) {
                            this.moduleLayerFeatureUtils.addExports(runtimeFrom, pn, appModule);
                        }
                    }
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw VMError.shouldNotReachHere("Failed to transfer hosted module relations to the runtime boot module layer.", ex);
        }
    }

    private static boolean isModuleSynthetic(Module m) {
        return m.getDescriptor().modifiers().contains((Object)ModuleDescriptor.Modifier.SYNTHETIC);
    }

    private static List<Module> findApplicationModules(ModuleLayer runtimeBootLayer, List<Path> applicationModulePath) {
        List applicationModuleNames;
        ArrayList<Module> applicationModules = new ArrayList<Module>();
        try {
            ModuleFinder applicationModuleFinder = ModuleFinder.of((Path[])applicationModulePath.toArray(Path[]::new));
            applicationModuleNames = applicationModuleFinder.findAll().stream().map(m -> m.descriptor().name()).collect(Collectors.toList());
        }
        catch (SecurityException | FindException | ResolutionException ex) {
            throw VMError.shouldNotReachHere("Failed to locate application modules.", ex);
        }
        for (String moduleName : applicationModuleNames) {
            Optional<Module> module = runtimeBootLayer.findModule(moduleName);
            if (module.isEmpty()) continue;
            applicationModules.add(module.get());
        }
        return applicationModules;
    }

    private static Configuration synthesizeRuntimeBootLayerConfiguration(ModuleFinder beforeFinder, ModuleFinder afterFinder, Set<String> reachableModules) {
        try {
            ModuleFinder composed = ModuleFinder.compose(beforeFinder, afterFinder);
            ArrayList<String> missingModules = new ArrayList<String>();
            for (String module : reachableModules) {
                Optional<ModuleReference> mref = composed.find(module);
                if (!mref.isEmpty()) continue;
                missingModules.add(module);
            }
            reachableModules.removeAll(missingModules);
            return Configuration.empty().resolve(beforeFinder, afterFinder, reachableModules);
        }
        catch (SecurityException | FindException | ResolutionException ex) {
            throw VMError.shouldNotReachHere("Failed to synthesize the runtime boot module layer configuration.", ex);
        }
    }

    private void patchRuntimeBootLayer(ModuleLayer runtimeBootLayer, Map<String, Module> nameToModule) {
        try {
            this.moduleLayerNameToModuleField.set(runtimeBootLayer, nameToModule);
            this.moduleLayerParentsField.set(runtimeBootLayer, List.of(ModuleLayer.empty()));
            for (Module m : runtimeBootLayer.modules()) {
                Optional<Module> hostedModule = ModuleLayer.boot().findModule(m.getName());
                if (!hostedModule.isPresent() || hostedModule.get().getClassLoader() != null) continue;
                this.moduleLayerFeatureUtils.patchModuleLoaderField(m, null);
            }
        }
        catch (IllegalAccessException ex) {
            throw VMError.shouldNotReachHere("Failed to patch the runtime boot module layer.", ex);
        }
        runtimeBootLayer.modules();
    }

    private static final class ModuleLayerFeatureUtils {
        private final Map<String, Module> nameToModuleLookup = new HashMap<String, Module>();
        private final ImageClassLoader imageClassLoader;
        private final Module allUnnamedModule;
        private final Set<Module> allUnnamedModuleSet;
        private final Module everyoneModule;
        private final Set<Module> everyoneSet;
        private final Constructor<Module> moduleConstructor;
        private final Field moduleDescriptorField;
        private final Field moduleLayerField;
        private final Field moduleLoaderField;
        private final Field moduleReadsField;
        private final Field moduleOpenPackagesField;
        private final Field moduleExportedPackagesField;
        private final Method moduleFindModuleMethod;

        ModuleLayerFeatureUtils(ImageClassLoader cl) {
            this.imageClassLoader = cl;
            Method classGetDeclaredMethods0Method = ReflectionUtil.lookupMethod(Class.class, (String)"getDeclaredFields0", (Class[])new Class[]{Boolean.TYPE});
            try {
                ModuleSupport.openModuleByClass(Module.class, ModuleLayerFeature.class);
                Field[] moduleClassFields = (Field[])classGetDeclaredMethods0Method.invoke(Module.class, false);
                Field everyoneModuleField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "EVERYONE_MODULE");
                everyoneModuleField.setAccessible(true);
                this.everyoneModule = (Module)everyoneModuleField.get(null);
                Field allUnnamedModuleField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "ALL_UNNAMED_MODULE");
                allUnnamedModuleField.setAccessible(true);
                this.allUnnamedModule = (Module)allUnnamedModuleField.get(null);
                this.moduleDescriptorField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "descriptor");
                this.moduleLayerField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "layer");
                this.moduleLoaderField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "loader");
                this.moduleReadsField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "reads");
                this.moduleOpenPackagesField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "openPackages");
                this.moduleExportedPackagesField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "exportedPackages");
                this.moduleDescriptorField.setAccessible(true);
                this.moduleLayerField.setAccessible(true);
                this.moduleLoaderField.setAccessible(true);
                this.moduleReadsField.setAccessible(true);
                this.moduleOpenPackagesField.setAccessible(true);
                this.moduleExportedPackagesField.setAccessible(true);
                this.allUnnamedModuleSet = new HashSet<Module>();
                this.allUnnamedModuleSet.add(this.allUnnamedModule);
                this.patchModuleLoaderField(this.allUnnamedModule, this.imageClassLoader.getClassLoader());
                this.everyoneSet = new HashSet<Module>();
                this.everyoneSet.add(this.everyoneModule);
                this.moduleConstructor = ReflectionUtil.lookupConstructor(Module.class, (Class[])new Class[]{ClassLoader.class, ModuleDescriptor.class});
                this.moduleFindModuleMethod = ReflectionUtil.lookupMethod(Module.class, (String)"findModule", (Class[])new Class[]{String.class, Map.class, Map.class, List.class});
            }
            catch (ReflectiveOperationException | NoSuchElementException ex) {
                throw VMError.shouldNotReachHere("Failed to retrieve fields of the Module class.", ex);
            }
        }

        private static Field findFieldByName(Field[] fields, String name) {
            return Arrays.stream(fields).filter(f -> f.getName().equals(name)).findAny().orElseThrow(VMError::shouldNotReachHere);
        }

        public Module getOrCreateRuntimeModuleForHostedModule(Module hostedModule, ModuleDescriptor runtimeModuleDescriptor) {
            if (hostedModule.isNamed()) {
                return this.getOrCreateRuntimeModuleForHostedModule(hostedModule.getName(), runtimeModuleDescriptor);
            }
            if (hostedModule == this.everyoneModule) {
                return this.everyoneModule;
            }
            return this.allUnnamedModule;
        }

        public Module getOrCreateRuntimeModuleForHostedModule(String hostedModuleName, ModuleDescriptor runtimeModuleDescriptor) {
            Module runtimeModule;
            if (this.nameToModuleLookup.containsKey(hostedModuleName)) {
                return this.nameToModuleLookup.get(hostedModuleName);
            }
            try {
                runtimeModule = this.moduleConstructor.newInstance(this.imageClassLoader.getClassLoader(), runtimeModuleDescriptor);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw VMError.shouldNotReachHere("Failed to reflectively construct a runtime Module object.", ex);
            }
            this.nameToModuleLookup.put(hostedModuleName, runtimeModule);
            return runtimeModule;
        }

        Map<String, Module> synthesizeNameToModule(ModuleLayer runtimeBootLayer) throws IllegalAccessException, InvocationTargetException {
            Module m;
            ModuleDescriptor descriptor;
            ModuleReference mref;
            Configuration cf = runtimeBootLayer.configuration();
            int cap = (int)((float)cf.modules().size() / 0.75f + 1.0f);
            HashMap<String, Module> nameToModule = new HashMap<String, Module>(cap);
            for (ResolvedModule resolvedModule : cf.modules()) {
                String name;
                mref = resolvedModule.reference();
                descriptor = mref.descriptor();
                if (!descriptor.equals((m = this.getOrCreateRuntimeModuleForHostedModule(name = descriptor.name(), descriptor)).getDescriptor())) {
                    this.moduleDescriptorField.set(m, descriptor);
                }
                this.patchModuleLayerField(m, runtimeBootLayer);
                nameToModule.put(name, m);
            }
            for (ResolvedModule resolvedModule : cf.modules()) {
                String source;
                mref = resolvedModule.reference();
                descriptor = mref.descriptor();
                String mn = descriptor.name();
                m = (Module)nameToModule.get(mn);
                assert (m != null);
                HashSet<Module> reads = new HashSet<Module>();
                for (ResolvedModule resolvedModule2 : resolvedModule.reads()) {
                    Module m2 = (Module)nameToModule.get(resolvedModule2.name());
                    reads.add(m2);
                }
                if (descriptor.isAutomatic()) {
                    reads.add(this.allUnnamedModule);
                }
                this.moduleReadsField.set(m, reads);
                if (descriptor.isOpen() || descriptor.isAutomatic()) continue;
                if (descriptor.opens().isEmpty()) {
                    HashMap<String, Set<Object>> exportedPackages = new HashMap<String, Set<Object>>();
                    for (ModuleDescriptor.Exports exports : m.getDescriptor().exports()) {
                        String source2 = exports.source();
                        if (exports.isQualified()) {
                            HashSet<Module> targets = new HashSet<Module>();
                            for (String string : exports.targets()) {
                                Module m2 = (Module)nameToModule.get(string);
                                if (m2 == null) continue;
                                targets.add(m2);
                            }
                            if (targets.isEmpty()) continue;
                            exportedPackages.put(source2, targets);
                            continue;
                        }
                        exportedPackages.put(source2, this.everyoneSet);
                    }
                    this.moduleExportedPackagesField.set(m, exportedPackages);
                    continue;
                }
                HashMap<String, Set<Object>> openPackages = new HashMap<String, Set<Object>>();
                HashMap<String, Set<Object>> hashMap = new HashMap<String, Set<Object>>();
                for (ModuleDescriptor.Opens opens : descriptor.opens()) {
                    source = opens.source();
                    if (opens.isQualified()) {
                        HashSet<Module> targets = new HashSet<Module>();
                        for (String target2 : opens.targets()) {
                            Module m2 = (Module)this.moduleFindModuleMethod.invoke(null, target2, Map.of(), nameToModule, runtimeBootLayer.parents());
                            if (m2 == null) continue;
                            targets.add(m2);
                        }
                        if (targets.isEmpty()) continue;
                        openPackages.put(source, targets);
                        continue;
                    }
                    openPackages.put(source, this.everyoneSet);
                }
                for (ModuleDescriptor.Exports exports : descriptor.exports()) {
                    source = exports.source();
                    Set openToTargets = (Set)openPackages.get(source);
                    if (openToTargets != null && openToTargets.contains(this.everyoneModule)) continue;
                    if (exports.isQualified()) {
                        HashSet<Module> hashSet = new HashSet<Module>();
                        for (String target : exports.targets()) {
                            Module m2 = (Module)this.moduleFindModuleMethod.invoke(null, target, Map.of(), nameToModule, runtimeBootLayer.parents());
                            if (m2 == null || openToTargets != null && openToTargets.contains(m2)) continue;
                            hashSet.add(m2);
                        }
                        if (hashSet.isEmpty()) continue;
                        hashMap.put(source, hashSet);
                        continue;
                    }
                    hashMap.put(source, this.everyoneSet);
                }
                this.moduleOpenPackagesField.set(m, openPackages);
                this.moduleExportedPackagesField.set(m, hashMap);
            }
            return nameToModule;
        }

        void addReads(Module module, Module other) throws IllegalAccessException {
            HashSet<Module> reads = (HashSet<Module>)this.moduleReadsField.get(module);
            if (reads == null) {
                reads = new HashSet<Module>();
                this.moduleReadsField.set(module, reads);
            }
            reads.add(other == null ? this.allUnnamedModule : other);
        }

        void addExports(Module module, String pn, Module other) throws IllegalAccessException {
            Set prev;
            if (other != null && module.isExported(pn, other)) {
                return;
            }
            HashMap<String, Set<Module>> exports = (HashMap<String, Set<Module>>)this.moduleExportedPackagesField.get(module);
            if (exports == null) {
                exports = new HashMap<String, Set<Module>>();
                this.moduleExportedPackagesField.set(module, exports);
            }
            if (other == null) {
                prev = exports.putIfAbsent(pn, this.allUnnamedModuleSet);
            } else {
                HashSet<Module> targets = new HashSet<Module>();
                targets.add(other);
                prev = exports.putIfAbsent(pn, targets);
            }
            if (prev != null) {
                prev.add(other == null ? this.allUnnamedModule : other);
            }
        }

        void addOpens(Module module, String pn, Module other) throws IllegalAccessException {
            Set prev;
            if (other != null && module.isOpen(pn, other)) {
                return;
            }
            HashMap<String, Set<Module>> opens = (HashMap<String, Set<Module>>)this.moduleOpenPackagesField.get(module);
            if (opens == null) {
                opens = new HashMap<String, Set<Module>>();
                this.moduleOpenPackagesField.set(module, opens);
            }
            if (other == null) {
                prev = opens.putIfAbsent(pn, this.allUnnamedModuleSet);
            } else {
                HashSet<Module> targets = new HashSet<Module>();
                targets.add(other);
                prev = opens.putIfAbsent(pn, targets);
            }
            if (prev != null) {
                prev.add(other == null ? this.allUnnamedModule : other);
            }
        }

        void patchModuleLayerField(Module module, ModuleLayer runtimeBootLayer) throws IllegalAccessException {
            this.moduleLayerField.set(module, runtimeBootLayer);
        }

        void patchModuleLoaderField(Module module, ClassLoader loader) throws IllegalAccessException {
            this.moduleLoaderField.set(module, loader);
        }
    }

    private static final class HostedRuntimeModulePair {
        final Module hostedModule;
        final Module runtimeModule;

        static HostedRuntimeModulePair withReplicatedHostedModule(Module module) {
            return new HostedRuntimeModulePair(module, module);
        }

        HostedRuntimeModulePair(Module hostedModule, ModuleLayer runtimeBootLayer) {
            this.hostedModule = hostedModule;
            this.runtimeModule = runtimeBootLayer.findModule(hostedModule.getName()).orElseThrow(() -> HostedRuntimeModulePair.errorSupplier(hostedModule));
        }

        private HostedRuntimeModulePair(Module hosted, Module runtime) {
            this.hostedModule = hosted;
            this.runtimeModule = runtime;
        }

        static RuntimeException errorSupplier(Module m) {
            return VMError.shouldNotReachHere("Failed to find module " + m.getName() + " in the runtime boot module layer");
        }
    }
}

