/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.ArrayIndexOfNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

@Platforms(value={Platform.AMD64.class})
class AMD64ArrayIndexOfForeignCalls {
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = (SnippetRuntime.SubstrateForeignCallDescriptor[])Arrays.stream(ArrayIndexOf.STUBS_AMD64).filter(x -> Arrays.stream(ArrayIndexOf.STUBS_AARCH64).noneMatch(y -> y == x)).map(call -> SnippetRuntime.findForeignCall(AMD64ArrayIndexOfForeignCalls.class, call.getName(), true, new LocationIdentity[0])).toArray(SnippetRuntime.SubstrateForeignCallDescriptor[]::new);

    AMD64ArrayIndexOfForeignCalls() {
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfB2S1(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfB3S1(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfB4S1(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfB2S2(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfB3S2(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfB4S2(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfC2S2(char[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S2, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfC3S2(char[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S2, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfC4S2(char[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S2, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S1(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S1(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S1(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S2(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S2(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S2(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S4(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S4, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S4(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S4, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S4(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S4, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskBS1(byte[] array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)mask1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskBS2(byte[] array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)mask1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskBS1(byte[] array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S1, (boolean)true, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)v2, (int)mask1, (int)mask2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskBS2(byte[] array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S2, (boolean)true, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)v2, (int)mask1, (int)mask2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskCS2(char[] array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S2, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)mask1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskCS2(char[] array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S2, (JavaKind)ArrayIndexOf.S2, (boolean)true, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)v2, (int)mask1, (int)mask2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS1(Object array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)mask1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS2(Object array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)mask1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS4(Object array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S4, (boolean)false, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)mask1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS1(Object array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S1, (boolean)true, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)v2, (int)mask1, (int)mask2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS2(Object array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S2, (boolean)true, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)v2, (int)mask1, (int)mask2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS4(Object array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S4, (boolean)true, (boolean)true, (Object)array, (long)offset, (int)length, (int)fromIndex, (int)v1, (int)v2, (int)mask1, (int)mask2);
    }
}

