/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.config.ConfigurationValues;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeReader;

public class ByteArrayReader {
    public static int getS1(byte[] data, long byteIndex) {
        return UnsafeArrayTypeReader.getS1((byte[])data, (long)byteIndex);
    }

    public static int getU1(byte[] data, long byteIndex) {
        return UnsafeArrayTypeReader.getU1((byte[])data, (long)byteIndex);
    }

    public static int getS2(byte[] data, long byteIndex) {
        return UnsafeArrayTypeReader.getS2((byte[])data, (long)byteIndex, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
    }

    public static int getU2(byte[] data, long byteIndex) {
        return UnsafeArrayTypeReader.getU2((byte[])data, (long)byteIndex, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
    }

    public static int getS4(byte[] data, long byteIndex) {
        return UnsafeArrayTypeReader.getS4((byte[])data, (long)byteIndex, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
    }

    public static long getU4(byte[] data, long byteIndex) {
        return UnsafeArrayTypeReader.getU4((byte[])data, (long)byteIndex, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
    }

    public static long getS8(byte[] data, long byteIndex) {
        return UnsafeArrayTypeReader.getS8((byte[])data, (long)byteIndex, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
    }

    @Fold
    public static boolean supportsUnalignedMemoryAccess() {
        return ConfigurationValues.getTarget().arch.supportsUnalignedMemoryAccess();
    }
}

