/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;

final class IgnoreSIGPIPEStartupHook
implements RuntimeSupport.Hook {
    IgnoreSIGPIPEStartupHook() {
    }

    @Override
    public void execute(boolean isFirstIsolate) {
        if (isFirstIsolate) {
            Signal.SignalDispatcher signalResult = PosixUtils.installSignalHandler(Signal.SignalEnum.SIGPIPE.getCValue(), Signal.SIG_IGN());
            VMError.guarantee(signalResult != Signal.SIG_ERR(), "IgnoreSIGPIPEFeature.run: Could not ignore SIGPIPE");
        }
    }
}

