/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes;

import com.oracle.svm.core.nodes.CFunctionPrologueMarker;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public final class CFunctionPrologueNode
extends FixedWithNextNode
implements Lowerable,
SingleMemoryKill,
ControlFlowAnchored {
    public static final NodeClass<CFunctionPrologueNode> TYPE = NodeClass.create(CFunctionPrologueNode.class);
    private final int newThreadStatus;
    private CFunctionPrologueMarker marker;

    public CFunctionPrologueNode(int newThreadStatus) {
        super(TYPE, StampFactory.forVoid());
        this.newThreadStatus = newThreadStatus;
        this.marker = new CFunctionPrologueMarker(newThreadStatus);
    }

    protected void afterClone(Node other) {
        super.afterClone(other);
        this.marker = new CFunctionPrologueMarker(this.newThreadStatus);
    }

    public CFunctionPrologueMarker getMarker() {
        return this.marker;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public int getNewThreadStatus() {
        return this.newThreadStatus;
    }

    @Node.NodeIntrinsic
    public static native void cFunctionPrologue(@Node.ConstantNodeParameter int var0);
}

